/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.pattern.requestreply;

import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.DefaultMessageFlowEntityFactory;
import org.mule.tooling.messageflow.command.IMessageFlowEntityFactory;
import org.mule.tooling.messageflow.editor.DefinitionsHelper;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;

public class RequestReplyMessageFlowEntityFactory
implements IMessageFlowEntityFactory {
    public IMessageFlowNode create(MuleConfiguration muleConfiguration, IMessageFlowEntity container, NodeDefinition target, IMessageFlowEntity beforeMessageFlowEntity, IMessageFlowEntity afterMessageFlowEntity) {
        if (container instanceof NestedContainer) {
            IMessageFlowNode createdNode;
            NestedContainer containerNode = (NestedContainer)container;
            String containerNodeType = containerNode.getType();
            if (containerNodeType.endsWith("request")) {
                createdNode = this.createInRequest(muleConfiguration, container, target, beforeMessageFlowEntity, afterMessageFlowEntity);
            } else if (containerNodeType.endsWith("reply")) {
                createdNode = this.createInReply(muleConfiguration, container, target, beforeMessageFlowEntity, afterMessageFlowEntity);
            } else {
                throw new IllegalArgumentException("Unknown target container type in request-reply: " + containerNodeType);
            }
            return createdNode;
        }
        throw new IllegalArgumentException("This factory applies to request-reply so the container should always be a NestedContainer");
    }

    private IMessageFlowNode createInRequest(MuleConfiguration muleConfiguration, IMessageFlowEntity container, NodeDefinition target, IMessageFlowEntity beforeMessageFlowEntity, IMessageFlowEntity afterMessageFlowEntity) {
        MessageFlowNode node = null;
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)muleConfiguration);
        if (target instanceof EndpointDefinition) {
            EndpointDefinition endpointDefinition = (EndpointDefinition)target;
            if (endpointDefinition.isSupportsOutbound()) {
                node = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)endpointDefinition, (EndpointDirection)EndpointDirection.OUTBOUND);
            }
        } else {
            node = new DefaultMessageFlowEntityFactory().create(muleConfiguration, container, target, beforeMessageFlowEntity, afterMessageFlowEntity);
        }
        return node;
    }

    IMessageFlowNode createInReply(MuleConfiguration muleConfiguration, IMessageFlowEntity container, NodeDefinition target, IMessageFlowEntity beforeMessageFlowEntity, IMessageFlowEntity afterMessageFlowEntity) {
        PatternDefinition patternDefinition;
        String id;
        EndpointNode endpointNode = null;
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)muleConfiguration);
        if (target instanceof EndpointDefinition) {
            EndpointDefinition endpointDefinition = (EndpointDefinition)target;
            if (endpointDefinition.isSupportsInbound()) {
                endpointNode = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)endpointDefinition, (EndpointDirection)EndpointDirection.INBOUND);
            }
        } else if (target instanceof PatternDefinition && DefinitionsHelper.hasEndpointAlternative((String)(id = (patternDefinition = (PatternDefinition)target).getId()))) {
            String endpointId = DefinitionsHelper.getEndpointAlternative((String)id);
            EndpointDefinition endpointDefinition = (EndpointDefinition)MuleCorePlugin.getModuleManager().getDefinition(endpointId);
            endpointNode = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)endpointDefinition, (EndpointDirection)EndpointDirection.INBOUND);
        }
        return endpointNode;
    }
}

