/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.typeSelection;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.metadata.MetadataTypeGraphicalChildrenProvider;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.CustomMetadataEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.CustomMetadataValidator;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class DetailsComposite
extends Composite {
    private StackLayout detailsLayout;
    private Composite emptyDetailsComposite;
    private Composite detailsContainer;
    private IMuleProject project;
    private OnValidationMessage onValidationMessage;
    private CustomMetadataEditor customMetadataEditor;
    private ChangeManager changeManager;
    private Composite emptyCacheComposite;
    private Composite notCustomMetadataDetails;
    private TreeViewer notCustomMetadataDetailsTree;
    private Optional<MetadataDefinitionConfiguration> selectedModel;

    public DetailsComposite(Composite parent, IMuleProject project, OnValidationMessage onValidationMessage, ChangeManager changeManager) {
        super(parent, 0);
        this.project = project;
        this.onValidationMessage = onValidationMessage;
        this.changeManager = changeManager;
        this.selectedModel = Optional.empty();
        this.createControls();
    }

    private void createControls() {
        this.detailsLayout = new StackLayout();
        this.detailsLayout.marginWidth = 0;
        this.detailsLayout.marginHeight = 0;
        this.setLayout((Layout)this.detailsLayout);
        this.createDetailsContainer(this);
        this.createEmptyDetailsComposite(this);
        this.createEmptyCacheDetailsComposite(this);
        this.createDetailsForNotCustomMetadata(this);
        this.updateView();
    }

    private void createDetailsForNotCustomMetadata(DetailsComposite detailsComposite) {
        this.notCustomMetadataDetails = new Composite((Composite)detailsComposite, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(4, 0, 0, 0).applyTo(this.notCustomMetadataDetails);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.notCustomMetadataDetails);
        this.notCustomMetadataDetailsTree = new TreeViewer(this.notCustomMetadataDetails, 68352);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.notCustomMetadataDetailsTree.getTree());
        this.notCustomMetadataDetailsTree.setLabelProvider((IBaseLabelProvider)new GraphicalTreeLabelProvider());
        this.notCustomMetadataDetailsTree.setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
        this.notCustomMetadataDetailsTree.expandToLevel(4);
    }

    private void refreshDetailsTree(GraphicalTreeNode<MetadataType> root) {
        this.notCustomMetadataDetailsTree.setInput(root);
        this.notCustomMetadataDetailsTree.expandToLevel(4);
    }

    protected GraphicalTreeNode<MetadataType> getRoot() {
        MetadataDefinitionConfiguration metadataDefinitionConfiguration;
        MetadataType model;
        if (this.selectedModel.isPresent() && (model = (metadataDefinitionConfiguration = this.selectedModel.get()).getMetadataType()) != null) {
            return new GraphicalTreeNode(null, null, (Object)model, (IGraphicalChildrenProvider)new MetadataTypeGraphicalChildrenProvider());
        }
        MetadataType emptyModel = MetadataEvent.UNKNOWN_EVENT.getPayload();
        return new GraphicalTreeNode(null, null, null, (Object)emptyModel, (IGraphicalChildrenProvider)new MetadataTypeGraphicalChildrenProvider());
    }

    private void updateView() {
        ITypesManager typesManager = ((MetadataTypesManager)this.project.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
        if (typesManager.isEmpty()) {
            this.showEditor(this.emptyCacheComposite);
        } else if (this.selectedModel.isPresent()) {
            MetadataDefinitionConfiguration config = this.selectedModel.get();
            if (this.isCustomType(config)) {
                this.showEditor(this.detailsContainer);
                this.customMetadataEditor.setFocus();
            } else {
                this.showEditor(this.notCustomMetadataDetails);
            }
        } else {
            this.showEditor(this.emptyDetailsComposite);
        }
    }

    private void showEditor(Composite control) {
        this.detailsLayout.topControl = control;
        this.layout(true, true);
    }

    private Composite createEmptyDetailsComposite(Composite editorWrapper) {
        this.emptyDetailsComposite = new Composite(editorWrapper, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.emptyDetailsComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.emptyDetailsComposite);
        Label emptyCacheLabel = new Label(this.emptyDetailsComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)emptyCacheLabel);
        emptyCacheLabel.setText("Nothing selected to display.");
        return this.emptyDetailsComposite;
    }

    private Composite createEmptyCacheDetailsComposite(Composite editorWrapper) {
        this.emptyCacheComposite = new Composite(editorWrapper, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.emptyCacheComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.emptyCacheComposite);
        Label emptyCacheLabel = new Label(this.emptyCacheComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)emptyCacheLabel);
        emptyCacheLabel.setText("Click add new type to start");
        return this.emptyCacheComposite;
    }

    private void createDetailsContainer(Composite parent) {
        this.detailsContainer = new Composite(parent, 0);
        this.customMetadataEditor = new CustomMetadataEditor(this.detailsContainer, this.project, this.onValidationMessage, this.changeManager, new CustomMetadataValidator(this.project), null);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.customMetadataEditor);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.customMetadataEditor);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.detailsContainer);
        GridLayoutFactory.fillDefaults().extendedMargins(4, 0, 0, 0).applyTo(this.detailsContainer);
    }

    public void setModel(MetadataDefinitionConfiguration selectedModel) {
        this.selectedModel = Optional.ofNullable(selectedModel);
        if (this.isCustomType(selectedModel)) {
            this.updateCustomDetailsModel();
        } else {
            this.refreshDetailsTree(this.getRoot());
        }
        this.updateView();
    }

    private boolean isCustomType(MetadataDefinitionConfiguration selectedModel) {
        return selectedModel != null && "#Custom Type#".equals(selectedModel.getModule());
    }

    private void updateCustomDetailsModel() {
        MetadataDefinitionConfiguration config;
        String selectedKey;
        if (this.selectedModel.isPresent() && StringUtils.isNotBlank((String)(selectedKey = (config = this.selectedModel.get()).getKey()))) {
            this.customMetadataEditor.setEditingKey(selectedKey);
        }
    }

    public MetadataResult getResult() {
        return this.customMetadataEditor.getResult();
    }

    public IMetadataDefinitionValidator getValidator() {
        return this.customMetadataEditor.getValidator();
    }

    public void onRefresh() {
        if (this.customMetadataEditor != null) {
            this.customMetadataEditor.onRefresh();
        }
    }

    public void applyChanges() {
        if (this.customMetadataEditor != null) {
            this.customMetadataEditor.applyChanges();
        }
    }
}

