/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.typeSelection;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.CustomMetadataValidator;
import org.mule.tooling.ui.widgets.MessageDecorator;

public class CreateNewTypeDialog
extends Dialog {
    private static final Image ERROR_IMAGE = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    private Text txtTypeId;
    private String typeId = "";
    private CustomMetadataValidator validator;
    private MessageDecorator errorDecoration;
    private Label errorLabel;

    public CreateNewTypeDialog(Shell parentShell, CustomMetadataValidator validator) {
        super(parentShell);
        this.validator = validator;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 10).applyTo(container);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, true).create();
        gridData.heightHint = 70;
        container.setLayoutData((Object)gridData);
        Label lblUser = new Label(container, 0);
        lblUser.setText("Type id:");
        this.txtTypeId = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(300, -1).applyTo((Control)this.txtTypeId);
        this.txtTypeId.setText(this.getTypeId());
        this.txtTypeId.setMessage("Please enter a new type id");
        this.txtTypeId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateNewTypeDialog.this.validateTypeId();
            }
        });
        this.errorDecoration = new MessageDecorator(container, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000008).grab(false, false).applyTo((Control)this.errorDecoration);
        this.errorDecoration.setImage(ERROR_IMAGE);
        this.errorDecoration.hide();
        this.errorLabel = new Label(container, 64);
        GridDataFactory.fillDefaults().span(3, 2).grab(true, false).applyTo((Control)this.errorLabel);
        this.errorLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
        return container;
    }

    private void validateTypeId() {
        if (this.isValidTypeId()) {
            this.errorDecoration.hide();
            this.errorLabel.setVisible(false);
        } else {
            String id = this.txtTypeId.getText();
            String validationMessage = this.validator.getValidationMessage("#Custom Type#", id, id);
            this.errorDecoration.setDescriptionText(validationMessage);
            this.errorDecoration.show();
            this.errorLabel.setText(validationMessage);
            this.errorLabel.setVisible(true);
        }
        this.errorLabel.getParent().layout(true, true);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Create type", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create new type");
    }

    protected void okPressed() {
        if (this.isValidTypeId()) {
            this.typeId = this.txtTypeId.getText();
            super.okPressed();
        } else {
            this.validateTypeId();
        }
    }

    private boolean isValidTypeId() {
        return this.validator.isValidKey("#Custom Type#", this.txtTypeId.getText());
    }

    public String getTypeId() {
        return this.typeId;
    }
}

