/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.typeSelection;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.metadata.datasense.SimpleTypeMetadataTypeUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.CustomMetadataValidator;
import org.mule.tooling.ui.modules.core.metadata.management.DeleteAction;
import org.mule.tooling.ui.modules.core.metadata.management.MetadataTypeTreeNodeModel;
import org.mule.tooling.ui.modules.core.metadata.management.MetadataTypesTreeProvider;
import org.mule.tooling.ui.modules.core.metadata.management.NodeSelectionProvider;
import org.mule.tooling.ui.modules.core.metadata.typeSelection.CreateNewTypeDialog;
import org.mule.tooling.ui.modules.core.metadata.typeSelection.DetailsComposite;
import org.mule.tooling.ui.modules.core.metadata.typeSelection.TypeSelectionListener;
import org.mule.tooling.ui.modules.core.widgets.editors.DataSenseTypeChangedEvent;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class BaseMetadataTypeSelectionEditor
extends Composite {
    private static final String DEFAULT_SIMPLE_TYPE = "string";
    private IMuleProject muleProject;
    private OnValidationMessage onValidationMessage;
    private ChangeManager changeManager;
    private EventBus eventBus;
    private NodeSelectionProvider selectionProvider;
    private List<TypeSelectionListener> typeSelectionListeners = new ArrayList<TypeSelectionListener>();
    private StudioFilteredTree metadataTree;
    private Composite editorComposite;
    private DetailsComposite detailsComposite;
    private ToolBarManager toolbarManager;
    private DeleteAction deleteAction;
    private MetadataTypeTreeNodeModel currentModel;

    public BaseMetadataTypeSelectionEditor(Composite parent, IMuleProject muleProject, OnValidationMessage onValidationMessage, ChangeManager changeManager) {
        super(parent, 0);
        this.muleProject = muleProject;
        this.changeManager = changeManager;
        this.eventBus = MuleCorePlugin.getEventBus();
        this.selectionProvider = new NodeSelectionProvider();
        this.onValidationMessage = onValidationMessage;
        this.createControls(this);
    }

    protected void createControls(Composite parent) {
        this.editorComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editorComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.editorComposite);
        ToolBar toolbar = new ToolBar(this.editorComposite, 0x820000);
        this.toolbarManager = new ToolBarManager(toolbar);
        AddNewTypeAction addNewType = new AddNewTypeAction();
        ActionContributionItem addCI = new ActionContributionItem((IAction)addNewType);
        addCI.setMode(ActionContributionItem.MODE_FORCE_TEXT | 0x20000);
        this.toolbarManager.add((IContributionItem)addCI);
        this.deleteAction = new DeleteAction(this.getShell(), this.muleProject, this.selectionProvider, new OnTypeRemovedCallback());
        ActionContributionItem deleteCI = new ActionContributionItem((IAction)this.deleteAction);
        deleteCI.setMode(ActionContributionItem.MODE_FORCE_TEXT | 0x20000);
        this.toolbarManager.add((IContributionItem)deleteCI);
        ToolBar refreshToolbar = new ToolBar(this.editorComposite, 0x820000);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 4).applyTo((Control)refreshToolbar);
        SashForm sashContainer = new SashForm(this.editorComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)sashContainer);
        this.createMetadataTree((Composite)sashContainer);
        this.createDetailsContainer(sashContainer);
        sashContainer.setWeights(new int[]{50, 50});
        this.refresh();
    }

    private void createDetailsContainer(SashForm parent) {
        this.detailsComposite = new DetailsComposite((Composite)parent, this.getMuleProject(), this.onValidationMessage, this.changeManager);
    }

    private StudioFilteredTree createMetadataTree(Composite parent) {
        this.metadataTree = new StudioFilteredTree(parent, 68352, new PatternFilter());
        this.metadataTree.getViewer().addDoubleClickListener(event -> {
            for (TypeSelectionListener typeSelectionListener : this.typeSelectionListeners) {
                typeSelectionListener.typeDoubleClicked(event.getSelection());
            }
        });
        this.metadataTree.getViewer().addSelectionChangedListener(this::onSelectionChanged);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.metadataTree);
        this.metadataTree.getViewer().setLabelProvider((IBaseLabelProvider)new GraphicalTreeLabelProvider());
        this.metadataTree.getViewer().setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
        this.metadataTree.getViewer().setInput(this.getRoot());
        this.metadataTree.getViewer().expandToLevel(2);
        this.metadataTree.getViewer().getControl().setFocus();
        return this.metadataTree;
    }

    protected void onSelectionChanged(SelectionChangedEvent event) {
        this.saveCurrentModel((TreeSelection)event.getSelection());
        this.checkForEditorChanges();
        this.updateDetails();
        this.updateToolbar(event);
        this.notifySelectionChange(event);
    }

    private void loadModel() {
        TreeItem childNode;
        if (this.currentModel != null && (childNode = this.fetchNewItemFromTree(this.currentModel.getModule(), this.currentModel.getKey())) != null) {
            TreeViewer viewer = this.metadataTree.getViewer();
            viewer.getTree().setSelection(new TreeItem[]{childNode});
            viewer.setSelection(viewer.getSelection(), true);
        }
    }

    private void saveCurrentModel(TreeSelection selection) {
        if (!selection.isEmpty()) {
            MetadataTypeTreeNodeModel model;
            GraphicalTreeNode firstElement = (GraphicalTreeNode)selection.getFirstElement();
            this.currentModel = model = (MetadataTypeTreeNodeModel)firstElement.getModel();
        }
    }

    private void updateToolbar(SelectionChangedEvent event) {
        this.selectionProvider.setSelection(Optional.ofNullable(event.getSelection()));
        this.updateButtons();
    }

    private void updateButtons() {
        GraphicalTreeNode<MetadataTypeTreeNodeModel> treeNode = this.selectionProvider.getGraphicalNodeFromSelection();
        if (treeNode != null) {
            MetadataTypeTreeNodeModel model = (MetadataTypeTreeNodeModel)treeNode.getModel();
            this.deleteAction.setEnabled(model.isDeleteable());
        } else {
            this.deleteAction.setEnabled(false);
        }
        this.toolbarManager.update(true);
        this.getParent().layout();
    }

    private void updateDetails() {
        MetadataDefinitionConfiguration selectedModel = this.getSelectedModel();
        if (selectedModel != null && selectedModel.getMetadataType() != null) {
            this.detailsComposite.setModel(selectedModel);
        } else {
            this.detailsComposite.setModel(null);
        }
    }

    private void notifySelectionChange(SelectionChangedEvent event) {
        for (TypeSelectionListener typeSelectionListener : this.typeSelectionListeners) {
            typeSelectionListener.typeSelected(event.getSelection());
        }
    }

    public void checkForEditorChanges() {
        if (this.changeManager.areChanges()) {
            boolean sure = MessageDialog.openQuestion((Shell)this.getParent().getShell(), (String)"Apply changes", (String)"Do you want to apply changes?");
            if (sure) {
                this.applyChangesInEditor();
            }
            this.changeManager.clearChanges();
            this.metadataTree.getViewer().refresh(true);
            this.metadataTree.getViewer().expandToLevel(2);
            this.loadModel();
        }
    }

    protected void applyChangesInEditor() {
        try {
            MetadataResult metadata = this.detailsComposite.getResult();
            IMetadataDefinitionValidator validator = this.detailsComposite.getValidator();
            if (validator.isValidKey(metadata.getModule(), metadata.getKey())) {
                if (validator.isValidMetadata(metadata)) {
                    this.trackCustomType(metadata);
                    this.detailsComposite.applyChanges();
                    if (validator.requiredSave()) {
                        this.saveNewMetadataType(metadata);
                    }
                } else {
                    this.onValidationMessage.setValidationMessage(metadata.getMessage());
                }
            } else {
                this.onValidationMessage.setValidationMessage("Metadata key is not valid or is already used");
            }
        }
        catch (Exception e) {
            this.onValidationMessage.setValidationMessage("Error generating metadata");
            MuleCorePlugin.logError((String)"Error generating metadata", (Throwable)e);
        }
    }

    public void trackCustomType(MetadataResult metadata) {
        if (metadata != null && metadata.getMetadataType() != null) {
            AnalyticsRecordsFactory.single((String)Events.CREATED_CUSTOM_TYPE).addMetadata("customType", metadata.getMetadataType().getMetadataFormat().getId()).track();
        }
    }

    protected void saveNewMetadataType(MetadataResult metadata) {
        ITypesManager typesManager = this.getTypesManager();
        MetadataKey key = ToolingMetadataKeyBuilder.newKey((String)metadata.getKey()).build();
        typesManager.addCustomMetadata(key, metadata.getMetadataType());
        Optional annotation = metadata.getMetadataType().getAnnotation(ExamplePathAnnotation.class);
        if (annotation.isPresent() && ((ExamplePathAnnotation)annotation.get()).getPath().endsWith("json")) {
            typesManager.addCustomMetadataFile(((ExamplePathAnnotation)annotation.get()).getPath().toString(), key);
        }
        typesManager.persist();
        this.eventBus.fireEvent((IEvent)DataSenseTypeChangedEvent.newInstance(this.getMuleProject()));
    }

    protected ITypesManager getTypesManager() {
        return ((MetadataTypesManager)this.getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }

    protected MetadataType getSelectedMetaDataModel() {
        MetadataDefinitionConfiguration model = this.getSelectedModel();
        if (model != null) {
            return model.getMetadataType();
        }
        return null;
    }

    public String getModule() {
        MetadataDefinitionConfiguration model = this.getSelectedModel();
        return model != null ? model.getModule() : null;
    }

    public String getKey() {
        MetadataDefinitionConfiguration model = this.getSelectedModel();
        return model != null ? model.getKey() : null;
    }

    public MetadataDefinitionConfiguration getSelectedModel() {
        GraphicalTreeNode firstElement;
        MetadataDefinitionConfiguration model;
        TreeSelection selection = (TreeSelection)this.getTree().getViewer().getSelection();
        if (!selection.isEmpty() && (model = (MetadataDefinitionConfiguration)(firstElement = (GraphicalTreeNode)selection.getFirstElement()).getModel()) != null) {
            return model;
        }
        return null;
    }

    public void refresh() {
        this.updateButtons();
        this.metadataTree.getViewer().setInput(this.getRoot());
        this.metadataTree.getViewer().refresh(true);
        this.metadataTree.getViewer().expandToLevel(3);
        this.metadataTree.getViewer().getControl().setFocus();
        this.editorComposite.layout();
    }

    private TreeItem fetchNewItemFromTree(String id) {
        return this.fetchNewItemFromTree("#Custom Type#", id);
    }

    private TreeItem fetchNewItemFromTree(String rootId, String id) {
        TreeItem customMetadataNode = this.fetchMetadataRootNode(rootId);
        if (customMetadataNode != null) {
            TreeItem child = this.fetchChildItemById(customMetadataNode, id);
            return child != null ? child : customMetadataNode;
        }
        return null;
    }

    private TreeItem fetchChildItemById(TreeItem customMetadataNode, String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        TreeItem[] treeItemArray = customMetadataNode.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            GraphicalTreeNode data = (GraphicalTreeNode)child.getData();
            if (id.equals(data.getDescription())) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private TreeItem fetchMetadataRootNode(String nodeId) {
        TreeItem[] treeItemArray = this.metadataTree.getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem object = treeItemArray[n2];
            GraphicalTreeNode data = (GraphicalTreeNode)object.getData();
            if (nodeId.equals(data.getDescription())) {
                return object;
            }
            ++n2;
        }
        return null;
    }

    protected IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public StudioFilteredTree getTree() {
        return this.metadataTree;
    }

    public void addTypeSelectionListener(TypeSelectionListener typeSelectionListener) {
        this.typeSelectionListeners.add(typeSelectionListener);
    }

    public ISelection getSelection() {
        return this.metadataTree.getViewer().getSelection();
    }

    public GraphicalTreeNode<MetadataTypeTreeNodeModel> getRoot() {
        return new GraphicalTreeNode(null, null, null, (IGraphicalChildrenProvider)new MetadataTypesTreeProvider(this.getMuleProject()));
    }

    public OnValidationMessage getOnValidationMessage() {
        return this.onValidationMessage;
    }

    public void setOnValidationMessage(OnValidationMessage onValidationMessage) {
        this.onValidationMessage = onValidationMessage;
    }

    private class AddNewTypeAction
    extends Action {
        public AddNewTypeAction() {
            super("Add", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        }

        public void run() {
            CreateNewTypeDialog dialog = new CreateNewTypeDialog(BaseMetadataTypeSelectionEditor.this.getShell(), new CustomMetadataValidator(BaseMetadataTypeSelectionEditor.this.muleProject));
            if (dialog.open() == 0) {
                ITypesManager typesManager = BaseMetadataTypeSelectionEditor.this.getTypesManager();
                String typeId = dialog.getTypeId();
                typesManager.addCustomMetadata(ToolingMetadataKeyBuilder.newKey((String)typeId).build(), SimpleTypeMetadataTypeUtils.buildSimpleType((String)BaseMetadataTypeSelectionEditor.DEFAULT_SIMPLE_TYPE));
                typesManager.persist();
                BaseMetadataTypeSelectionEditor.this.eventBus.fireEvent((IEvent)DataSenseTypeChangedEvent.newInstance(BaseMetadataTypeSelectionEditor.this.muleProject));
                BaseMetadataTypeSelectionEditor.this.refresh();
                BaseMetadataTypeSelectionEditor.this.updateButtons();
                this.selectNewItemInTree(typeId);
            }
        }

        private void selectNewItemInTree(String id) {
            TreeItem childNode = BaseMetadataTypeSelectionEditor.this.fetchNewItemFromTree(id);
            if (childNode != null) {
                TreeViewer viewer = BaseMetadataTypeSelectionEditor.this.metadataTree.getViewer();
                viewer.getTree().setSelection(new TreeItem[]{childNode});
                viewer.setSelection(viewer.getSelection(), true);
            }
        }
    }

    private class OnTypeRemovedCallback
    implements Runnable {
        private OnTypeRemovedCallback() {
        }

        @Override
        public void run() {
            ((MetadataTypesManager)BaseMetadataTypeSelectionEditor.this.muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager().persist();
            BaseMetadataTypeSelectionEditor.this.eventBus.fireEvent((IEvent)DataSenseTypeChangedEvent.newInstance(BaseMetadataTypeSelectionEditor.this.muleProject));
            BaseMetadataTypeSelectionEditor.this.refresh();
            BaseMetadataTypeSelectionEditor.this.updateButtons();
        }
    }
}

