/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.resolver.script;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Operator;
import org.mule.tooling.ui.modules.core.autocomplete.parser.BinaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CollectionAccessNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CommentNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.InlineCollectionNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.KeywordNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MapEntryNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.NumberLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ScriptNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StatementNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StringLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.UnaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.VariableDeclarationNode;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.FieldAccessScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.IMetaDataScriptResolver;

public class VariablesScriptResolver
implements IMetaDataScriptResolver {
    private ObjectType variables;
    private MetadataType result;
    private IMetaDataScriptResolver next;
    private IMuleProject project;

    public VariablesScriptResolver(ObjectType variables, IMuleProject project) {
        this.variables = variables;
        this.project = project;
    }

    @Override
    public void visitIdentifier(IdentifierNode expression) {
        String content = expression.getContent();
        this.result = this.variables.getFieldByName(content).map(field -> field.getValue()).orElse(MetadataFactory.undefined());
    }

    @Override
    public void visitMethodCall(MethodCallNode expression) {
    }

    @Override
    public void visitStringLiteral(StringLiteralNode expression) {
        this.result = this.variables.getFieldByName(expression.getContent()).map(field -> field.getValue()).orElse(MetadataFactory.undefined());
        if (this.result != null) {
            this.next = new FieldAccessScriptResolver(this.result, this.project);
        }
    }

    @Override
    public void visitMapEntry(MapEntryNode mapEntryNode) {
    }

    @Override
    public void visitOperator(BinaryOperatorNode expression) {
        if (expression.getOperator() == Operator.DOT) {
            this.next = this.result == null ? new VariablesScriptResolver(this.variables, this.project) : new FieldAccessScriptResolver(this.result, this.project);
        }
    }

    @Override
    public void visitScriptExpression(ScriptNode expression) {
    }

    @Override
    public void visitKeyword(KeywordNode keywordExpression) {
    }

    @Override
    public void visitUnaryOperator(UnaryOperatorNode unaryOperatorNode) {
    }

    @Override
    public void visitComment(CommentNode commentExpression) {
    }

    @Override
    public void visitNumberLiteral(NumberLiteralNode numberLiteralExpression) {
    }

    @Override
    public void visitStatement(StatementNode statementNode) {
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationNode variableDeclaration) {
    }

    @Override
    public void visitCollectionAccessNode(CollectionAccessNode collectionAccessNode) {
    }

    @Override
    public IMetaDataScriptResolver getNextResolver() {
        return this.next;
    }

    @Override
    public void visitInlineCollectionNode(InlineCollectionNode inlineCollectionNode) {
    }

    @Override
    public MetadataType getMetadataType() {
        return this.result;
    }
}

