/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.resolver.script;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.api.utils.MetadataToBuilder;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ASTNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.parser.BinaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CollectionAccessNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CommentNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.InlineCollectionNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.KeywordNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MapEntryNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.NumberLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ScriptNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StatementNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StringLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.UnaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.VariableDeclarationNode;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.FieldAccessScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.FieldMetaDataScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.IMetaDataScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.IMethodCallMetadataResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.MetadataEventScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.MethodCallMetadataManager;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.VariablesScriptResolver;

public class RootMetadataEventScriptResolver
implements ASTNodeVisitor,
IMetaDataScriptResolver {
    private static final String NULL_LITERAL = "null";
    private static final String TRUE_LITERAL = Boolean.TRUE.toString();
    private static final String FALSE_LITERAL = Boolean.FALSE.toString();
    private IMuleProject muleProject;
    private MetadataEvent metadataEvent;
    private MetadataType metadataType;
    private IMetaDataScriptResolver next;
    private Map<String, FieldMetaDataScriptResolver.FieldType> serverFields;

    public RootMetadataEventScriptResolver(MetadataEvent metadataEvent, IMuleProject muleProject) {
        this.metadataEvent = metadataEvent;
        this.muleProject = muleProject;
        this.metadataType = MetadataFactory.undefined();
        this.loadServerFields();
    }

    private void loadServerFields() {
        this.serverFields = new HashMap<String, FieldMetaDataScriptResolver.FieldType>();
        this.serverFields.put("fileSeparator", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("host", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("ip", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("locale", new FieldMetaDataScriptResolver.StaticFieldType(Locale.class));
        this.serverFields.put("javaVersion", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("javaVendor", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("osName", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("osArch", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("osVersion", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("systemProperties", new FieldMetaDataScriptResolver.StaticFieldType(Map.class));
        this.serverFields.put("timeZone", new FieldMetaDataScriptResolver.StaticFieldType(TimeZone.class));
        this.serverFields.put("userName", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("userHome", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("userDir", new FieldMetaDataScriptResolver.StaticFieldType(String.class));
        this.serverFields.put("dateTime", new FieldMetaDataScriptResolver.LazyFieldType("org.mule.runtime.core.internal.el.datetime.DateTime", this.muleProject));
    }

    @Override
    public void visitStringLiteral(StringLiteralNode expression) {
        this.metadataType = MetadataFactory.STRING_TYPE;
    }

    @Override
    public void visitStatement(StatementNode statementNode) {
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationNode variableDeclaration) {
    }

    @Override
    public void visitScriptExpression(ScriptNode expression) {
    }

    @Override
    public void visitMapEntry(MapEntryNode mapEntryNode) {
    }

    @Override
    public void visitOperator(BinaryOperatorNode expression) {
    }

    @Override
    public void visitNumberLiteral(NumberLiteralNode numberLiteralExpression) {
        this.metadataType = MetadataFactory.NUMBER_TYPE;
    }

    @Override
    public void visitMethodCall(MethodCallNode expression) {
        Optional<IMethodCallMetadataResolver> maybeResolver = MethodCallMetadataManager.getInstance().getResolver(expression);
        maybeResolver.map(r -> r.resolve(expression, this.muleProject, this.metadataType)).orElse(this.metadataType);
    }

    @Override
    public void visitKeyword(KeywordNode keywordExpression) {
    }

    @Override
    public void visitUnaryOperator(UnaryOperatorNode unaryOperatorNode) {
    }

    @Override
    public void visitIdentifier(IdentifierNode expression) {
        String content = expression.getContent();
        if ("vars".equals(content)) {
            this.next = new VariablesScriptResolver(this.metadataEvent.getVariables(), this.muleProject);
        } else if ("payload".equals(content)) {
            this.next = new FieldAccessScriptResolver(this.metadataEvent.getPayload(), this.muleProject);
        } else if (TRUE_LITERAL.equals(content) || FALSE_LITERAL.equals(content)) {
            this.metadataType = MetadataFactory.BOOLEAN_TYPE;
        } else if (NULL_LITERAL.equals(content)) {
            this.metadataType = MetadataFactory.NULL_TYPE;
        } else if ("server".equalsIgnoreCase(content)) {
            this.next = new FieldMetaDataScriptResolver(this.serverFields);
        } else if ("message".equalsIgnoreCase(content)) {
            this.next = this;
        }
    }

    @Override
    public void visitComment(CommentNode commentExpression) {
    }

    @Override
    public void visitCollectionAccessNode(CollectionAccessNode collectionAccessNode) {
    }

    @Override
    public MetadataType getMetadataType() {
        return this.metadataType;
    }

    @Override
    public IMetaDataScriptResolver getNextResolver() {
        return this.next;
    }

    @Override
    public void visitInlineCollectionNode(InlineCollectionNode inlineCollectionNode) {
        if (inlineCollectionNode.getType() == InlineCollectionNode.Type.LIST) {
            MetadataType model;
            MetadataType listMetadataType = MetadataFactory.undefined();
            LinkedList<IASTNode> children = inlineCollectionNode.getChildren();
            if (!children.isEmpty() && (model = new MetadataEventScriptResolver(this.muleProject).resolve(this.metadataEvent, children.get(0))) != null) {
                listMetadataType = model;
            }
            BaseTypeBuilder builder = new BaseTypeBuilder(listMetadataType.getMetadataFormat());
            builder.arrayType().of(listMetadataType);
            this.metadataType = builder.build();
        } else {
            ObjectTypeBuilder builder = MetadataFactory.newBuilder().objectType();
            builder.id("UserDefined");
            LinkedList<IASTNode> children = inlineCollectionNode.getChildren();
            for (MapEntryNode mapEntryNode : CoreUtils.filterByType(children, MapEntryNode.class)) {
                IASTNode left = mapEntryNode.getLeft();
                if (!(left instanceof StringLiteralNode)) continue;
                StringLiteralNode leftString = (StringLiteralNode)left;
                IASTNode right = mapEntryNode.getRight();
                MetadataType resolve = new MetadataEventScriptResolver(this.muleProject).resolve(this.metadataEvent, right);
                if (resolve == null) continue;
                resolve.accept((MetadataTypeVisitor)new MetadataToBuilder(builder.addField().key(leftString.getContent()).value()));
            }
            this.metadataType = builder.build();
        }
    }
}

