/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.resolver.script;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.IMetaDataScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.MetaDataScriptResolverAdapter;
import org.mule.tooling.utils.reflect.ReflectionUtils;

public class ObjectMetaDataScriptResolver
extends MetaDataScriptResolverAdapter {
    private Class<?> className;
    private MetadataType metadataType;
    private IMetaDataScriptResolver next;

    public ObjectMetaDataScriptResolver(String className, IMuleProject muleProject, MetadataType metaDataModel) {
        this(ProjectClasspathUtils.loadClass((String)className, (IMuleProject)muleProject), metaDataModel);
    }

    public ObjectMetaDataScriptResolver(Class<?> className, MetadataType metadataType) {
        this.className = className;
        this.metadataType = metadataType;
    }

    @Override
    public void visitIdentifier(IdentifierNode expression) {
        String fieldName = expression.getContent();
        Field field = ReflectionUtils.searchFieldByName(this.className, (String)fieldName);
        if (field != null) {
            Type declaringClass = field.getGenericType();
            MetadataType metadataType = MetadataUtils.getMetadataFromType((Type)declaringClass, (ClassLoader)field.getType().getClassLoader());
            this.next = new ObjectMetaDataScriptResolver(field.getType(), metadataType);
        }
    }

    @Override
    public void visitMethodCall(MethodCallNode expression) {
        int numberOfArguments;
        String methodName = expression.getContent();
        Method method = ReflectionUtils.searchMethod(this.className, (String)methodName, (int)(numberOfArguments = expression.getNumberOfArguments()));
        if (method != null) {
            Type returnType = method.getGenericReturnType();
            MetadataType metadataType = MetadataUtils.getMetadataFromType((Type)returnType, (ClassLoader)returnType.getClass().getClassLoader());
            this.next = new ObjectMetaDataScriptResolver(method.getReturnType(), metadataType);
        }
    }

    @Override
    public IMetaDataScriptResolver getNextResolver() {
        return this.next;
    }

    @Override
    public MetadataType getMetadataType() {
        return this.metadataType;
    }
}

