/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.resolver.script;

import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ASTNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.parser.BinaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CollectionAccessNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CommentNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContainerAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.InlineCollectionNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.KeywordNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELParser;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MapEntryNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.NumberLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ScriptNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StatementNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StringLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.UnaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.VariableDeclarationNode;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.IMetaDataScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.RootMetadataEventScriptResolver;
import org.mule.tooling.utils.script.ScriptUtils;

public class MetadataEventScriptResolver
implements ASTNodeVisitor {
    private IMetaDataScriptResolver scriptResolver;
    private IMuleProject muleProject;

    public MetadataEventScriptResolver(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public MetadataType resolve(MetadataEvent metadataEvent, String script) {
        String expression = script;
        if (ScriptUtils.isScript((String)script)) {
            expression = ScriptUtils.getScriptContent((String)script);
        }
        MELParser melScriptParser = new MELParser(expression);
        ScriptNode parse = melScriptParser.parse();
        return this.resolve(metadataEvent, parse);
    }

    public MetadataType resolve(MetadataEvent metadataEvent, IASTNode parse) {
        this.scriptResolver = new RootMetadataEventScriptResolver(metadataEvent, this.muleProject);
        parse.accept(this);
        return this.scriptResolver.getMetadataType();
    }

    private void visitChildren(IContainerAwareNode node) {
        for (IASTNode child : node.getChildren()) {
            child.accept(this);
        }
    }

    @Override
    public void visitIdentifier(IdentifierNode expression) {
        this.doVisit(expression);
    }

    protected void doVisit(IASTNode node) {
        node.accept(this.getScriptResolver());
        if (this.getScriptResolver().getNextResolver() != null) {
            this.setScriptResolver(this.getScriptResolver().getNextResolver());
        }
    }

    @Override
    public void visitMethodCall(MethodCallNode expression) {
        this.doVisit(expression);
    }

    @Override
    public void visitStringLiteral(StringLiteralNode expression) {
        this.doVisit(expression);
    }

    @Override
    public void visitMapEntry(MapEntryNode mapEntryNode) {
        this.visitChildren(mapEntryNode);
    }

    @Override
    public void visitOperator(BinaryOperatorNode operatorNode) {
        this.visitChildren(operatorNode);
    }

    @Override
    public void visitScriptExpression(ScriptNode expression) {
        this.visitChildren(expression);
    }

    @Override
    public void visitKeyword(KeywordNode keywordExpression) {
        this.doVisit(keywordExpression);
    }

    @Override
    public void visitUnaryOperator(UnaryOperatorNode unaryOperatorNode) {
        this.doVisit(unaryOperatorNode);
    }

    @Override
    public void visitComment(CommentNode commentExpression) {
        this.doVisit(commentExpression);
    }

    @Override
    public void visitNumberLiteral(NumberLiteralNode numberLiteralExpression) {
        this.doVisit(numberLiteralExpression);
    }

    @Override
    public void visitStatement(StatementNode statementNode) {
        this.visitChildren(statementNode);
        this.doVisit(statementNode);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationNode variableDeclaration) {
        this.visitChildren(variableDeclaration);
        this.doVisit(variableDeclaration);
    }

    @Override
    public void visitCollectionAccessNode(CollectionAccessNode collectionAccessNode) {
        if (!collectionAccessNode.getChildren().isEmpty()) {
            collectionAccessNode.getChildren().get(0).accept(this);
        }
        this.doVisit(collectionAccessNode);
        if (collectionAccessNode.getChildren().size() == 2) {
            collectionAccessNode.getChildren().get(1).accept(this);
        }
    }

    public IMetaDataScriptResolver getScriptResolver() {
        return this.scriptResolver;
    }

    public void setScriptResolver(IMetaDataScriptResolver scriptResolver) {
        this.scriptResolver = scriptResolver;
    }

    @Override
    public void visitInlineCollectionNode(InlineCollectionNode inlineCollectionNode) {
        this.doVisit(inlineCollectionNode);
    }
}

