/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.resolver.script;

import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IdentifierNode;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.IMetaDataScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.MetaDataScriptResolverAdapter;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.ObjectMetaDataScriptResolver;

public class FieldMetaDataScriptResolver
extends MetaDataScriptResolverAdapter {
    private IMetaDataScriptResolver next;
    private Map<String, FieldType> fields;

    public FieldMetaDataScriptResolver(Map<String, FieldType> fields) {
        this.fields = fields;
    }

    @Override
    public void visitIdentifier(IdentifierNode expression) {
        String fieldName = expression.getContent();
        if (this.fields.containsKey(fieldName)) {
            Class<?> fieldClass = this.fields.get(fieldName).getFieldClass();
            this.next = new ObjectMetaDataScriptResolver(fieldClass, MetadataUtils.getMetadataFromType(fieldClass, (ClassLoader)fieldClass.getClassLoader()));
        }
    }

    @Override
    public IMetaDataScriptResolver getNextResolver() {
        return this.next;
    }

    @Override
    public MetadataType getMetadataType() {
        return null;
    }

    public static interface FieldType {
        public Class<?> getFieldClass();
    }

    public static class LazyFieldType
    implements FieldType {
        private String className;
        private IMuleProject muleProject;

        public LazyFieldType(String className, IMuleProject muleProject) {
            this.className = className;
            this.muleProject = muleProject;
        }

        @Override
        public Class<?> getFieldClass() {
            return ProjectClasspathUtils.loadClass((String)this.className, (IMuleProject)this.muleProject);
        }
    }

    public static class StaticFieldType
    implements FieldType {
        private Class<?> clazz;

        public StaticFieldType(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Class<?> getFieldClass() {
            return this.clazz;
        }
    }
}

