/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.resolver.script;

import java.util.Collection;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.modules.core.autocomplete.parser.BinaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CollectionAccessNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CommentNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.InlineCollectionNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.KeywordNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MapEntryNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.NumberLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ScriptNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StatementNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StringLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.UnaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.VariableDeclarationNode;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.IMetaDataScriptResolver;
import org.mule.tooling.ui.modules.core.metadata.resolver.script.ObjectMetaDataScriptResolver;

public class FieldAccessScriptResolver
implements IMetaDataScriptResolver {
    private MetadataType metadataType;
    private MetadataType resultModel;
    private IMetaDataScriptResolver next;
    private IMuleProject project;

    public FieldAccessScriptResolver(MetadataType metadataType, IMuleProject project) {
        this.metadataType = metadataType;
        this.resultModel = metadataType;
        this.project = project;
    }

    @Override
    public void visitIdentifier(IdentifierNode expression) {
        if (this.metadataType instanceof ObjectType) {
            String fieldName = expression.getContent();
            this.handleField(fieldName);
        }
    }

    protected void handleField(String fieldName) {
        Collection fields = ((ObjectType)this.metadataType).getFields();
        for (ObjectFieldType metaDataField : fields) {
            if (!metaDataField.getKey().getName().toString().equals(fieldName)) continue;
            this.resultModel = metaDataField.getValue();
            this.next = new FieldAccessScriptResolver(this.resultModel, this.project);
        }
    }

    @Override
    public void visitMethodCall(MethodCallNode expression) {
        if (this.metadataType instanceof ArrayType) {
            if ("get".equals(expression.getContent())) {
                this.next = new FieldAccessScriptResolver(((ArrayType)this.metadataType).getType(), this.project);
            } else if ("next".equals(expression.getContent())) {
                this.next = new FieldAccessScriptResolver(((ArrayType)this.metadataType).getType(), this.project);
            } else {
                this.handleMethodCall(expression);
            }
        } else {
            this.handleMethodCall(expression);
        }
    }

    protected void handleMethodCall(MethodCallNode expression) {
        ObjectMetaDataScriptResolver delegate = new ObjectMetaDataScriptResolver(MetadataUtils.getImplementationClass((MetadataType)this.metadataType), this.project, this.metadataType);
        delegate.visitMethodCall(expression);
        this.next = delegate.getNextResolver();
    }

    @Override
    public void visitStringLiteral(StringLiteralNode expression) {
    }

    @Override
    public void visitOperator(BinaryOperatorNode expression) {
    }

    @Override
    public void visitScriptExpression(ScriptNode expression) {
    }

    @Override
    public void visitKeyword(KeywordNode keywordExpression) {
    }

    @Override
    public void visitComment(CommentNode commentExpression) {
    }

    @Override
    public void visitNumberLiteral(NumberLiteralNode numberLiteralExpression) {
    }

    @Override
    public void visitStatement(StatementNode statementNode) {
    }

    @Override
    public void visitCollectionAccessNode(CollectionAccessNode collectionAccessNode) {
        IASTNode child;
        if (this.metadataType instanceof ArrayType) {
            this.next = new FieldAccessScriptResolver(((ArrayType)this.metadataType).getType(), this.project);
        } else if (this.metadataType instanceof ObjectType && (child = collectionAccessNode.getRight()) instanceof StringLiteralNode) {
            this.handleField(((StringLiteralNode)child).getContent());
        }
    }

    @Override
    public IMetaDataScriptResolver getNextResolver() {
        return this.next;
    }

    @Override
    public void visitInlineCollectionNode(InlineCollectionNode inlineCollectionNode) {
    }

    @Override
    public void visitMapEntry(MapEntryNode mapEntryNode) {
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationNode variableDeclaration) {
    }

    @Override
    public void visitUnaryOperator(UnaryOperatorNode unaryOperatorNode) {
    }

    @Override
    public MetadataType getMetadataType() {
        return this.resultModel;
    }
}

