/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.queue;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.ToolingJobsManager;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IDataSenseJobListener;
import org.mule.tooling.ui.modules.core.metadata.action.DataSenseOperation;
import org.mule.tooling.ui.modules.core.metadata.notifications.DataSenseJobNotificationsUtils;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public final class DataSenseProcessorQueue {
    public static DataSenseProcessorQueue getInstance() {
        return DataSenseProcessorQueueInstanceHolder.INSTANCE;
    }

    private DataSenseProcessorQueue() {
    }

    public void queue(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
        this.dispatchJob(dataSenseOperation);
    }

    private void dispatchJob(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
        DataSenseJob dataSenseJob = new DataSenseJob(dataSenseOperation);
        try {
            dataSenseJob.addJobChangeListener((IJobChangeListener)new DataSenseJobListener(dataSenseOperation));
            dataSenseJob.setJobGroup(ToolingJobsManager.getToolingJobGroup());
            dataSenseJob.setPriority(20);
            dataSenseJob.schedule();
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error while resolving metadata propagation", (Throwable)e);
        }
    }

    private static final class CancellationEvent
    implements IEvent<IDataSenseJobListener> {
        private DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation;

        public CancellationEvent(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
            this.dataSenseOperation = dataSenseOperation;
        }

        public EventType<IDataSenseJobListener> getAssociatedType() {
            return CoreEventTypes.ON_DATASENSE_JOB_EVENT;
        }

        public void dispatch(IDataSenseJobListener handler) {
            handler.onDataSenseJobCancellation(this.dataSenseOperation.getMuleProject(), this.dataSenseOperation.getMessageFlowNode());
        }
    }

    private static final class CompletionEvent
    implements IEvent<IDataSenseJobListener> {
        private DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation;

        public CompletionEvent(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
            this.dataSenseOperation = dataSenseOperation;
        }

        public EventType<IDataSenseJobListener> getAssociatedType() {
            return CoreEventTypes.ON_DATASENSE_JOB_EVENT;
        }

        public void dispatch(IDataSenseJobListener handler) {
            handler.onDataSenseJobSuccessfulCompletion(this.dataSenseOperation.getMuleProject(), this.dataSenseOperation.getMessageFlowNode());
        }
    }

    private static final class DataSenseJob
    extends Job {
        private DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation;

        public DataSenseJob(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
            super(dataSenseOperation.getJobName());
            this.dataSenseOperation = dataSenseOperation;
        }

        public boolean belongsTo(Object objectFamily) {
            return "DataSenseProcessor".equals(objectFamily);
        }

        protected IStatus run(IProgressMonitor monitor) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.dataSenseOperation.run(monitor);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MuleCorePlugin.logError((String)"Error while processing DataSense invocation", (Throwable)e);
                }
            });
            try {
                completableFuture.get(this.dataSenseOperation.getTimeout(), TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (e instanceof TimeoutException) {
                    this.timeout(this.dataSenseOperation);
                }
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        private void timeout(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
            DataSenseJobNotificationsUtils.openWarningNotification("The operation timed out and was not successful.\nYou can configure this timeout in the Studio Preferences dialog.");
        }
    }

    private static class DataSenseJobListener
    extends JobChangeAdapter {
        private DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation;

        public DataSenseJobListener(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
            this.dataSenseOperation = dataSenseOperation;
        }

        public void awake(IJobChangeEvent event) {
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new RunningEvent(this.dataSenseOperation));
        }

        public void aboutToRun(IJobChangeEvent event) {
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new RunningEvent(this.dataSenseOperation));
        }

        public void running(IJobChangeEvent event) {
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new RunningEvent(this.dataSenseOperation));
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                MetadataResult<?> metadataResult = this.dataSenseOperation.getResult();
                if (metadataResult != null) {
                    if (metadataResult.isSuccess()) {
                        MuleCorePlugin.getEventBus().fireEvent((IEvent)new CompletionEvent(this.dataSenseOperation));
                    }
                } else {
                    MuleCorePlugin.logWarning((String)"Cannot get the status from a DataSense operation. This might be an error.");
                }
            } else {
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new CancellationEvent(this.dataSenseOperation));
            }
        }
    }

    private static class DataSenseProcessorQueueInstanceHolder {
        private static final DataSenseProcessorQueue INSTANCE = new DataSenseProcessorQueue();

        private DataSenseProcessorQueueInstanceHolder() {
        }
    }

    private static final class RunningEvent
    implements IEvent<IDataSenseJobListener> {
        private DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation;

        public RunningEvent(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
            this.dataSenseOperation = dataSenseOperation;
        }

        public EventType<IDataSenseJobListener> getAssociatedType() {
            return CoreEventTypes.ON_DATASENSE_JOB_EVENT;
        }

        public void dispatch(IDataSenseJobListener handler) {
            handler.onDataSenseJobRunning(this.dataSenseOperation.getMuleProject(), this.dataSenseOperation.getMessageFlowNode());
        }
    }
}

