/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.propagation;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.AbstractMessageFlowEntityVisitor;

public final class NodesReferencingGlobalElementCollectorVisitor
extends AbstractMessageFlowEntityVisitor {
    private static final String CONFIG_REF_ATTR_NAME = "config-ref";
    private final String globalElementName;
    private final List<MessageFlowNode> relatedNodes;

    public NodesReferencingGlobalElementCollectorVisitor(String globalElementName) {
        this.globalElementName = globalElementName;
        this.relatedNodes = new ArrayList<MessageFlowNode>();
    }

    public void visitEndpointNode(EndpointNode endpointNode) {
        this.doVisit((MessageFlowNode)endpointNode);
    }

    public void visitPatternNode(PatternNode patternNode) {
        this.doVisit((MessageFlowNode)patternNode);
    }

    private void doVisit(MessageFlowNode node) {
        IReadOnlyProperty globalRefProperty = (IReadOnlyProperty)node.getProperties().getProperty(CONFIG_REF_ATTR_NAME);
        if (globalRefProperty != null && this.globalElementName.equals(globalRefProperty.getValue())) {
            this.relatedNodes.add(node);
        }
    }

    public List<MessageFlowNode> getRelatedNodes() {
        return this.relatedNodes;
    }

    public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
    }

    public void visitUnknownNode(UnknownNode unknownNode) {
    }

    public void visitCommentNode(CommentContainer commentNode) {
    }

    public void preChildrenVisit(MessageFlowEntity entity) {
    }

    public void postChildrenVisit(MessageFlowEntity entity) {
    }
}

