/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.propagation;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.IMetadataPropagationCache;
import org.mule.tooling.client.metadata.ProjectPropagation;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IDataSenseTypeChangedListener;
import org.mule.tooling.core.event.IMessageFlowEntityDeletedEventListener;
import org.mule.tooling.core.event.IMessageFlowEntityEditedListener;
import org.mule.tooling.core.event.IMessageFlowEntityMovedListener;
import org.mule.tooling.core.event.IMetadataDefinitionChangedListener;
import org.mule.tooling.core.event.IProxyConfigurationChangedListener;
import org.mule.tooling.core.event.MessageFlowEventTypes;
import org.mule.tooling.core.event.XMLDocumentEditedListener;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.INewElementCreatedOnCanvasListener;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.RequiredAttributesGroup;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;

@Singleton
public class MetadataPropagationCache
implements FileChangedEventListener,
IMetadataPropagationCache {
    private static final Set<EditingScope> ALL_SCOPES = new HashSet<EditingScope>();
    private static final Pattern HIDDEN_FILE = Pattern.compile("^\\..+");
    private Map<PropagationCacheKey, Long> lastEvictionTimeByProject = new HashMap<PropagationCacheKey, Long>();
    private Map<PropagationCacheKey, ProjectPropagation> propagationByProject = new HashMap<PropagationCacheKey, ProjectPropagation>();

    static {
        ALL_SCOPES.add(EditingScope.APP);
        ALL_SCOPES.add(EditingScope.TEST);
    }

    @Inject
    public MetadataPropagationCache(EventBus eventBus) {
        MetadataPropagationCache cache = this;
        eventBus.registerListener(CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, (IEventHandler)cache);
        eventBus.registerListener(CoreEventTypes.ON_PROXY_CONFIGURATION_CHANGED, (IEventHandler)((IProxyConfigurationChangedListener)() -> cache.clear()));
        eventBus.registerListener(CoreEventTypes.ON_METADATA_DEFINITION_CHANGED, (IEventHandler)((IMetadataDefinitionChangedListener)project -> cache.evictProjectPropagation(project, ALL_SCOPES)));
        eventBus.registerListener(CoreEventTypes.ON_DATASENSE_TYPE_CHANGE_EVENT, (IEventHandler)((IDataSenseTypeChangedListener)project -> cache.evictProjectPropagation(project, ALL_SCOPES)));
        eventBus.registerListener(EditPartEventTypes.ON_ELEMENT_CREATED_ON_CANVAS, (IEventHandler)((INewElementCreatedOnCanvasListener)(project, e) -> cache.evictProjectPropagation(project, ALL_SCOPES)));
        eventBus.registerListener(CoreEventTypes.ON_XML_DOCUMENT_EDITED, (IEventHandler)((XMLDocumentEditedListener)(project, configFile) -> {
            MuleConfiguration configuration = project.getConfigurationsCache().getConfiguration(configFile);
            MetadataPropagationCache.forceEviction(cache, project, MetadataPropagationCache.getScopesToUpdate((IResource)configFile), configuration.getGlobalEntries());
        }));
        eventBus.registerListener(MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_MOVED, (IEventHandler)((IMessageFlowEntityMovedListener)(project, muleConfig, entity, oldPath) -> {
            IFile configurationFile = project.getConfigurationsCache().getConfigurationFile(muleConfig);
            cache.evictProjectPropagation(project, MetadataPropagationCache.getScopesToUpdate((IResource)configurationFile));
        }));
        eventBus.registerListener(MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_EDITED, (IEventHandler)((IMessageFlowEntityEditedListener)(project, entity, previousProperties) -> {
            List<IMessageFlowEntity> modifiedEntities = Arrays.asList(entity);
            MetadataPropagationCache.onMessageFlowEntitiesModified(cache, project, MetadataPropagationCache.getScopesToUpdate(EditingScope.getCurrent()), modifiedEntities, node -> previousProperties);
        }));
        eventBus.registerListener(MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_DELETED, (IEventHandler)((IMessageFlowEntityDeletedEventListener)(project, configFile, muleConfig, deletedEntity) -> {
            List<IMessageFlowEntity> modifiedEntities = Arrays.asList(deletedEntity);
            MetadataPropagationCache.forceEviction(cache, project, MetadataPropagationCache.getScopesToUpdate((IResource)configFile), modifiedEntities);
        }));
    }

    private static void onMessageFlowEntitiesModified(MetadataPropagationCache cache, IMuleProject project, Set<EditingScope> scopesToUpdate, List<IMessageFlowEntity> modifiedEntities, Function<IMessageFlowNode, IReadOnlyPropertyCollection> previousPropertiesProvider) {
        MetadataPropagationCache.onMessageFlowEntitiesModified(cache, project, scopesToUpdate, modifiedEntities, previousPropertiesProvider, false);
    }

    private static void forceEviction(MetadataPropagationCache cache, IMuleProject project, Set<EditingScope> scopesToUpdate, List<IMessageFlowEntity> modifiedEntities) {
        MetadataPropagationCache.onMessageFlowEntitiesModified(cache, project, scopesToUpdate, modifiedEntities, node -> node.getProperties(), true);
    }

    private static void onMessageFlowEntitiesModified(MetadataPropagationCache cache, IMuleProject project, Set<EditingScope> scopesToUpdate, List<IMessageFlowEntity> modifiedEntities, Function<IMessageFlowNode, IReadOnlyPropertyCollection> previousPropertiesProvider, boolean forceEvict) {
        cache.evictProjectPropagation(project, scopesToUpdate);
    }

    public static boolean requiresMetadataEviction(NodeDefinition definition, IReadOnlyPropertyCollection properties, IReadOnlyPropertyCollection propertiesAtAnotherState, IMuleModuleManager moduleManager) {
        boolean evictRequired = MetadataPropagationCache.anyDataSensePropertyChanged(definition, properties, propertiesAtAnotherState);
        if (!evictRequired && definition instanceof GlobalDefinition && !(evictRequired = MetadataPropagationCache.childPropertiesChanged(properties, propertiesAtAnotherState, moduleManager, Collections.emptyList()))) {
            List<String> processedCollections = properties.getPropertyCollections().stream().map(IPropertyCollectionReadCapability::getName).collect(Collectors.toList());
            evictRequired = MetadataPropagationCache.childPropertiesChanged(propertiesAtAnotherState, properties, moduleManager, processedCollections);
        }
        return evictRequired;
    }

    protected static boolean childPropertiesChanged(IReadOnlyPropertyCollection properties, IReadOnlyPropertyCollection propertiesAtAnotherState, IMuleModuleManager moduleManager, Collection<String> processedCollections) {
        boolean evictRequired = false;
        List propertyCollection = properties.getPropertyCollections();
        for (IReadOnlyPropertyCollection childProperty : propertyCollection) {
            IReadOnlyPropertyCollection childPropertiesAtSecondState;
            NestedDefinition nestedDefinition;
            String collectionId = childProperty.getName();
            if (!processedCollections.contains(collectionId) && (nestedDefinition = moduleManager.getNestedDefinition(PropertiesUtils.getNodeDefinitionId((String)collectionId))) != null && (evictRequired = MetadataPropagationCache.anyDataSensePropertyChanged((NodeDefinition)nestedDefinition, childProperty, childPropertiesAtSecondState = propertiesAtAnotherState != null ? (IReadOnlyPropertyCollection)propertiesAtAnotherState.getPropertyCollection(collectionId) : null))) break;
        }
        return evictRequired;
    }

    private static boolean anyDataSensePropertyChanged(NodeDefinition definition, IReadOnlyPropertyCollection previousProperties, IReadOnlyPropertyCollection currentProperties) {
        List<RequiredAttributesGroup> requiredForDataSenseAttributeNames = MetadataHelpers.getRequiredForDataSenseAttributeNames(definition);
        if (!requiredForDataSenseAttributeNames.isEmpty()) {
            for (RequiredAttributesGroup group : requiredForDataSenseAttributeNames) {
                for (String property : group.getArguments()) {
                    if (!MetadataPropagationCache.propertyChanged(property, previousProperties, currentProperties)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean propertyChanged(String propertyName, IReadOnlyPropertyCollection previousProperties, IReadOnlyPropertyCollection currentProperties) {
        IReadOnlyProperty prevProperty = previousProperties != null ? (IReadOnlyProperty)previousProperties.getProperty(propertyName) : null;
        IReadOnlyProperty currentProperty = currentProperties != null ? (IReadOnlyProperty)currentProperties.getProperty(propertyName) : null;
        return !Objects.equals(prevProperty, currentProperty);
    }

    private static List<IMuleProject> getProjectsToUpdate(IMuleProject muleProject) {
        ArrayList<IMuleProject> projectsToInspect = new ArrayList<IMuleProject>();
        projectsToInspect.add(muleProject);
        if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
            try {
                ((IMuleDomainProject)MuleProjectKind.DOMAIN.adapt(muleProject)).getChildProjects().forEach(projectsToInspect::add);
            }
            catch (CoreException e) {
                String message = MessageFormat.format("There was an error fetching {0}''s linked projects to evict DataSense propagation information", muleProject.getName());
                MuleCorePlugin.logError((String)message, (Throwable)e);
            }
        }
        return projectsToInspect;
    }

    public static IMetadataPropagationCache getInstance() {
        return (IMetadataPropagationCache)EclipseContextHelper.createFromStudioContext(MetadataPropagationCache.class);
    }

    public long getLastEvictionTime(IMuleProject project, EditingScope scope) {
        Optional<Long> maybeLastEvictionTime = Optional.ofNullable(this.lastEvictionTimeByProject.get(PropagationCacheKey.create(project, scope)));
        return maybeLastEvictionTime.orElse(0L);
    }

    public Optional<PropagationInfo> get(IMuleProject project, IComponentPath componentPath, EditingScope scope) {
        Optional<ProjectPropagation> projectPropagation = this.getProjectPropagation(project, scope);
        return projectPropagation.flatMap(c -> c.get(componentPath));
    }

    public Optional<ProjectPropagation> getProjectPropagation(IMuleProject project, EditingScope scope) {
        return Optional.ofNullable(this.propagationByProject.get(PropagationCacheKey.create(project, scope)));
    }

    public void put(IMuleProject project, IComponentPath componentPath, PropagationInfo result, EditingScope scope) {
        PropagationCacheKey key = PropagationCacheKey.create(project, scope);
        ProjectPropagation projectPropagation = Optional.ofNullable(this.propagationByProject.get(key)).orElse(new ProjectPropagation());
        projectPropagation.put(componentPath, result);
        this.propagationByProject.put(key, projectPropagation);
    }

    public void onFileChanged(FileChangedEvent event) {
        event.getMuleProject().ifPresent(muleProject -> {
            if (this.affectsCache((IMuleProject)muleProject, event)) {
                IFile file = event.getFile();
                Set<EditingScope> scopeToUpdate = MetadataPropagationCache.getScopesToUpdate((IResource)file);
                if (event.isEventType(FileChangedEvent.ChangeType.CREATED) || event.isEventType(FileChangedEvent.ChangeType.DELETED)) {
                    this.evictProjectPropagation((IMuleProject)muleProject, scopeToUpdate);
                } else if (event.isEventType(FileChangedEvent.ChangeType.CHANGED) && !MuleResourceUtils.isDesignInfoFile((IResource)file)) {
                    if (MuleResourceUtils.isConfigFile((IResource)file)) {
                        MuleConfiguration configuration = muleProject.getConfigurationsCache().getConfiguration(file);
                        MetadataPropagationCache.forceEviction(this, muleProject, scopeToUpdate, configuration.getGlobalEntries());
                    } else if (MuleResourceUtils.isApplicationTypesFile((IResource)file)) {
                        this.evictProjectPropagation((IMuleProject)muleProject, scopeToUpdate);
                    }
                }
            }
        });
    }

    private boolean affectsCache(IMuleProject project, FileChangedEvent event) {
        IFile file = event.getFile();
        String lastSegment = file.getName();
        return !HIDDEN_FILE.matcher(lastSegment).matches() && !MuleResourceUtils.isLog4jRelatedFile((IResource)file) && !event.isInOutputLocation();
    }

    public void evictProjectPropagation(IMuleProject muleProject) {
        this.evictProjectPropagation(muleProject, ALL_SCOPES);
    }

    private void evictProjectPropagation(IMuleProject muleProject, Set<EditingScope> scopesToUpdate) {
        MetadataPropagationCache.getProjectsToUpdate(muleProject).forEach(project -> this.doRemoveProjectPropagation((IMuleProject)project, scopesToUpdate));
    }

    private void doRemoveProjectPropagation(IMuleProject project, Set<EditingScope> scopesToUpdate) {
        scopesToUpdate.stream().forEach(scope -> {
            PropagationCacheKey key = PropagationCacheKey.create(project, scope);
            this.lastEvictionTimeByProject.put(key, System.currentTimeMillis());
            this.propagationByProject.remove(key);
        });
    }

    private static Set<EditingScope> getScopesToUpdate(IResource resource) {
        EditingScope scope = EditingScope.getRootScope((EditingScope)ProjectStructureContributionManager.getDefault().getScope(resource));
        return MetadataPropagationCache.getScopesToUpdate(scope);
    }

    private static Set<EditingScope> getScopesToUpdate(EditingScope scope) {
        if (EditingScope.APP.equals(scope)) {
            return ALL_SCOPES;
        }
        return Collections.singleton(scope);
    }

    public void clear() {
        this.lastEvictionTimeByProject.clear();
        this.propagationByProject.clear();
    }

    public void removeProjectPropagation(IMuleProject muleProject) {
        this.evictProjectPropagation(muleProject);
        ALL_SCOPES.stream().forEach(scope -> {
            PropagationCacheKey key = PropagationCacheKey.create(muleProject, scope);
            this.lastEvictionTimeByProject.remove(key);
        });
    }

    private static final class PropagationCacheKey {
        private final IProject muleProject;
        private final EditingScope scope;

        public static PropagationCacheKey create(IMuleProject muleProject, EditingScope scope) {
            return new PropagationCacheKey(muleProject.getProject(), scope);
        }

        private PropagationCacheKey(IProject muleProject, EditingScope scope) {
            this.muleProject = muleProject;
            this.scope = scope;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.muleProject == null ? 0 : this.muleProject.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropagationCacheKey other = (PropagationCacheKey)obj;
            if (this.muleProject == null ? other.muleProject != null : !this.muleProject.equals((Object)other.muleProject)) {
                return false;
            }
            return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
        }
    }
}

