/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.notifications;

import org.eclipse.swt.widgets.Display;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.action.DataSenseOperation;
import org.mule.tooling.ui.modules.core.metadata.notifications.DataSenseJobErrorNotificationPopup;
import org.mule.tooling.ui.modules.core.metadata.notifications.DataSenseJobWarningNotificationPopup;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public final class DataSenseJobNotificationsUtils {
    private DataSenseJobNotificationsUtils() {
    }

    public static void openWarningNotification(final String message) {
        final Display display = WidgetUtils.requireDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DataSenseJobWarningNotificationPopup warningPopUpUI = new DataSenseJobWarningNotificationPopup(display, message);
                warningPopUpUI.open();
            }
        });
    }

    public static void openErrorNotification(String message, String stackTrace) {
        DataSenseJobNotificationsUtils.openErrorNotification(message, stackTrace, null);
    }

    public static void openErrorNotification(String message, String stackTrace, DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
        Display display = WidgetUtils.requireDisplay();
        display.asyncExec((Runnable)new ShowErrorNotification(message, stackTrace, dataSenseOperation));
    }

    private static final class ShowErrorNotification
    implements Runnable {
        private final String message;
        private final String stackTrace;
        private final DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation;

        private ShowErrorNotification(String message, String stackTrace, DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
            this.message = message;
            this.stackTrace = stackTrace;
            this.dataSenseOperation = dataSenseOperation;
        }

        @Override
        public void run() {
            DataSenseJobErrorNotificationPopup popup = new DataSenseJobErrorNotificationPopup(this.message, this.stackTrace, this.dataSenseOperation);
            popup.open();
        }
    }
}

