/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.notifications;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.command.UpdatePropertiesCommand;
import org.mule.tooling.messageflow.dialog.GlobalElementDialog;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.GlobalElementDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.modules.core.metadata.action.DataSenseOperation;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.notification.AbstractNotificationPopup;

public abstract class DataSenseJobNotificationPopup
extends AbstractNotificationPopup {
    private static final long DEFAULT_DELAY_CLOSE = TimeUnit.SECONDS.toMillis(3L);
    private static final String MORE_INFO = "More info";
    private static final String EDIT_CONNECTOR = "Edit connector";
    private String message;
    private String stackTrace;
    private DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation;

    public DataSenseJobNotificationPopup(String message, String stackTrace, DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
        this.message = message;
        this.stackTrace = stackTrace;
        this.dataSenseOperation = dataSenseOperation;
        this.setDelayClose(DEFAULT_DELAY_CLOSE);
    }

    protected void createContentArea(Composite composite) {
        if (this.dataSenseOperation != null) {
            this.createNotificationErrorMessageWithOptions(composite);
        } else if (this.message != null) {
            this.createSimpleNotificationErrorMessage(composite);
        }
    }

    protected String getPopupShellTitle() {
        Object title = "Problem while fetching metadata";
        if (this.dataSenseOperation != null) {
            String messageFlowNodeName = this.dataSenseOperation.getMessageFlowNode().getName();
            title = "Problem while fetching metadata for: " + messageFlowNodeName;
        }
        return title;
    }

    protected abstract Image getPopupShellImage(int var1);

    private void createNotificationErrorMessageWithOptions(Composite composite) {
        String stack;
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder stackTraceBuilder = new StringBuilder();
        if (this.message != null) {
            messageBuilder.append(this.message);
        } else {
            messageBuilder.append("Unspecified connection error. Please check your connector configuration.");
        }
        if (this.stackTrace != null) {
            stackTraceBuilder.append(this.stackTrace);
        }
        MuleConfiguration muleConfiguration = this.getCorrectMuleConfigurationFor(this.dataSenseOperation);
        int numberOfColumns = this.dataSenseOperation.showEditLinkIfError() && !muleConfiguration.isReadOnly() ? 2 : 1;
        GridLayoutFactory.fillDefaults().numColumns(numberOfColumns).margins(5, 5).equalWidth(true).applyTo(composite);
        StyledText styledText = new StyledText(composite, 578);
        styledText.setText(messageBuilder.toString());
        styledText.setEditable(false);
        styledText.setCaret(null);
        GridDataFactory.fillDefaults().align(4, 4).span(numberOfColumns, 1).grab(true, true).applyTo((Control)styledText);
        GridDataFactory linkFactory = GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false);
        if (this.dataSenseOperation.showEditLinkIfError() && !muleConfiguration.isReadOnly()) {
            this.createEditConnectorLink(composite, linkFactory);
        }
        if (StringUtils.isNotBlank((String)(stack = stackTraceBuilder.toString()))) {
            this.createMoreInfoLink(composite, linkFactory, stack);
        }
    }

    private void createSimpleNotificationErrorMessage(Composite composite) {
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(composite);
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(256, 128, true, false, 1, 1));
        label.setText(this.message);
    }

    private MuleConfiguration getCorrectMuleConfigurationFor(DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
        IMuleProject muleProject = dataSenseOperation.getMuleProject();
        IMessageFlowNode messageFlowNode = dataSenseOperation.getMessageFlowNode();
        MuleConfiguration muleConfiguration = dataSenseOperation.getMuleConfiguration();
        if (!(messageFlowNode instanceof GlobalElement)) {
            String globalReferenceName = MetadataUtils.getGlobalReference((IMessageFlowNode)messageFlowNode);
            messageFlowNode = CoreUtils.retrieveGlobalElement((IMuleProject)muleProject, (String)globalReferenceName);
            muleConfiguration = MetadataUtils.getMuleConfigurationFor((IMuleProject)muleProject, (String)globalReferenceName);
        }
        return muleConfiguration;
    }

    private void createEditConnectorLink(Composite composite, GridDataFactory linkFactory) {
        this.makeLink(composite, EDIT_CONNECTOR, linkFactory, (SelectionListener)new EditConnectorSelectionAdapter(this, this.dataSenseOperation));
    }

    private void createMoreInfoLink(Composite composite, GridDataFactory linkFactory, String stackTrace) {
        this.makeLink(composite, MORE_INFO, linkFactory, (SelectionListener)new MoreInfoSelectionAdapter(this, stackTrace));
    }

    private void makeLink(Composite linkCompo, String text, GridDataFactory gridDataFactory, SelectionListener listener) {
        Link link = new Link(linkCompo, 64);
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(listener);
        gridDataFactory.applyTo((Control)link);
    }

    private static void editGlobalElement(IMessageFlowNode messageFlowNode, MuleConfiguration muleConfiguration, IMuleProject muleProject) {
        MulePath nodePath = muleConfiguration.getPathFor((IMessageFlowEntity)messageFlowNode);
        MultiPageMessageFlowEditor openEditor = Optional.of(MessageFlowUtils.getMultiPageMessageFlowEditor()).filter(editor -> DataSenseJobNotificationPopup.configurationContainsEntity(nodePath, editor.getMuleConfiguration())).orElseGet(() -> DataSenseJobNotificationPopup.openContainingEditor(muleProject, nodePath));
        if (openEditor != null) {
            MuleConfiguration targetConfiguration = openEditor.getMuleConfiguration();
            GlobalElement nodeToEdit = (GlobalElement)targetConfiguration.getEntityFor(nodePath);
            DataSenseJobNotificationPopup.doEditGlobalElement(openEditor.getSite().getShell(), muleProject, nodeToEdit, targetConfiguration);
        }
    }

    private static MultiPageMessageFlowEditor openContainingEditor(IMuleProject muleProject, MulePath nodePath) {
        Map resourceToConfigMap = muleProject.getConfigurationsCache().getResourceToConfigMap();
        for (Map.Entry entry : resourceToConfigMap.entrySet()) {
            if (!DataSenseJobNotificationPopup.configurationContainsEntity(nodePath, (MuleConfiguration)entry.getValue())) continue;
            try {
                MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)UiUtils.openEditorForFile((IFile)((IFile)entry.getKey()), (String)"org.mule.tooling.messageflow.messageFlowEditor");
                if (editor != null) {
                    editor.openGlobalElementsPage();
                }
                return editor;
            }
            catch (PartInitException e) {
                MuleCorePlugin.logError((String)("Unable to open editor for " + String.valueOf(entry.getKey())), (Throwable)e);
            }
        }
        return null;
    }

    private static void doEditGlobalElement(Shell shell, IMuleProject muleProject, GlobalElement globalElement, MuleConfiguration muleConfiguration) {
        GlobalElementDialog dialog = new GlobalElementDialog(shell, muleProject, globalElement, () -> muleConfiguration);
        if (dialog.open() == 0) {
            IReadOnlyPropertyCollection previous = globalElement.getProperties();
            PropertyCollection updated = dialog.getUpdatedProperties().asPropertyCollection();
            GlobalElementDecorator decorator = new GlobalElementDecorator(globalElement);
            MuleConfiguration targetConfiguration = MessageFlowUtils.getOrOpenMultiPageEditorFor((MuleConfiguration)muleConfiguration, (IMuleProject)muleProject).map(editor -> editor.getMuleConfiguration()).orElseThrow(() -> new IllegalStateException("the mule configuration passed should belong to an already open editor"));
            MuleConfigurationDecorator muleConfigurationDecorator = new MuleConfigurationDecorator(targetConfiguration);
            UpdatePropertiesCommand command = new UpdatePropertiesCommand(muleProject, muleConfigurationDecorator, (EntityDecorator)decorator, previous, updated);
            command.execute();
        }
    }

    private static boolean configurationContainsEntity(MulePath nodePath, MuleConfiguration configuration) {
        return configuration.getEntityFor(nodePath) != null;
    }

    private static final class EditConnectorSelectionAdapter
    extends SelectionAdapter {
        private AbstractNotificationPopup popup;
        private DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation;

        public EditConnectorSelectionAdapter(AbstractNotificationPopup popup, DataSenseOperation<? extends MetadataResult<?>> dataSenseOperation) {
            this.popup = popup;
            this.dataSenseOperation = dataSenseOperation;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            IMuleApplicationProject muleApplication;
            IMuleDomain domain;
            IMuleProject muleProject = this.dataSenseOperation.getMuleProject();
            IMessageFlowNode messageFlowNode = this.dataSenseOperation.getMessageFlowNode();
            MuleConfiguration muleConfiguration = this.dataSenseOperation.getMuleConfiguration();
            if (!(messageFlowNode instanceof GlobalElement)) {
                String globalReferenceName = MetadataUtils.getGlobalReference((IMessageFlowNode)messageFlowNode);
                messageFlowNode = CoreUtils.retrieveGlobalElement((IMuleProject)muleProject, (String)globalReferenceName);
                muleConfiguration = MetadataUtils.getMuleConfigurationFor((IMuleProject)muleProject, (String)globalReferenceName);
            }
            if (MuleProjectKind.APPLICATION.classifies(muleProject) && (domain = (muleApplication = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject)).getDomain()) instanceof IMuleDomainProject) {
                String nameProperty;
                IMuleDomainProject muleDomain;
                IMuleDomainProject iMuleDomainProject = muleDomain = !muleApplication.hasDefaultDomain() ? (IMuleDomainProject)domain : null;
                if (muleDomain != null && CoreUtils.retrieveGlobalElement((IMuleProject)muleDomain, (String)(nameProperty = CoreUtils.getNameProperty((IMessageFlowNode)messageFlowNode))) != null) {
                    muleProject = muleDomain;
                }
            }
            this.popup.close();
            if (messageFlowNode != null) {
                IMessageFlowNode messageFlowNodeForCallable = messageFlowNode;
                MuleConfiguration muleConfigurationForCallable = muleConfiguration;
                IMuleProject muleProjectForCallable = muleProject;
                StudioDesignContextRunner.runSilentWithMuleProjectInUI(() -> {
                    DataSenseJobNotificationPopup.editGlobalElement(messageFlowNodeForCallable, muleConfigurationForCallable, muleProjectForCallable);
                    return null;
                }, (IMuleProject)muleProject);
            }
        }
    }

    private static final class MoreInfoSelectionAdapter
    extends SelectionAdapter {
        private final String stackTrace;
        private AbstractNotificationPopup popup;

        private MoreInfoSelectionAdapter(AbstractNotificationPopup popup, String stackTrace) {
            this.popup = popup;
            this.stackTrace = stackTrace;
        }

        public void widgetSelected(SelectionEvent e) {
            if (StringUtils.isNotBlank((String)this.stackTrace)) {
                this.popup.close();
                String reason = this.stackTrace.substring(0, this.stackTrace.indexOf("\n"));
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Metadata retrieval failed", (String)"Metadata retrieval failed because of this problem:", (IStatus)MetadataUtils.createMultiStatus((String)"org.mule.tooling.metadata", (String)reason, (MetadataUtils.StackTraceElementProvider)MetadataUtils.StackTraceElementProvider.fromStackTrace((String)this.stackTrace)));
            }
        }
    }
}

