/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.multilevel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataOperationEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataTypeRef;
import org.mule.tooling.client.metadata.enricher.OutputMessageEnricher;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.ComponentMetadataDefinitionChangedEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardDialog;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.CustomEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.MimeTypeFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.widgets.content.CollectionConentProvider;
import org.mule.tooling.utils.eventbus.IEvent;

public class OutputMetadataChooser
extends CustomEditor {
    private static final MetadataKey EMPTY_SELECTION = new MetadataKey(null, "", new HashSet(), "");
    private ComboViewer typeSelector;
    private ToolBar toolbar;
    private MetadataKey currentKey;

    public OutputMetadataChooser(AttributesPropertyPage parentPage, AttributeHelper helper, AttributeGroup attributeGroup, Composite groupComposite) {
        super(parentPage, helper, attributeGroup, groupComposite);
    }

    @Override
    public void refreshEditor(String newValue, boolean shouldNotifyObservers) {
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        ComponentId componentId = this.getComponentId(node);
        ITypesManager typesManager = this.getTypesManager();
        Optional enricher = typesManager.getEnricher(componentId);
        if (enricher.isPresent()) {
            MetadataEnricher metadataEnricher = (MetadataEnricher)enricher.get();
            metadataEnricher.getOperationEnricher().ifPresent(operationEnricher -> {
                MetadataTypeRef payload = operationEnricher.getOutput().getPayload();
                if (!payload.isNull()) {
                    this.updateSelection(payload.getKey());
                }
            });
        }
        this.typeSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OutputMetadataChooser.this.onOutputTypeChanged(OutputMetadataChooser.this.getParentPage().getMessageFlowNode());
                OutputMetadataChooser.this.getMimeTypeEditor().ifPresent(mimeTypeEditor -> {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    MetadataKey firstElement = (MetadataKey)selection.getFirstElement();
                    if (OutputMetadataChooser.this.currentKey == null || !firstElement.getId().equals(OutputMetadataChooser.this.currentKey.getId())) {
                        OutputMetadataChooser.this.currentKey = firstElement;
                        Optional<MetadataType> mayBeMetadata = Optional.ofNullable(OutputMetadataChooser.this.getTypesManager().getCustomMetadataType(firstElement));
                        mayBeMetadata.ifPresent(metadataType -> {
                            Iterator mimetypes = metadataType.getMetadataFormat().getValidMimeTypes().iterator();
                            if (mimetypes.hasNext()) {
                                String mimeType = (String)mimetypes.next();
                                mimeTypeEditor.setValue(mimeType);
                                Optional propertiesAnnotation = metadataType.getAnnotation(MetadataFormatPropertiesAnnotation.class);
                                HashMap<String, String> readerProperties = new HashMap<String, String>();
                                propertiesAnnotation.ifPresent(props -> readerProperties.putAll(props.getValue()));
                                if (mimeType.equalsIgnoreCase("application/flatfile")) {
                                    metadataType.getAnnotation(PathAnnotation.class).ifPresent(schemaPath -> {
                                        String string = readerProperties.put("schemaPath", schemaPath.getPath());
                                    });
                                    metadataType.getAnnotation(ElementAnnotation.class).ifPresent(element -> {
                                        String string = readerProperties.put("segmentIdent", element.getElement());
                                    });
                                }
                                mimeTypeEditor.setProperties(readerProperties);
                            }
                        });
                    }
                });
            }
        });
    }

    public ComponentId getComponentId(IMessageFlowNode node) {
        return ComponentId.getOrCreate((IMessageFlowNode)node);
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
    }

    public void onOutputTypeChanged(IMessageFlowNode node) {
        IStructuredSelection selection = (IStructuredSelection)this.typeSelector.getSelection();
        ComponentId componentId = this.getComponentId(node);
        Optional enricher = this.getTypesManager().getEnricher(componentId);
        if (selection != null && !selection.isEmpty()) {
            MetadataEnricher metadataEnricher = enricher.orElseGet(() -> new MetadataEnricher(componentId));
            OutputMessageEnricher output = new OutputMessageEnricher();
            MetadataTypeRef outputPayload = MetadataTypeRef.builder().withKey(((MetadataKey)selection.getFirstElement()).getId()).build();
            output.setPayload(outputPayload);
            Optional operationEnricher2 = metadataEnricher.getOperationEnricher();
            if (operationEnricher2.isPresent()) {
                ((MetadataOperationEnricher)operationEnricher2.get()).setOutput(output);
            } else {
                MetadataOperationEnricher metadataOperationEnricher = new MetadataOperationEnricher();
                metadataOperationEnricher.setOutput(output);
                metadataEnricher.setOperationEnricher(metadataOperationEnricher);
            }
            this.getTypesManager().enrich(metadataEnricher);
            this.getTypesManager().persist();
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new ComponentMetadataDefinitionChangedEvent(this.getMuleProject(), ComponentMetadataDefinitionChangedEvent.CompenentMetadataType.OUTPUT));
        } else if (enricher.isPresent()) {
            ((MetadataEnricher)enricher.get()).getOperationEnricher().ifPresent(operationEnricher -> operationEnricher.getOutput().setPayload(MetadataTypeRef.builder().build()));
        }
    }

    @Override
    protected Control createControl(AttributesPropertyPage parentPage) {
        Composite composite = new Composite(this.getGroupComposite(), 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Label caption = new Label(composite, 0);
        caption.setText(this.getHelper().getCaption() + ":");
        this.typeSelector = new ComboViewer(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.typeSelector.getControl());
        this.toolbar = new ToolBar(composite, 0);
        this.bindUI();
        return composite;
    }

    public void bindUI() {
        ToolBarManager toolBarManager = new ToolBarManager(this.toolbar);
        CreateNewMetadata newMetadata = new CreateNewMetadata();
        toolBarManager.add((IAction)newMetadata);
        toolBarManager.update(true);
        this.typeSelector.setContentProvider((IContentProvider)new CollectionConentProvider());
        this.typeSelector.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                MetadataKey metadataKey = (MetadataKey)element;
                return metadataKey.getDisplayName();
            }
        });
        Set customMetadataKeys = this.getTypesManager().getCustomMetadataKeys();
        ArrayList<MetadataKey> keysToShow = new ArrayList<MetadataKey>(customMetadataKeys);
        keysToShow.add(0, EMPTY_SELECTION);
        this.typeSelector.setInput((Object)customMetadataKeys);
    }

    private ITypesManager getTypesManager() {
        return ((MetadataTypesManager)this.getParentPage().getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }

    IMuleProject getMuleProject() {
        return this.getParentPage().getMuleProject();
    }

    public void updateSelection(String key) {
        this.currentKey = null;
        Set customMetadataKeys = this.getTypesManager().getCustomMetadataKeys();
        this.typeSelector.setInput((Object)customMetadataKeys);
        for (MetadataKey metadataKey : customMetadataKeys) {
            if (!metadataKey.getId().equals(key)) continue;
            this.typeSelector.setSelection((ISelection)new StructuredSelection((Object)metadataKey));
            return;
        }
    }

    public Optional<MimeTypeFieldEditor> getMimeTypeEditor() {
        IFieldEditor fieldEditor = this.getParentPage().getEditor("outputMimeType");
        return Optional.ofNullable(fieldEditor).flatMap(editor -> {
            if (editor instanceof MimeTypeFieldEditor) {
                return Optional.ofNullable((MimeTypeFieldEditor)editor);
            }
            return Optional.empty();
        });
    }

    private class CreateNewMetadata
    extends Action {
        private CreateNewMetadata() {
            super("Create New", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        }

        public void run() {
            MetadataDefinitionWizard wizard = new MetadataDefinitionWizard(OutputMetadataChooser.this.getMuleProject());
            Shell activeShell = Display.getCurrent().getActiveShell();
            MetadataDefinitionWizardDialog dialog = new MetadataDefinitionWizardDialog(activeShell, wizard);
            if (dialog.open() == 0) {
                String key = wizard.getResult().getKey();
                OutputMetadataChooser.this.updateSelection(key);
            }
        }
    }
}

