/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.multilevel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.modules.core.metadata.multilevel.SharedEnumOptionsProvider;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class MultiTypeChooserOptionsCalculator
implements IOptionsCalculator {
    private SharedEnumOptionsProvider sharedOptionsProvider;
    private String filter = "";
    private String separator = "";
    private int filterLevel;
    private List<EnumFieldEditor> enumFieldEditors;

    @Override
    public List<EnumOption> options(AbstractFieldEditor ed, IMessageFlowNode node) {
        boolean hasMultiLevel;
        HashSet<EnumOption> filteredList = new HashSet<EnumOption>();
        boolean matchStarted = false;
        boolean isFilterEmpty = StringUtils.isEmpty((String)this.filter);
        boolean hasSeparator = StringUtils.isNotEmpty((String)this.separator);
        boolean bl = hasMultiLevel = this.getEnumFieldEditors().size() > 1;
        if (this.sharedOptionsProvider == null) {
            return Collections.emptyList();
        }
        for (EnumOption op : this.sharedOptionsProvider.getOptionsForLevel(ed, this.filterLevel)) {
            if (op.value != null) {
                String display;
                String value;
                if (this.filterLevel == 0) {
                    value = this.getValue(op);
                    display = this.getDisplay(op);
                    filteredList.add(new EnumOption(value, display));
                    continue;
                }
                if (isFilterEmpty || op.value.startsWith(this.filter)) {
                    if (hasSeparator && !op.value.contains(this.separator) && hasMultiLevel) continue;
                    matchStarted = true;
                    value = this.getValue(op);
                    display = this.getDisplay(op);
                    filteredList.add(new EnumOption(value, display));
                    continue;
                }
                if (!matchStarted) continue;
                break;
            }
            ModulesActivator.logError("An EnumOption value was null.", null);
        }
        return Arrays.asList(filteredList.toArray(new EnumOption[filteredList.size()]));
    }

    private String getDisplay(EnumOption enumOption) {
        String[] labels;
        if (StringUtils.isNotEmpty((String)enumOption.caption) && this.filterLevel < (labels = enumOption.caption.split(Pattern.quote(this.separator))).length) {
            String display = labels[this.filterLevel];
            return display;
        }
        return this.getValue(enumOption);
    }

    private String getValue(EnumOption enumOption) {
        String[] component = enumOption.value.split(Pattern.quote(this.separator));
        if (this.filterLevel >= component.length) {
            return "";
        }
        String value = component[this.filterLevel];
        return value;
    }

    public void updateFilter() {
        if (this.filterLevel == 0 || this.getEnumFieldEditors().isEmpty()) {
            this.filter = "";
        } else {
            StringBuilder currentFilter = new StringBuilder(this.getEnumFieldEditors().get(0).getValue());
            int index = 1;
            while (index < this.getFilterLevel()) {
                currentFilter.append(this.getSeparator()).append(this.getEnumFieldEditors().get(index).getValue());
                ++index;
            }
            currentFilter.append(this.getSeparator());
            this.filter = currentFilter.toString();
        }
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public void setFilterLevel(int filterLevel) {
        this.filterLevel = filterLevel;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public List<EnumFieldEditor> getEnumFieldEditors() {
        if (this.enumFieldEditors == null) {
            this.enumFieldEditors = new ArrayList<EnumFieldEditor>();
        }
        return this.enumFieldEditors;
    }

    public void setEnumFieldEditors(List<EnumFieldEditor> enumFieldEditors) {
        this.enumFieldEditors = enumFieldEditors;
    }

    public void dispose() {
        this.setEnumFieldEditors(null);
    }

    public SharedEnumOptionsProvider getSharedOptionsProvider() {
        return this.sharedOptionsProvider;
    }

    public void setSharedOptionsProvider(SharedEnumOptionsProvider sharedOptionsProvider) {
        this.sharedOptionsProvider = sharedOptionsProvider;
    }
}

