/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.multilevel;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IDataSenseJobListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.multilevel.KeyComponentValueChangeListener;
import org.mule.tooling.ui.modules.core.metadata.multilevel.MultiTypeChooserOptionsCalculator;
import org.mule.tooling.ui.modules.core.metadata.multilevel.SharedEnumOptionsProvider;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.CustomEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.DataSenseTypeChangedEvent;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.MultiTypeChooserControlHelper;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MultiTypeChooserEditor
extends CustomEditor
implements IPropertyValueChangeListener,
IDataSenseJobListener {
    private List<EnumFieldEditor> enumFieldEditors;
    private EventBus eventBus;
    private EventBusHelper eventBusHelper;
    private String oldCompositeKeyValue;
    private String configRefName;
    private SharedEnumOptionsProvider sharedOptionsProvider;

    @Override
    protected void initialize() {
        this.oldCompositeKeyValue = "";
        this.enumFieldEditors = new ArrayList<EnumFieldEditor>();
        this.sharedOptionsProvider = new SharedEnumOptionsProvider();
    }

    public MultiTypeChooserEditor(AttributesPropertyPage parentPage, AttributeHelper helper, AttributeGroup attributeGroup, Composite groupComposite) {
        super(parentPage, helper, attributeGroup, groupComposite);
    }

    @Override
    public void refreshEditor(String newValue, boolean shouldNotifyObservers) {
        if (StringUtils.isNotEmpty((String)this.configRefName) && this.configRefName.equals(newValue)) {
            return;
        }
        this.configRefName = newValue;
        if (!this.getEnumFieldEditors().isEmpty()) {
            for (EnumFieldEditor editor : this.getEnumFieldEditors()) {
                editor.setValue("");
            }
            for (EnumFieldEditor editor : this.getEnumFieldEditors()) {
                editor.refreshEditor("", false);
                editor.validate();
            }
        }
        this.getParentPage().validate();
        this.oldCompositeKeyValue = "";
    }

    @Override
    protected Control createControl(AttributesPropertyPage parentPage) {
        MultiTypeChooserControlHelper multiTypeControlHelper = this.getControlHelper();
        Group container = this.getGroup(parentPage, multiTypeControlHelper);
        for (AttributeHelper helper : multiTypeControlHelper.getInnerAttributeHelpers()) {
            EnumFieldEditor enumEditor = new EnumFieldEditor(new AttributeContext(), helper, (Composite)container);
            this.getEnumFieldEditors().add(enumEditor);
            enumEditor.setParentPage(parentPage);
            EnumHelper enumHelper = (EnumHelper)enumEditor.getHelper();
            MultiTypeChooserOptionsCalculator calculator = (MultiTypeChooserOptionsCalculator)enumHelper.getOptionsCalculator();
            calculator.setEnumFieldEditors(this.getEnumFieldEditors());
            calculator.setSharedOptionsProvider(this.sharedOptionsProvider);
            enumEditor.setValue("");
            enumEditor.refreshEditor("", false);
        }
        this.addPropertyChangeListeners();
        this.registerEventBus(container);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        return container;
    }

    private void addPropertyChangeListeners() {
        EnumFieldEditor previous = null;
        for (EnumFieldEditor editor : this.getEnumFieldEditors()) {
            EnumHelper enumHelper = (EnumHelper)editor.getHelper();
            MultiTypeChooserOptionsCalculator calculator = (MultiTypeChooserOptionsCalculator)enumHelper.getOptionsCalculator();
            if (previous != null) {
                previous.addPropertyChangeListener(new KeyComponentValueChangeListener(editor, calculator));
            }
            previous = editor;
        }
        previous.addPropertyChangeListener(this);
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.configRefName = MetadataUtils.getGlobalReference((IMessageFlowNode)node);
        List<EnumFieldEditor> editors = this.getEnumFieldEditors();
        if (StringUtils.isNotEmpty((String)this.configRefName)) {
            String propertyValue;
            this.oldCompositeKeyValue = propertyValue = props.getProperty(this.getControlHelper().getAttributeName(), "");
            String[] components = propertyValue.split(Pattern.quote(this.getSeparator()));
            int index = 0;
            String lastValue = "";
            for (EnumFieldEditor editor : editors) {
                String value;
                lastValue = value = this.getValue(components, index);
                editor.setValue(value);
                ++index;
            }
            if (!editors.isEmpty()) {
                editors.get(0).refreshEditor(lastValue, false);
            }
        } else if (!editors.isEmpty()) {
            editors.get(0).refreshEditor("", false);
        }
    }

    private String getValue(String[] components, int index) {
        if (index >= components.length) {
            return "";
        }
        return components[index];
    }

    private String getSeparator() {
        return this.getControlHelper().getSeparator();
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        ArrayList<String> values = new ArrayList<String>();
        for (EnumFieldEditor keyComponent : this.enumFieldEditors) {
            if (keyComponent.isDisposed() || !StringUtils.isNotBlank((String)keyComponent.getValue())) continue;
            values.add(keyComponent.getValue());
        }
        if (!values.isEmpty()) {
            if (values.size() == 1) {
                props.addProperty(this.getControlHelper().getAttributeName(), (String)values.get(0));
            } else {
                props.addProperty(this.getControlHelper().getAttributeName(), StringUtils.join(values, (String)this.getSeparator()));
            }
        } else {
            props.addProperty(this.getControlHelper().getAttributeName(), "");
        }
    }

    @Override
    public void propertyChanged(String propertyName, String oldValue, String newValue) {
        ArrayList<String> values = new ArrayList<String>();
        for (EnumFieldEditor editor : this.getEnumFieldEditors()) {
            if (!StringUtils.isNotBlank((String)editor.getValue())) continue;
            values.add(editor.getValue());
        }
        if (!values.isEmpty() && values.size() == this.getEnumFieldEditors().size()) {
            String currentCompositeKeyValue;
            String string = currentCompositeKeyValue = values.size() > 1 ? StringUtils.join(values, (String)this.getSeparator()) : (String)values.get(0);
            if (!this.oldCompositeKeyValue.equals(currentCompositeKeyValue)) {
                this.oldCompositeKeyValue = currentCompositeKeyValue;
                this.eventBus.fireEvent((IEvent)DataSenseTypeChangedEvent.newInstance());
            }
        }
    }

    public void onDataSenseJobRunning(IMuleProject muleProject, IMessageFlowNode node) {
    }

    public void onDataSenseJobSuccessfulCompletion(IMuleProject muleProject, IMessageFlowNode node) {
        if (!this.isDisposed() && MetadataHelpers.belongsToPropertyPage(muleProject, node, this.getParentPage())) {
            this.enumFieldEditors.get(0).toogleWarningIndicator(false);
        }
    }

    public void onDataSenseJobCancellation(IMuleProject muleProject, IMessageFlowNode node) {
    }

    public void onDataSenseJobError(IMuleProject muleProject, IMessageFlowNode messageFlowNode) {
        if (!this.isDisposed() && MetadataHelpers.belongsToPropertyPage(muleProject, messageFlowNode, this.getParentPage())) {
            this.enumFieldEditors.get(0).toogleWarningIndicator(true);
        }
    }

    private void registerEventBus(Group container) {
        this.eventBus = MuleCorePlugin.getEventBus();
        this.eventBusHelper = new EventBusHelper();
        this.eventBusHelper.registerUIListener(this.eventBus, CoreEventTypes.ON_DATASENSE_JOB_EVENT, (IEventHandler)this);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MultiTypeChooserEditor.this.sharedOptionsProvider.clear();
                for (EnumFieldEditor editor : MultiTypeChooserEditor.this.getEnumFieldEditors()) {
                    MultiTypeChooserOptionsCalculator calculator = (MultiTypeChooserOptionsCalculator)((EnumHelper)editor.getHelper()).getOptionsCalculator();
                    calculator.dispose();
                }
                MultiTypeChooserEditor.this.eventBusHelper.unregister();
                MultiTypeChooserEditor.this.eventBus = null;
            }
        });
    }

    private MultiTypeChooserControlHelper getControlHelper() {
        return (MultiTypeChooserControlHelper)this.getHelper();
    }

    private List<EnumFieldEditor> getEnumFieldEditors() {
        return this.enumFieldEditors;
    }

    private Group getGroup(AttributesPropertyPage parentPage, MultiTypeChooserControlHelper multiTypeControlHelper) {
        Group parent = null;
        Control[] controlArray = parentPage.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Group group;
            Control control = controlArray[n2];
            if (control instanceof Group && (group = (Group)control).getText().equalsIgnoreCase("general")) {
                parent = group;
                break;
            }
            ++n2;
        }
        if (parent == null) {
            parent = UiUtils.createGroupWithTitle((Composite)parentPage, (String)StringUtils.capitalize((String)multiTypeControlHelper.getAttributeName()), (int)3);
        }
        return parent;
    }

    @Override
    public IStatus validate() {
        IStatus status = Status.OK_STATUS;
        for (EnumFieldEditor editor : this.enumFieldEditors) {
            if (!StringUtils.isEmpty((String)editor.getValue())) continue;
            AttributeHelper attributeHelper = editor.getHelper();
            String attrLabel = StringUtils.isNotBlank((String)attributeHelper.getSaveAs()) ? attributeHelper.getSaveAs() : attributeHelper.getId();
            String error = "Attribute '" + attrLabel + "' is required";
            editor.setError(error);
            return new Status(4, "org.mule.tooling.ui.modules.core", error);
        }
        return status;
    }
}

