/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.multilevel;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.modules.core.metadata.multilevel.MultiTypeChooserOptionsCalculator;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class KeyComponentValueChangeListener
implements IPropertyValueChangeListener {
    private final EnumFieldEditor enumFieldEditor;
    private final MultiTypeChooserOptionsCalculator propertyCalculator;

    public KeyComponentValueChangeListener(EnumFieldEditor enumFieldEditor, MultiTypeChooserOptionsCalculator propertyCalculator) {
        this.enumFieldEditor = enumFieldEditor;
        this.propertyCalculator = propertyCalculator;
    }

    @Override
    public void propertyChanged(String propertyName, String oldValue, String newValue) {
        this.propertyCalculator.updateFilter();
        if (StringUtils.isEmpty((String)newValue)) {
            this.enumFieldEditor.refreshEditor("", false);
        } else if (this.containsOption(this.enumFieldEditor.getValue())) {
            this.enumFieldEditor.refreshEditor(this.enumFieldEditor.getValue(), false);
        } else {
            this.enumFieldEditor.refreshEditor("", false);
        }
    }

    private boolean containsOption(String currentValue) {
        List<EnumOption> options = this.propertyCalculator.options(null, null);
        if (options != null) {
            for (EnumOption option : options) {
                String value = option.value;
                if (value != null) {
                    if (!value.equals(currentValue)) continue;
                    return true;
                }
                ModulesActivator.logError("EnumOption value was null", null);
            }
        }
        return false;
    }
}

