/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.management;

import java.util.ArrayList;
import java.util.List;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.modules.core.metadata.management.MetadataTypeTreeNodeModel;
import org.mule.tooling.ui.widgets.tree.model.EmptyGraphicalChildrenProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class MetadataTypesTreeProvider
implements IGraphicalChildrenProvider<MetadataTypeTreeNodeModel> {
    private static final String USER_DEFINED_LABEL = "User Defined";
    private IMuleProject project;

    public MetadataTypesTreeProvider(IMuleProject project) {
        this.project = project;
    }

    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<MetadataTypeTreeNodeModel> parent) {
        ArrayList response = new ArrayList();
        int customTypesSize = this.getTypesManager().getCustomMetadataKeys().size();
        if (customTypesSize > 0) {
            String label = USER_DEFINED_LABEL;
            MetadataTypeTreeNodeModel model = new MetadataTypeTreeNodeModel("#Custom Type#", null, null, false);
            MetadataKeysChildrenProvider childrenFactory = new MetadataKeysChildrenProvider(this.project);
            GraphicalTreeNode node = new GraphicalTreeNode(parent, label, "#Custom Type#", (Object)model, (IGraphicalChildrenProvider)childrenFactory);
            response.add(node);
        }
        return response;
    }

    private ITypesManager getTypesManager() {
        return ((MetadataTypesManager)this.project.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }

    private static class MetadataKeysChildrenProvider
    implements IGraphicalChildrenProvider<MetadataTypeTreeNodeModel> {
        private IMuleProject project;

        public MetadataKeysChildrenProvider(IMuleProject project) {
            this.project = project;
        }

        public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<MetadataTypeTreeNodeModel> parent) {
            ArrayList response = new ArrayList();
            ITypesManager typesManager = this.getTypesManager();
            for (MetadataKey key : typesManager.getCustomMetadataKeys()) {
                MetadataType metadataType = typesManager.getCustomMetadataType(key);
                if (metadataType.getAnnotation(AutogeneratedAnnotation.class).isPresent()) continue;
                response.add(this.createTreeNode(parent, MetadataTypeHelper.getLabel(metadataType, key.getId()), key, metadataType));
            }
            return response;
        }

        private GraphicalTreeNode<MetadataTypeTreeNodeModel> createTreeNode(GraphicalTreeNode<MetadataTypeTreeNodeModel> parent, String label, MetadataKey key, MetadataType metadataType) {
            String metadataKeyId = key.getId();
            MetadataTypeTreeNodeModel model = new MetadataTypeTreeNodeModel("#Custom Type#", metadataKeyId, null, true);
            model.setMetadataType(metadataType);
            return new GraphicalTreeNode(parent, label, metadataKeyId, (Object)model, this.emptyFactory());
        }

        private IGraphicalChildrenProvider<MetadataTypeTreeNodeModel> emptyFactory() {
            return new EmptyGraphicalChildrenProvider();
        }

        private ITypesManager getTypesManager() {
            return ((MetadataTypesManager)this.project.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
        }
    }
}

