/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.management;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.dialog.DialogConstants;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.typeSelection.BaseMetadataTypeSelectionEditor;

public class MetadataManagementDialog
extends TitleAreaDialog {
    private IMuleProject muleProject;
    private BaseMetadataTypeSelectionEditor selectMetadataEditor;
    private ChangeManager changeManager;

    public MetadataManagementDialog(Shell parent, IMuleProject muleProject) {
        super(parent);
        this.muleProject = muleProject;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        return new Point(DialogConstants.STANDARD_DIALOG_SIZE.x + 280, DialogConstants.STANDARD_DIALOG_SIZE.y);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Manage Metadata Types");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        if (this.changeManager.areChanges()) {
            this.selectMetadataEditor.checkForEditorChanges();
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(DialogConstants.MINIMUM_DIALOG_SIZE);
        this.setTitle("Select Type");
        this.setMessage("Select the type you want to refresh/delete to enable the actions");
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)wrapper);
        this.changeManager = new ChangeManager();
        this.selectMetadataEditor = new BaseMetadataTypeSelectionEditor(wrapper, this.muleProject, new OnValidationMessage(){

            @Override
            public void setValidationMessage(String message) {
                MetadataManagementDialog.this.setErrorMessage(message);
            }

            @Override
            public void clear() {
                MetadataManagementDialog.this.setErrorMessage(null);
            }
        }, this.changeManager);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.selectMetadataEditor);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.selectMetadataEditor);
        return wrapper;
    }
}

