/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.management;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.ui.modules.core.metadata.management.MetadataTypeTreeNodeModel;
import org.mule.tooling.ui.modules.core.metadata.management.NodeSelectionProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class DeleteAction
extends Action {
    private static final String DELETE_ACTION_TEXT = "Delete";
    private final NodeSelectionProvider selection;
    private final IMuleProject project;
    private final Shell parent;
    private final Runnable callback;

    public DeleteAction(Shell parent, IMuleProject project, NodeSelectionProvider selection, Runnable onDeletionCallback) {
        super(DELETE_ACTION_TEXT, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        this.parent = parent;
        this.project = project;
        this.selection = selection;
        this.callback = onDeletionCallback;
    }

    public void run() {
        GraphicalTreeNode<MetadataTypeTreeNodeModel> graphicalNode = this.selection.getGraphicalNodeFromSelection();
        if (graphicalNode != null) {
            MetadataTypeTreeNodeModel model = (MetadataTypeTreeNodeModel)graphicalNode.getModel();
            String module = model.getModule();
            String key = model.getKey();
            boolean shouldDelete = MessageDialog.openQuestion((Shell)this.parent, (String)"Confirm structure removal", (String)("Do you want to delete the structure of type " + key + "?"));
            if (shouldDelete) {
                ITypesManager typesManager = ((MetadataTypesManager)this.project.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
                if (model.isCustomType()) {
                    MetadataKey metadataKey = ToolingMetadataKeyBuilder.newKey((String)key).build();
                    typesManager.removeCustomMetadata(metadataKey);
                } else {
                    MetadataKey metadataKey = ToolingMetadataKeyBuilder.newKey((String)key).build();
                    typesManager.removeMetadataType(module, "#Default Category#", metadataKey);
                }
                this.callback();
            }
        }
    }

    private void callback() {
        this.callback.run();
    }
}

