/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.selection;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.selection.MetadataSelectionValidator;
import org.mule.tooling.ui.modules.core.metadata.typeSelection.BaseMetadataTypeSelectionEditor;

public class SelectMetadataEditor
extends BaseMetadataTypeSelectionEditor
implements IMetadataDefinitionEditor {
    private Button wrapElementInList;

    public SelectMetadataEditor(Composite parent, IMuleProject muleProject, OnValidationMessage onValidationMessage, ChangeManager changeManager) {
        super(parent, muleProject, onValidationMessage, changeManager);
    }

    @Override
    protected void createControls(Composite parent) {
        super.createControls(parent);
        Composite listWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(listWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)listWrapper);
        this.wrapElementInList = new Button(listWrapper, 32);
        this.wrapElementInList.setText("Wrap element in a collection");
        GridDataFactory.fillDefaults().applyTo((Control)this.wrapElementInList);
    }

    @Override
    protected void onSelectionChanged(SelectionChangedEvent event) {
        super.onSelectionChanged(event);
        this.updateWrapInListCheckbox();
    }

    private void updateWrapInListCheckbox() {
        boolean supportCollections;
        MetadataDefinitionConfiguration selection = this.getSelectedModel();
        boolean bl = supportCollections = selection != null && MetadataUtils.supportCollections((MetadataType)selection.getMetadataType());
        if (!supportCollections) {
            this.wrapElementInList.setSelection(false);
            this.wrapElementInList.setEnabled(false);
        } else {
            this.wrapElementInList.setEnabled(true);
        }
    }

    @Override
    public IMetadataDefinitionValidator getValidator() {
        return new MetadataSelectionValidator();
    }

    @Override
    public MetadataResult getResult() {
        MetadataResult result = MetadataResult.createEmpty();
        result.setIsCollection(this.wrapElementInList.getSelection());
        String module = this.getModule();
        String selectedKey = this.getKey();
        if (StringUtils.isNotBlank((String)selectedKey) && StringUtils.isNotBlank((String)module)) {
            result.setMetadataType(this.getTypesManager().getMetadataType(module, "#Default Category#", ToolingMetadataKeyBuilder.newKey((String)selectedKey).build()));
            result.setModule(module);
            result.setKey(selectedKey);
        }
        return result;
    }

    @Override
    public void validate() {
        if (this.getSelectedModel() != null && this.getSelectedModel().getKey() != null) {
            this.getOnValidationMessage().clear();
        } else {
            this.getOnValidationMessage().setValidationMessage("Type selection is needed");
        }
    }

    @Override
    public void applyChanges() {
        this.applyChangesInEditor();
    }

    @Override
    public void onRefresh() {
    }

    @Override
    public void trackCustomType(MetadataResult metadata) {
        if (metadata != null && metadata.getMetadataType() != null) {
            AnalyticsRecordsFactory.single((String)Events.CUSTOM_TYPE_USED).addMetadata("customType", metadata.getMetadataType().getMetadataFormat().getId()).track();
        }
    }
}

