/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.metadata.MetadataTypeGraphicalChildrenProvider;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.mule.xml.exception.MuleXmlException;
import org.mule.tooling.mule.xml.schemas.MuleSchemaGlobalElement;
import org.mule.tooling.mule.xml.schemas.MuleSchemaTypeSystem;
import org.mule.tooling.mule.xml.schemas.XmlSchemaUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.ModeElement;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.xml.FromExampleElement;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.xml.FromSchemaElement;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.xml.XMLModeElement;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;

public class XMLMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    public static final String INVALID_FILE_MESSAGE = "''{0}'' does not exist or is not a valid file";
    private static final String INVALID_XSD_DEPENDENCY_MESSAGE = "''{0}'' already exists, it is being used in the current schema as import or include dependency";
    private static final String INVALID_XML_MESSAGE = "Invalid XML file. Check encoding and/or characters format";
    private XMLModeElement fromSchemaElement = new FromSchemaElement();
    private XMLModeElement fromExampleElement = new FromExampleElement();
    private XMLModeElement[] modes = new XMLModeElement[]{this.fromSchemaElement, this.fromExampleElement};
    private Text filePath;
    private ComboViewer rootElement;
    private Composite rootElementWrapper;
    private StructuredViewer modeComboViewer;
    private Label messageLabel;
    private TreeViewer detailsTree;
    private String xmlErrorMessage = null;
    private Optional<MetadataType> editedModel;
    private List<Resource> resources = Collections.emptyList();

    public XMLMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.createControl(this);
    }

    @Override
    public MetadataResult calculateMetadata() {
        try {
            MetadataType metadataType = this.getSelectedMode().getMetadata();
            return MetadataResult.from(metadataType);
        }
        catch (Exception e) {
            return MetadataResult.from(e.getLocalizedMessage());
        }
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        Button openSchemaButton = this.createResourceSelector(wrapper);
        this.messageLabel = this.createMessageLabel(wrapper);
        this.createRootElementSection(wrapper);
        this.editedModel = Optional.ofNullable(this.getMetadataTypeFromCache(this.getPreviousKey()));
        this.detailsTree = this.createDetailsTree(parent, this.editedModel);
        this.loadMode(this.editedModel);
        this.createUIListeners(wrapper, openSchemaButton);
    }

    private void createRootElementSection(Composite wrapper) {
        this.rootElementWrapper = new Composite(wrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.rootElementWrapper);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.rootElementWrapper);
        Label rootLabel = new Label(this.rootElementWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)rootLabel);
        rootLabel.setText("Root Element Name");
        this.rootElement = new ComboViewer(this.rootElementWrapper, 8);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo(this.rootElement.getControl());
        this.rootElement.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.rootElement.setLabelProvider((IBaseLabelProvider)new RootElementLabelProvider());
    }

    private Button createResourceSelector(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        this.createModeViewer(wrapper);
        this.filePath = new Text(wrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filePath);
        this.filePath.setMessage(this.getCurrentSelectedMode().getMessage());
        Button openSchemaButton = new Button(wrapper, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)openSchemaButton);
        openSchemaButton.setText("...");
        return openSchemaButton;
    }

    @Override
    public void onRefresh() {
        this.refresh();
    }

    private void loadMode(Optional<MetadataType> maybeMetadataType) {
        if (maybeMetadataType.isPresent()) {
            String selectedRootElement;
            MetadataType metadataType = maybeMetadataType.get();
            Optional maybeOriginAnnotation = metadataType.getAnnotation(OriginAnnotation.class);
            Optional maybePathAnnotation = metadataType.getAnnotation(PathAnnotation.class);
            Optional maybeRootElementAnnotation = metadataType.getAnnotation(ElementAnnotation.class);
            OriginAnnotation originAnnotation = (OriginAnnotation)maybeOriginAnnotation.orElseThrow(() -> new RuntimeException("Invalid origin"));
            ElementAnnotation rootElementAnnotation = (ElementAnnotation)maybeRootElementAnnotation.orElseThrow(() -> new RuntimeException("Invalid root element"));
            boolean isExample = originAnnotation.getOrigin().equals((Object)MetadataTypeOrigin.EXAMPLE);
            originAnnotation.getOrigin().equals((Object)MetadataTypeOrigin.WEAVE);
            this.modeComboViewer.setSelection((ISelection)new StructuredSelection((Object)(isExample ? this.fromExampleElement : this.fromSchemaElement)));
            if (maybePathAnnotation.isPresent()) {
                String resourcePath = ((PathAnnotation)maybePathAnnotation.get()).getPath();
                this.filePath.setText(resourcePath);
                this.resources = Resource.create(resourcePath, this.getMuleProject()).map(r -> Collections.singletonList(r)).orElse(Collections.emptyList());
            }
            if (StringUtils.isNotBlank((String)(selectedRootElement = rootElementAnnotation.getElement()))) {
                this.updateRootElement();
                MuleSchemaGlobalElement muleSchemaGlobalElement = this.findElement(selectedRootElement);
                this.rootElement.setSelection((ISelection)(muleSchemaGlobalElement != null ? new StructuredSelection((Object)muleSchemaGlobalElement) : StructuredSelection.EMPTY));
            }
        }
    }

    private void createUIListeners(final Composite wrapper, Button openSchemaButton) {
        this.filePath.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] selectedResources = XMLMetadataDefinitionEditor.this.filePath.getText().split(",");
                List selectedResourcesList = Arrays.stream(selectedResources).filter(resource -> StringUtils.isNotBlank((String)resource)).collect(Collectors.toList());
                XMLMetadataDefinitionEditor.this.resources = new ArrayList<Resource>();
                for (String resourcePath : selectedResourcesList) {
                    Resource.create(resourcePath, XMLMetadataDefinitionEditor.this.getMuleProject()).ifPresent(r -> {
                        boolean bl = XMLMetadataDefinitionEditor.this.resources.add((Resource)r);
                    });
                }
                try {
                    XMLMetadataDefinitionEditor.this.checkFilesToCopy(XMLMetadataDefinitionEditor.this.getSelectedMode());
                    XMLMetadataDefinitionEditor.this.refresh();
                }
                catch (Throwable t) {
                    MuleCorePlugin.logError((String)"Error refreshing XML custom metadata dialog status", (Throwable)t);
                }
            }
        }, (Control)wrapper));
        openSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List result = XMLMetadataDefinitionEditor.this.filePickerButtonPressed(XMLMetadataDefinitionEditor.this.getSelectedMode().isAllowsMultiple(), XMLMetadataDefinitionEditor.this.getSelectedMode().getValidExtensionsFilterNames(), XMLMetadataDefinitionEditor.this.getSelectedMode().getValidExtensions(), wrapper.getShell());
                if (!result.isEmpty()) {
                    XMLModeElement mode = XMLMetadataDefinitionEditor.this.getSelectedMode();
                    XMLMetadataDefinitionEditor.this.messageLabel.setText("");
                    XMLMetadataDefinitionEditor.this.resources = result.stream().map(f -> Resource.create(f, XMLMetadataDefinitionEditor.this.getMuleProject())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                    XMLMetadataDefinitionEditor.this.checkFilesToCopy(mode);
                    XMLMetadataDefinitionEditor.this.filePath.setText(XMLMetadataDefinitionEditor.this.getFileTextFromSelectedResources(XMLMetadataDefinitionEditor.this.resources, mode.getFolder()));
                }
            }
        });
        this.modeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XMLModeElement mode = XMLMetadataDefinitionEditor.this.getSelectedMode();
                XMLMetadataDefinitionEditor.this.filePath.setText("");
                XMLMetadataDefinitionEditor.this.filePath.setMessage(mode.getMessage());
                XMLMetadataDefinitionEditor.this.messageLabel.setText("");
                XMLMetadataDefinitionEditor.this.resources = Collections.emptyList();
                XMLMetadataDefinitionEditor.this.refresh();
            }
        });
        this.addRootElementSelectionListener();
    }

    private void refresh() {
        this.updateRootElement();
        this.validate();
        this.refreshDetailsTree();
        this.recordChange();
    }

    @Override
    protected MetadataType filterMetadataType(MetadataType metadataType) {
        MetadataType temp = metadataType;
        if (temp instanceof ArrayType) {
            temp = ((ArrayType)metadataType).getType();
        }
        if (temp instanceof ObjectType && MetadataFormat.XML.equals((Object)temp.getMetadataFormat())) {
            return temp;
        }
        return null;
    }

    private void refreshDetailsTree() {
        this.editedModel = Optional.ofNullable(this.calculateMetadata().getMetadataType());
        this.detailsTree.setInput(this.getRoot(this.editedModel));
        this.detailsTree.expandToLevel(4);
    }

    private void createModeViewer(Composite wrapper) {
        this.modeComboViewer = new ComboViewer(wrapper);
        GridDataFactory.swtDefaults().applyTo(this.modeComboViewer.getControl());
        this.modeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ModeElement mode = (ModeElement)element;
                return mode.getLabel();
            }
        });
        this.fillModeCombo();
    }

    private XMLModeElement getCurrentSelectedMode() {
        StructuredSelection selection = (StructuredSelection)this.modeComboViewer.getSelection();
        XMLModeElement currentMode = (XMLModeElement)selection.getFirstElement();
        return currentMode;
    }

    private XMLModeElement getSelectedMode() {
        XMLModeElement currentMode = this.getCurrentSelectedMode();
        if (!this.resources.isEmpty()) {
            currentMode.setResourcePath(this.getResourcePath(this.resources.get(0), currentMode.getFolder()));
            currentMode.setSelectedResources(this.resources);
        }
        currentMode.setSelectedRoot(this.getRootName());
        currentMode.setMuleProject(this.getMuleProject());
        return currentMode;
    }

    private void fillModeCombo() {
        this.modeComboViewer.setInput((Object)this.modes);
        this.modeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.modes[0]));
    }

    @Override
    public void doValidate() {
        boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
        if (!validKey) {
            this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
        } else {
            String errorMessage = this.validateSelectedPaths();
            if (StringUtils.isNotEmpty((String)errorMessage)) {
                if (this.editedModel.isPresent()) {
                    this.getOnValidationMessage().clear();
                } else {
                    this.getOnValidationMessage().setValidationMessage(errorMessage);
                }
            } else {
                errorMessage = this.validateDependencies();
                if (StringUtils.isNotEmpty((String)errorMessage)) {
                    this.getOnValidationMessage().setValidationMessage(errorMessage);
                } else if (StringUtils.isNotEmpty((String)this.xmlErrorMessage)) {
                    this.getOnValidationMessage().setValidationMessage(this.xmlErrorMessage);
                } else {
                    QName rootElement = this.getRootName();
                    if (rootElement == null && !this.resources.isEmpty()) {
                        this.getOnValidationMessage().setValidationMessage("No XML root element selected");
                    } else {
                        MetadataResult result = this.getMetadata();
                        if (result.isValid()) {
                            this.getOnValidationMessage().clear();
                        } else if (this.editedModel.isPresent()) {
                            this.getOnValidationMessage().clear();
                        } else {
                            this.getOnValidationMessage().setValidationMessage(result.getMessage());
                        }
                    }
                }
            }
        }
    }

    private QName getRootName() {
        StructuredSelection selection = (StructuredSelection)this.rootElement.getSelection();
        MuleSchemaGlobalElement globalElement = (MuleSchemaGlobalElement)selection.getFirstElement();
        if (globalElement != null) {
            return globalElement.getName();
        }
        return null;
    }

    private String validateSelectedPaths() {
        for (Resource resource : this.resources) {
            File f;
            if (!StringUtils.isNotBlank((String)resource.getPath()) || (f = XMLMetadataDefinitionEditor.resolvePath(this.getMuleProject(), resource)).exists() && !f.isDirectory()) continue;
            return MessageFormat.format(INVALID_FILE_MESSAGE, resource.getPath());
        }
        return null;
    }

    private String validateDependencies() {
        IFolder resourceFolder = this.getResourceFolder(this.getSelectedMode().getFolder());
        return Resource.getResourcesToCopyStream(this.resources).map(resource -> {
            File sourceFile = resource.getFile();
            Set<File> resourcesToCopy = this.getSelectedMode().getResourcesToCopy(sourceFile);
            Path rootPath = Paths.get(sourceFile.getParentFile().toURI());
            for (File currentResource : resourcesToCopy) {
                Path currentPath = Paths.get(currentResource.getParentFile().toURI());
                Path relativizePath = rootPath.relativize(currentPath);
                try {
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (FileInputStream content = new FileInputStream(currentResource);){
                        IFile file;
                        IFolder currentFolder = resourceFolder.getFolder(relativizePath.toString());
                        String uniqueName = currentResource.getName();
                        if (sourceFile.equals(currentResource)) {
                            uniqueName = MuleResourceUtils.getUniqueFileName((File)currentFolder.getRawLocation().toFile(), (String)uniqueName);
                        }
                        if (!(file = currentFolder.getFile(uniqueName)).exists()) continue;
                        return MessageFormat.format(INVALID_XSD_DEPENDENCY_MESSAGE, uniqueName);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    MuleCorePlugin.logError((String)"Error validating xsd dependencies", (Throwable)e);
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void updateRootElement() {
        try {
            this.xmlErrorMessage = null;
            MuleSchemaTypeSystem schemaTypeSystem = this.extractSchemas();
            if (schemaTypeSystem != null) {
                MuleSchemaGlobalElement[] globalElements = schemaTypeSystem.globalElements();
                this.rootElement.setInput((Object)globalElements);
                if (globalElements.length > 0) {
                    this.rootElement.setSelection((ISelection)new StructuredSelection((Object)globalElements[0]));
                }
                this.rootElement.refresh();
                this.rootElementWrapper.layout(true, true);
            }
        }
        catch (MuleXmlException muleXmlException) {
            this.xmlErrorMessage = INVALID_XML_MESSAGE;
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Unexpected error while loading schema", (Throwable)e);
        }
    }

    private MuleSchemaGlobalElement findElement(String selectedRootElement) {
        MuleSchemaGlobalElement element = null;
        Object input = this.rootElement.getInput();
        if (input != null) {
            MuleSchemaGlobalElement[] globalElements;
            MuleSchemaGlobalElement[] muleSchemaGlobalElementArray = globalElements = (MuleSchemaGlobalElement[])input;
            int n = globalElements.length;
            int n2 = 0;
            while (n2 < n) {
                MuleSchemaGlobalElement muleSchemaGlobalElement = muleSchemaGlobalElementArray[n2];
                if (selectedRootElement.equals(muleSchemaGlobalElement.getName().toString())) {
                    element = muleSchemaGlobalElement;
                    break;
                }
                ++n2;
            }
        }
        return element;
    }

    private MuleSchemaTypeSystem extractSchemas() throws Exception {
        MuleSchemaTypeSystem schemaTypeSystem = null;
        XMLModeElement currentMode = this.getSelectedMode();
        List<URL> schemasUrls = currentMode.getSchemaURLs(this.resources);
        if (schemasUrls != null) {
            schemaTypeSystem = XmlSchemaUtils.getSchemaTypeSystem((URL[])schemasUrls.toArray(new URL[0]));
        } else {
            List<String> schemas = currentMode.getSchemas(this.resources);
            if (schemas != null) {
                schemaTypeSystem = XmlSchemaUtils.getSchemaTypeSystem(schemas);
            }
        }
        return schemaTypeSystem;
    }

    private void addRootElementSelectionListener() {
        final ISelectionChangedListener rootElementListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XMLMetadataDefinitionEditor.this.validate();
                XMLMetadataDefinitionEditor.this.refreshDetailsTree();
                XMLMetadataDefinitionEditor.this.recordChange();
            }
        };
        this.rootElement.addSelectionChangedListener(rootElementListener);
        this.rootElement.getCombo().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XMLMetadataDefinitionEditor.this.rootElement.removeSelectionChangedListener(rootElementListener);
            }
        });
    }

    private void checkFilesToCopy(ModeElement mode) {
        Resource.getResourcesToCopyMessage(this.resources).ifPresent(message -> this.messageLabel.setText(message + " will be copied to src/main/resources/" + mode.getFolder()));
    }

    @Override
    protected MetadataTypeGraphicalChildrenProvider createMetaDataModelGraphicalChildrenProvider() {
        return new MetadataTypeGraphicalChildrenProvider();
    }

    @Override
    public void applyChanges() {
        IFolder resourceFolder = this.getResourceFolder(this.getSelectedMode().getFolder());
        Resource.getResourcesToCopyStream(this.resources).forEach(resource -> {
            File sourceFile = resource.getFile();
            Set<File> resourcesToCopy = this.getSelectedMode().getResourcesToCopy(sourceFile);
            Path rootPath = Paths.get(sourceFile.getParentFile().toURI());
            for (File currentResource : resourcesToCopy) {
                Path currentPath = Paths.get(currentResource.getParentFile().toURI());
                Path relativizePath = rootPath.relativize(currentPath);
                try {
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (FileInputStream content = new FileInputStream(currentResource);){
                        IFolder currentFolder = resourceFolder.getFolder(relativizePath.toString());
                        MuleResourceUtils.create((IResource)currentFolder);
                        String uniqueName = MuleResourceUtils.getUniqueFileName((File)currentFolder.getRawLocation().toFile(), (String)currentResource.getName());
                        MuleResourceUtils.createFile((IFolder)currentFolder, (String)uniqueName, (InputStream)MuleResourceUtils.skipBOM((InputStream)content));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException e) {
                    MuleCorePlugin.logError((String)"Error copying resources", (Throwable)e);
                }
            }
        });
    }

    private final class RootElementLabelProvider
    extends LabelProvider {
        private RootElementLabelProvider() {
        }

        public String getText(Object element) {
            MuleSchemaGlobalElement globalElement = (MuleSchemaGlobalElement)element;
            return globalElement.getName().toString();
        }
    }
}

