/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types.xml;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.mule.xml.schemas.XmlSchemaUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.xml.XMLModeElement;

public class FromSchemaElement
implements XMLModeElement {
    private QName rootName;
    private String resourcePath;
    private IMuleProject muleProject;
    private List<Resource> resources = Collections.emptyList();

    @Override
    public String getLabel() {
        return "Schema";
    }

    @Override
    public String getMessage() {
        return "Select your XML schema file";
    }

    @Override
    public String getFolder() {
        return "schemas";
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public MetadataType getMetadata() throws Exception {
        Preconditions.checkArgument((!this.resources.isEmpty() ? 1 : 0) != 0, (Object)"A XML schema file path should be selected");
        return this.getMetadataFromSchemaURLs(this.getSchemaURLs(this.resources));
    }

    private MetadataType getMetadataFromSchemaURLs(List<URL> schemaUrls) throws MalformedURLException {
        HashMap<Class, Object> annotations = new HashMap<Class, Object>();
        QName rootName = this.getSelectedRoot();
        Objects.requireNonNull(rootName);
        SchemaCollector collector = SchemaCollector.getInstance();
        schemaUrls.forEach(urls -> {
            SchemaCollector schemaCollector2 = collector.addSchema(urls);
        });
        XmlTypeLoader loader = new XmlTypeLoader(collector);
        Optional maybeMetadataType = loader.load(rootName, null);
        MetadataType metadataType = (MetadataType)maybeMetadataType.orElseThrow(() -> new IllegalArgumentException("The provided XML could not be parsed as XML Schema"));
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_XML));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
        annotations.put(PathAnnotation.class, new PathAnnotation(this.resourcePath));
        annotations.put(ElementAnnotation.class, new ElementAnnotation(rootName.toString()));
        return MetadataTypeProxy.proxying((MetadataType)metadataType, annotations);
    }

    @Override
    public List<String> getSchemas(List<Resource> selectedResources) {
        ArrayList<String> schemas = new ArrayList<String>();
        for (Resource selectedResource : selectedResources) {
            File f = BaseMetadataDefinitionEditor.resolvePath(this.getMuleProject(), selectedResource);
            if (f.exists() && !f.isDirectory()) {
                try {
                    Throwable throwable = null;
                    Object var7_8 = null;
                    try (FileInputStream is = new FileInputStream(f);){
                        schemas.add(IOUtils.toString((InputStream)is));
                        continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Cannot read schema file " + selectedResource.getPath());
                }
            }
            throw new IllegalArgumentException(MessageFormat.format("''{0}'' does not exist or is not a valid file", selectedResource.getPath()));
        }
        return schemas;
    }

    @Override
    public String[] getValidExtensions() {
        return new String[]{"*.xsd", "*.*"};
    }

    @Override
    public String[] getValidExtensionsFilterNames() {
        return new String[]{"Schema", "All Files (*.*)"};
    }

    @Override
    public boolean isAllowsMultiple() {
        return false;
    }

    @Override
    public List<URL> getSchemaURLs(List<Resource> selectedResources) throws Exception {
        if (selectedResources != null) {
            ArrayList<URL> urls = new ArrayList<URL>(selectedResources.size());
            for (Resource resource : selectedResources) {
                if (!StringUtils.isNotBlank((String)resource.getPath())) continue;
                urls.add(BaseMetadataDefinitionEditor.resolvePath(this.getMuleProject(), resource).toURI().toURL());
            }
            return urls;
        }
        return Collections.emptyList();
    }

    @Override
    public void setSelectedResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Override
    public void setSelectedRoot(QName rootName) {
        this.rootName = rootName;
    }

    private QName getSelectedRoot() {
        return this.rootName;
    }

    @Override
    public void setMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    @Override
    public Set<File> getResourcesToCopy(File file) {
        Set dependencies = XmlSchemaUtils.getDependencies((File)file);
        dependencies.add(file);
        return dependencies;
    }
}

