/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types.xml;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.ModelFactory;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.mule.xml.schemas.XSDGeneratorUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.xml.XMLModeElement;

public class FromExampleElement
implements XMLModeElement {
    private QName rootName;
    private String resourcePath;
    private IMuleProject muleProject;
    private Map<File, List<String>> exampleToschemas = new HashMap<File, List<String>>();
    private List<Resource> resources = Collections.emptyList();

    @Override
    public String getLabel() {
        return "Example";
    }

    @Override
    public String getMessage() {
        return "Select your XML example file";
    }

    @Override
    public String getFolder() {
        return "examples";
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public MetadataType getMetadata() throws Exception {
        HashMap<Class, Object> annotations = new HashMap<Class, Object>();
        Preconditions.checkArgument((!this.resources.isEmpty() ? 1 : 0) != 0, (Object)"A XML example file path should be selected");
        File exampleFile = this.getSelectedXmlExample();
        String exampleContent = this.getSelectedFileContent(exampleFile);
        Preconditions.checkArgument((!exampleContent.isEmpty() ? 1 : 0) != 0, (Object)"Example should not be empty");
        if (exampleFile != null && this.exampleToschemas.containsKey(exampleFile)) {
            Optional<MetadataType> maybeMetadataType = this.getMetadataTypeFromExample(exampleContent);
            MetadataType metadataType = maybeMetadataType.orElseThrow(() -> new IllegalArgumentException("The provided XML could not be parsed as XML Example"));
            annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_XML));
            annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.EXAMPLE));
            annotations.put(PathAnnotation.class, new PathAnnotation(this.resourcePath));
            annotations.put(ElementAnnotation.class, new ElementAnnotation(this.rootName.toString()));
            return MetadataTypeProxy.proxying((MetadataType)metadataType, annotations);
        }
        return MetadataFactory.undefined();
    }

    private Optional<MetadataType> getMetadataTypeFromExample(String exampleContent) throws Exception {
        ModelFactory modelFactory = ModelFactory.fromExample((String)exampleContent);
        XmlTypeLoader xmlTypeLoader = new XmlTypeLoader(modelFactory);
        return xmlTypeLoader.load(this.rootName, null);
    }

    private File getSelectedXmlExample() {
        return !this.resources.isEmpty() ? BaseMetadataDefinitionEditor.resolvePath(this.getMuleProject(), this.resources.get(0)) : null;
    }

    public List<String> generateSchema(File selectedFile) throws Exception {
        if (selectedFile != null && selectedFile.exists() && selectedFile.canRead()) {
            return XSDGeneratorUtils.generateXSD((File)selectedFile);
        }
        throw new IllegalArgumentException("Selected file " + (selectedFile != null ? selectedFile.getAbsolutePath() : "--null--") + " doesn't exist or is not readable.");
    }

    @Override
    public List<String> getSchemas(List<Resource> selectedResources) throws Exception {
        File selectedXmlExample = this.getSelectedXmlExample();
        if (selectedXmlExample != null && selectedXmlExample.exists() && !selectedXmlExample.isDirectory()) {
            if (!this.exampleToschemas.containsKey(selectedXmlExample)) {
                this.exampleToschemas.put(selectedXmlExample, this.generateSchema(selectedXmlExample));
            }
            return this.exampleToschemas.get(selectedXmlExample);
        }
        return null;
    }

    private String getSelectedFileContent(File selectedFile) {
        if (selectedFile.exists() && selectedFile.canRead()) {
            String result = "";
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream content = new FileInputStream(selectedFile);){
                    result = IOUtils.toString((InputStream)MuleResourceUtils.skipBOM((InputStream)content));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logError((String)"Error generating JSON sample data", (Throwable)e);
            }
            return result;
        }
        return "";
    }

    @Override
    public String[] getValidExtensions() {
        return new String[]{"*.xml", "*.*"};
    }

    @Override
    public String[] getValidExtensionsFilterNames() {
        return new String[]{"XML", "All Files (*.*)"};
    }

    @Override
    public boolean isAllowsMultiple() {
        return false;
    }

    @Override
    public List<URL> getSchemaURLs(List<Resource> selectedResources) throws Exception {
        return null;
    }

    @Override
    public void setSelectedResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Override
    public void setSelectedRoot(QName rootName) {
        this.rootName = rootName;
    }

    public QName getSelectedRoot() {
        return this.rootName;
    }

    @Override
    public void setMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public File resolvePath(File file, IMuleProject muleProject) {
        File resolvedFile;
        if (file.isAbsolute()) {
            resolvedFile = file;
        } else {
            Optional fullPath = CoreUtils.getFileFullPathFromSelectedResource((String)file.getAbsolutePath(), (IMuleProject)muleProject);
            resolvedFile = fullPath.map(s -> new File((String)s)).orElse(file);
        }
        return resolvedFile;
    }

    @Override
    public Set<File> getResourcesToCopy(File file) {
        return Collections.singleton(file);
    }
}

