/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.datasense.SimpleTypeMetadataTypeUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.DynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class SimpleTypeMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    private static final String SIMPLE_METADATA_EDITOR_CSS_CLASS_ID = "org-mule-tooling-ui-modules-core-SimpleTypeMetadataDefinitionEditor";
    private final List<ContentType<MetadataType>> types = new ArrayList<ContentType<MetadataType>>();
    private ComboViewer typeViewer;

    public SimpleTypeMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.initializeTypes();
        this.createControl(this);
        ThemeUtils.setCssClassAndId((Object)this, (String)SIMPLE_METADATA_EDITOR_CSS_CLASS_ID, (String)SIMPLE_METADATA_EDITOR_CSS_CLASS_ID);
    }

    private void initializeTypes() {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA);
        this.types.add((ContentType<MetadataType>)new ContentType("String", "string", (Object)MetadataTypeProxy.proxying((MetadataType)typeBuilder.stringType().build(), new HashMap())));
        this.types.add((ContentType<MetadataType>)new ContentType("Number", "number", (Object)MetadataTypeProxy.proxying((MetadataType)typeBuilder.numberType().build(), new HashMap())));
        this.types.add((ContentType<MetadataType>)new ContentType("Integer", "integer", (Object)MetadataTypeProxy.proxying((MetadataType)typeBuilder.numberType().integer().build(), new HashMap())));
        this.types.add((ContentType<MetadataType>)new ContentType("Boolean", "boolean", (Object)MetadataTypeProxy.proxying((MetadataType)typeBuilder.booleanType().build(), new HashMap())));
        this.types.add((ContentType<MetadataType>)new ContentType("Date", "date-only", (Object)MetadataTypeProxy.proxying((MetadataType)typeBuilder.dateType().build(), new HashMap())));
        this.types.add((ContentType<MetadataType>)new ContentType("DateTime", "datetime", (Object)MetadataTypeProxy.proxying((MetadataType)typeBuilder.dateTimeType().build(), new HashMap())));
    }

    @Override
    protected MetadataType filterMetadataType(MetadataType metadataType) {
        MetadataType temp = metadataType;
        if (temp instanceof ArrayType) {
            temp = ((ArrayType)metadataType).getType();
        }
        if (temp instanceof SimpleType) {
            return metadataType;
        }
        return null;
    }

    @Override
    public MetadataResult calculateMetadata() {
        try {
            StructuredSelection selection = (StructuredSelection)this.typeViewer.getSelection();
            if (!selection.isEmpty()) {
                ContentType selectedMetadataType = (ContentType)selection.getFirstElement();
                return MetadataResult.from(SimpleTypeMetadataTypeUtils.buildSimpleType((String)selectedMetadataType.getId()));
            }
            return MetadataResult.from("Type is not selected");
        }
        catch (Exception e) {
            return MetadataResult.from("Error creating metadata... \n" + e.getLocalizedMessage());
        }
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        Composite keyWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(keyWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)keyWrapper);
        Label typeLabel = new Label(keyWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)typeLabel);
        typeLabel.setText("Type");
        this.typeViewer = new ComboViewer(keyWrapper, 8);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo(this.typeViewer.getControl());
        this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DynamicObject) {
                    return ((ContentType)element).getLabel();
                }
                return super.getText(element);
            }
        });
        this.typeViewer.setInput(this.types);
        this.loadEdited();
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleTypeMetadataDefinitionEditor.this.recordChange();
            }
        });
    }

    private void loadEdited() {
        if (StringUtils.isNotBlank((String)this.getPreviousKey())) {
            MetadataType metadataFromCache = this.getMetadataTypeFromCache(this.getPreviousKey());
            if (metadataFromCache != null) {
                ContentType<MetadataType> contentType = this.getTypeFromDataType(metadataFromCache);
                this.typeViewer.setSelection((ISelection)new StructuredSelection(contentType));
            } else {
                this.selectDefaultType();
            }
        } else {
            this.selectDefaultType();
        }
    }

    private void selectDefaultType() {
        this.typeViewer.setSelection((ISelection)new StructuredSelection(this.types.get(0)));
    }

    private ContentType<MetadataType> getTypeFromDataType(MetadataType metadataType) {
        for (ContentType<MetadataType> contentType : this.types) {
            if (!((MetadataType)contentType.getModel()).equals(metadataType)) continue;
            return contentType;
        }
        return this.types.get(0);
    }

    @Override
    public void doValidate() {
        if (StringUtils.isBlank((String)this.getKey())) {
            this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
        } else {
            boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
            if (!validKey) {
                this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
            } else {
                MetadataResult metadataResult = this.getMetadata();
                if (!metadataResult.isValid()) {
                    this.getOnValidationMessage().setValidationMessage(metadataResult.getMessage());
                } else {
                    this.getOnValidationMessage().clear();
                }
            }
        }
    }
}

