/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;

public class Resource {
    private final String path;
    private final Optional<String> pathInClasspath;
    private final Optional<File> file;
    private final List<IPath> allowedPaths;
    private final IFile iFile;

    public Resource(String path, IFile iFile, Optional<String> pathInClasspath, Optional<File> file, List<IPath> allowedPaths) {
        this.path = path;
        this.iFile = iFile;
        this.pathInClasspath = pathInClasspath;
        this.file = file;
        this.allowedPaths = allowedPaths;
    }

    public String getFileName() {
        return this.getFile().getName();
    }

    public File getFile() {
        return this.file.orElseGet(() -> new File(this.path));
    }

    public static Optional<String> getResourcesToCopyMessage(List<Resource> resources) {
        String message = Resource.getResourcesToCopyStream(resources).map(example -> example.getFileName()).collect(Collectors.joining(", "));
        return Optional.ofNullable(message.isEmpty() ? null : message);
    }

    public static Stream<Resource> getResourcesToCopyStream(List<Resource> resources) {
        return resources.stream().filter(example -> !example.isInValidResourcesFolder());
    }

    public static Optional<Resource> create(String path, IMuleProject muleProject) {
        File file = CoreUtils.pathToFile((String)path, (IMuleProject)muleProject, (boolean)false);
        return Optional.ofNullable(file).map(f -> Resource.create(path, f, muleProject));
    }

    public static Resource create(String path, File file, IMuleProject muleProject) {
        return new Resource(path, CoreUtils.getResourceFromFile((File)file), CoreUtils.toClasspathResource((File)file, (IMuleProject)muleProject), Optional.ofNullable(file), Arrays.asList(IMuleResources.MULE_RESOURCES_FOLDER_PATH));
    }

    public String getPath() {
        return this.path;
    }

    public Optional<String> getPathInClasspath() {
        return this.pathInClasspath;
    }

    public boolean isInValidResourcesFolder() {
        if (this.pathInClasspath.isPresent()) {
            IPath projectRelativePath = this.iFile.getProjectRelativePath();
            return this.allowedPaths.stream().anyMatch(allowedPath -> allowedPath.isPrefixOf(projectRelativePath));
        }
        return false;
    }

    public void copyTo(IFolder folder) {
        if (!this.pathInClasspath.isPresent()) {
            File sourceFile = this.getFile();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream is = new FileInputStream(sourceFile);){
                    String uniqueName = MuleResourceUtils.getUniqueFileName((File)folder.getRawLocation().toFile(), (String)sourceFile.getName());
                    MuleResourceUtils.createFile((IFolder)folder, (String)uniqueName, (InputStream)is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                MuleCorePlugin.logError((String)"Error copying resources", (Throwable)e);
            }
        }
    }
}

