/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.mule.alsp.SupportedContentTypes;
import org.mule.alsp.editor.EmbeddedApiEditor;
import org.mule.alsp.validation.RAMLValidationUtils;
import org.mule.alsp.validation.ValidationResult;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.MuleClassLoaderUtils;
import org.mule.tooling.core.classloader.ProjectClassPath;
import org.mule.tooling.core.classloader.ProjectClassPathProvider;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.types.utils.MapObjectTypeLoader;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ObjectMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    private static final String OBJECT_TEMPLATE = "/raml/new_object_schema.template";
    private static final String ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.error";
    private static final String OBJECT = "Java object";
    private static final String UNKNOWN = "Click here to select an option";
    private static final String DATA_STRUCTURE_COLUMN = "Data structure";
    private static final String LABEL_CLASS = "Class";
    private static final String LABEL_RAML_DEFINITION = "RAML Definition";
    private StyledText ramlStyledText;
    private Optional<MetadataType> editedModel;
    private IDocument document;
    private AnnotationModel annotationModel;
    private SchemaWrapper schema;
    private TreeViewer schemaViewer;
    private TreeViewer detailsTree;
    private ComboViewer comboViewer;
    private EmbeddedApiEditor apiEditor;

    public ObjectMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.createControl(this);
    }

    @Override
    public MetadataResult calculateMetadata() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
            String selected = (String)selection.getFirstElement();
            return LABEL_CLASS.equals(selected) ? this.calculateMetadataFromSchema() : this.calculateMetadataFromScript();
        }
        catch (Exception e) {
            return MetadataResult.from("Error creating metadata... \n" + e.getLocalizedMessage());
        }
    }

    public MetadataResult calculateMetadataFromSchema() {
        Optional<ClassLoader> maybeClassloader;
        SchemaObject rootElement = this.schema.getRootElement();
        if (rootElement instanceof TypedObjectRef && (maybeClassloader = this.getClassloader()).isPresent()) {
            JavaTypeLoader loader = new JavaTypeLoader(maybeClassloader.get());
            String clazz = ((TypedObjectRef)rootElement).getType();
            if (clazz != null) {
                HashMap<Class<ElementAnnotation>, Object> annotations = new HashMap<Class<ElementAnnotation>, Object>();
                Optional maybeMetadataType = loader.load(clazz);
                annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_JAVA));
                annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
                annotations.put(ElementAnnotation.class, new ElementAnnotation(clazz));
                return MetadataResult.from(MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormat.JAVA)), annotations));
            }
        }
        return MetadataResult.from("Invalid metadata configuration");
    }

    public MetadataResult calculateMetadataFromScript() {
        HashMap<Class<ContentAnnotation>, Object> annotations = new HashMap<Class<ContentAnnotation>, Object>();
        String ramlType = this.getRamlType();
        Objects.requireNonNull(ramlType);
        Preconditions.checkArgument((!ramlType.isEmpty() ? 1 : 0) != 0, (Object)"RAML type definition should not be empty");
        MapObjectTypeLoader loader = new MapObjectTypeLoader(ramlType);
        Optional maybeMetadataType = loader.load(null);
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_JAVA));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.RAML));
        annotations.put(ContentAnnotation.class, new ContentAnnotation(ramlType));
        return MetadataResult.from(MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormat.JAVA)), annotations));
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        this.comboViewer = new ComboViewer(parent, 8);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo(this.comboViewer.getControl());
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboViewer.setInput((Object)new String[]{LABEL_CLASS, LABEL_RAML_DEFINITION});
        Composite wrapper = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        StackLayout layout = new StackLayout();
        wrapper.setLayout((Layout)layout);
        this.editedModel = Optional.ofNullable(this.getMetadataTypeFromCache(this.getPreviousKey()));
        Composite exampleComposite = this.buildExampleTab(wrapper);
        Composite definitionComposite = this.buildDefinitionTab(wrapper);
        layout.topControl = exampleComposite;
        wrapper.layout();
        Object selectedElement = this.comboViewer.getElementAt(this.editedModel.isPresent() && this.editedModel.get().getAnnotation(ElementAnnotation.class).isPresent() || !this.editedModel.isPresent() ? 0 : 1);
        this.comboViewer.setSelection((ISelection)new StructuredSelection(selectedElement));
        layout.topControl = LABEL_CLASS.equals(selectedElement) ? exampleComposite : definitionComposite;
        this.comboViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() > 0) {
                String selected = (String)selection.getFirstElement();
                stackLayout.topControl = LABEL_CLASS.equals(selected) ? exampleComposite : definitionComposite;
                wrapper.layout();
                this.refresh();
            }
        });
    }

    private Composite buildExampleTab(Composite parent) {
        Optional maybeTypeIdAnnotation;
        MetadataType previousMetadataType;
        Composite exampleComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(exampleComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)exampleComposite);
        Composite schemaWrapper = new Composite(exampleComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(4, 100).applyTo((Control)schemaWrapper);
        this.schema = new SchemaWrapper();
        TypedObject valueContainer = new TypedObject();
        if (this.editedModel.isPresent() && (previousMetadataType = this.editedModel.get()) instanceof ObjectType && (maybeTypeIdAnnotation = previousMetadataType.getAnnotation(TypeIdAnnotation.class)).isPresent()) {
            valueContainer.setType(((TypeIdAnnotation)maybeTypeIdAnnotation.get()).getValue());
        }
        this.schema.setRootElement(new TypedObjectRef(null, valueContainer));
        this.schemaViewer = new TreeViewer(schemaWrapper, 101122);
        this.schemaViewer.setContentProvider((IContentProvider)new BeanSchemaContentProvider());
        Tree tree = this.schemaViewer.getTree();
        tree.setHeaderVisible(true);
        TreeViewerColumn schemaColumn = new TreeViewerColumn(this.schemaViewer, 16384);
        schemaColumn.setEditingSupport((EditingSupport)new SchemaEditingSupport((ColumnViewer)this.schemaViewer));
        schemaColumn.setLabelProvider((CellLabelProvider)new SchemaColumnLabelProvider());
        schemaColumn.getColumn().setText(DATA_STRUCTURE_COLUMN);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        columnLayout.setColumnData((Widget)schemaColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 150, true));
        schemaWrapper.setLayout((Layout)columnLayout);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.schemaViewer, (int)2);
        this.schemaViewer.setInput((Object)this.schema);
        this.schemaViewer.expandAll();
        this.schemaViewer.addSelectionChangedListener(event -> this.refresh());
        this.detailsTree = this.createDetailsTree(exampleComposite, this.editedModel);
        return exampleComposite;
    }

    private Composite buildDefinitionTab(Composite parent) {
        Composite wrapper = parent;
        try {
            this.apiEditor = new EmbeddedApiEditor(SupportedContentTypes.RAML, ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme);
            wrapper = this.apiEditor.createApiEditor(parent);
            this.document = this.apiEditor.getDocument();
            this.annotationModel = (AnnotationModel)this.apiEditor.getAnnotationModel();
            this.ramlStyledText = this.apiEditor.getStyledText();
            this.buildDocument(this.editedModel, this.document);
            this.createUIListeners(wrapper);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error creating API Editor", (Throwable)e);
        }
        return wrapper;
    }

    public void dispose() {
        if (this.apiEditor != null) {
            this.apiEditor.dispose();
            this.apiEditor = null;
        }
        super.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IDocument buildDocument(Optional<MetadataType> maybeMetadataType, IDocument metadataDocument) {
        if (maybeMetadataType.isPresent()) {
            MetadataType metadataType = maybeMetadataType.get();
            Optional maybeContentAnnotation = metadataType.getAnnotation(ContentAnnotation.class);
            if (maybeContentAnnotation.isPresent()) {
                metadataDocument.set(((ContentAnnotation)maybeContentAnnotation.get()).getContent());
                return metadataDocument;
            }
            InputStream template = ObjectMetadataDefinitionEditor.class.getResourceAsStream(OBJECT_TEMPLATE);
            Throwable throwable = null;
            Object var7_14 = null;
            try (Scanner scanner = new Scanner(template);){
                metadataDocument.set(scanner.useDelimiter("\\A").next());
                return metadataDocument;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        InputStream template = ObjectMetadataDefinitionEditor.class.getResourceAsStream(OBJECT_TEMPLATE);
        Throwable throwable = null;
        Object var5_9 = null;
        try (Scanner scanner = new Scanner(template);){
            metadataDocument.set(scanner.useDelimiter("\\A").next());
            return metadataDocument;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void refreshDetailsTree() {
        this.editedModel = Optional.ofNullable(this.calculateMetadata().getMetadataType());
        this.detailsTree.setInput(this.getRoot(this.editedModel));
        this.detailsTree.expandToLevel(4);
    }

    private void createUIListeners(Composite wrapper) {
        this.ramlStyledText.addModifyListener((ModifyListener)new IdleModifyEventListener(400L, e -> this.refresh(), (Control)wrapper));
    }

    private void refresh() {
        this.refreshDetailsTree();
        this.validate();
        this.recordChange();
    }

    @Override
    public void onRefresh() {
        this.refreshDetailsTree();
        this.recordChange();
    }

    private boolean validateRAMLScript(String ramlType) {
        this.annotationModel.removeAllAnnotations();
        List validationResults = RAMLValidationUtils.validateRAML10DataType((String)ramlType);
        for (ValidationResult errorInfo : validationResults) {
            Annotation annotation = new Annotation(ANNOTATION_TYPE, false, errorInfo.getMessage());
            try {
                int initialOffset = this.document.getLineOffset(errorInfo.getStartLine()) + errorInfo.getStartColumn();
                int finalOffset = this.document.getLineOffset(errorInfo.getEndLine()) + errorInfo.getEndColumn();
                this.annotationModel.addAnnotation(annotation, new Position(initialOffset, finalOffset - initialOffset));
            }
            catch (BadLocationException e) {
                MuleCorePlugin.logError((String)"Error parsing RAML script", (Throwable)e);
                this.annotationModel.addAnnotation(annotation, new Position(0));
            }
        }
        return validationResults.isEmpty();
    }

    private String getRamlType() {
        return this.ramlStyledText.getText();
    }

    private String getCellText(Object node) {
        if (node instanceof TypedObjectRef) {
            TypedObject typedObject = ((TypedObjectRef)node).getTypedObject();
            if (typedObject == null || StringUtils.isEmpty((String)typedObject.getType())) {
                return UNKNOWN;
            }
            return typedObject.getType();
        }
        return UNKNOWN;
    }

    @Override
    protected MetadataType filterMetadataType(MetadataType metadataType) {
        MetadataType temp = metadataType;
        if (temp instanceof ArrayType) {
            temp = ((ArrayType)metadataType).getType();
        }
        if (temp instanceof ObjectType && MetadataFormat.JAVA.equals((Object)temp.getMetadataFormat())) {
            return metadataType;
        }
        return null;
    }

    @Override
    protected void doValidate() {
        if (StringUtils.isNotBlank((String)this.getKey())) {
            boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
            if (!validKey) {
                this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
            } else {
                String ramlType = this.getRamlType();
                if (StringUtils.isBlank((String)ramlType)) {
                    this.getOnValidationMessage().setValidationMessage("The type cannot be blank");
                } else if (this.validateRAMLScript(ramlType)) {
                    MetadataResult result = this.getMetadata();
                    if (result.isValid()) {
                        this.getOnValidationMessage().clear();
                    } else {
                        this.getOnValidationMessage().setValidationMessage(result.getMessage());
                    }
                } else {
                    this.getOnValidationMessage().setValidationMessage("There are errors in the script");
                }
            }
        }
    }

    private Optional<ClassLoader> getClassloader() {
        try {
            ProjectClassPath classPath = new ProjectClassPathProvider().getClassPath(this.getMuleProject());
            return Optional.ofNullable(MuleClassLoaderUtils.createMuleClassLoader((URL[])classPath.getUrls(), (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        catch (MalformedURLException | JavaModelException e) {
            MuleCorePlugin.logError((String)"Error getting classloader", (Throwable)e);
            return Optional.empty();
        }
    }

    private static class BeanSchemaContentProvider
    implements ITreeContentProvider {
        private BeanSchemaContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object arg1, Object arg2) {
        }

        public Object[] getChildren(Object node) {
            if (node instanceof SchemaObject) {
                return ((SchemaObject)node).getChildren();
            }
            return new Object[0];
        }

        public Object[] getElements(Object input) {
            if (input instanceof SchemaWrapper) {
                return new SchemaObject[]{((SchemaWrapper)input).getRootElement()};
            }
            return new Object[0];
        }

        public Object getParent(Object node) {
            if (node instanceof SchemaObject) {
                return ((SchemaObject)node).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object node) {
            if (node instanceof SchemaObject) {
                return ((SchemaObject)node).hasChildren();
            }
            return false;
        }
    }

    private class SchemaColumnLabelProvider
    extends ColumnLabelProvider {
        private SchemaColumnLabelProvider() {
        }

        public String getText(Object node) {
            return ObjectMetadataDefinitionEditor.this.getCellText(node);
        }
    }

    private class SchemaEditingSupport
    extends EditingSupport {
        public SchemaEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object arg0) {
            return true;
        }

        protected CellEditor getCellEditor(final Object node) {
            ComboBoxCellEditor editor = new ComboBoxCellEditor(){

                protected Control createControl(Composite parent) {
                    final CCombo toReturn = (CCombo)super.createControl(parent);
                    toReturn.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            SchemaEditingSupport.this.setValueInternal(node, toReturn.getText());
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                    this.setActivationStyle(1);
                    return toReturn;
                }

                protected Object doGetValue() {
                    return this.getCombo().getText();
                }

                protected void doSetValue(Object value) {
                    if (value != null) {
                        this.getCombo().setText((String)value);
                    } else {
                        this.getCombo().setText("");
                    }
                }

                protected CCombo getCombo() {
                    return (CCombo)this.getControl();
                }

                public int getStyle() {
                    return 8;
                }
            };
            editor.setItems(new String[]{ObjectMetadataDefinitionEditor.UNKNOWN, ObjectMetadataDefinitionEditor.OBJECT});
            editor.create((Composite)this.getViewer().getControl());
            return editor;
        }

        protected void setValue(Object element, Object value) {
        }

        private void setValueInternal(Object node, Object value) {
            TypedObject valueContainer;
            String typedValue;
            ObjectMetadataDefinitionEditor.this.recordChange();
            SchemaObject schema = (SchemaObject)node;
            String actualValue = typedValue = (String)value;
            if (schema instanceof TypedObjectRef) {
                TypedObjectRef typedObjectRef = (TypedObjectRef)schema;
                valueContainer = new TypedObject();
                typedObjectRef.setTypedObject(valueContainer);
            } else {
                valueContainer = new TypedObject();
                TypedObjectRef newNode = new TypedObjectRef(schema.getParent(), valueContainer);
                this.setNewValue(schema, newNode);
            }
            if (ObjectMetadataDefinitionEditor.OBJECT.equals(typedValue)) {
                actualValue = null;
                try {
                    Object[] types;
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ObjectMetadataDefinitionEditor.this.schemaViewer.getControl().getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)6, (boolean)false);
                    if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0) {
                        IType type = (IType)types[0];
                        actualValue = type.getFullyQualifiedName();
                    }
                }
                catch (JavaModelException e) {
                    MessageDialog.openError((Shell)ObjectMetadataDefinitionEditor.this.schemaViewer.getControl().getShell(), (String)"Unexpected Error", (String)("Failed to open type selection dialog.\n\n" + String.valueOf((Object)e)));
                }
            } else if (ObjectMetadataDefinitionEditor.UNKNOWN.equals(typedValue) || typedValue.isEmpty()) {
                actualValue = null;
            }
            valueContainer.setType(actualValue);
            this.schemaChanged();
        }

        protected Object getValue(Object node) {
            return ObjectMetadataDefinitionEditor.this.getCellText(node);
        }

        private void setNewValue(SchemaObject oldValue, SchemaObject newValue) {
            SchemaObject parent = oldValue.getParent();
            if (parent == null) {
                ObjectMetadataDefinitionEditor.this.schema.setRootElement(newValue);
            }
        }

        private void schemaChanged() {
            ObjectMetadataDefinitionEditor.this.schemaViewer.refresh();
            ObjectMetadataDefinitionEditor.this.schemaViewer.expandAll();
            ObjectMetadataDefinitionEditor.this.refresh();
        }
    }

    private static class SchemaObject {
        private SchemaObject parent;

        public SchemaObject() {
        }

        public SchemaObject(SchemaObject parent) {
            this.parent = parent;
        }

        public SchemaObject[] getChildren() {
            return new SchemaObject[0];
        }

        public SchemaObject getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return false;
        }
    }

    private static class SchemaWrapper {
        private SchemaObject rootElement;

        private SchemaWrapper() {
        }

        public SchemaObject getRootElement() {
            return this.rootElement;
        }

        public void setRootElement(SchemaObject rootElement) {
            this.rootElement = rootElement;
        }
    }

    private static class TypedObject
    extends SchemaObject {
        private String type;

        public String getType() {
            return this.type;
        }

        public void setType(String actualValue) {
            this.type = actualValue;
        }
    }

    private static class TypedObjectRef
    extends SchemaObject {
        private TypedObject valueContainer;

        public TypedObjectRef(SchemaObject parent, TypedObject valueContainer) {
            super(parent);
            this.valueContainer = valueContainer;
        }

        public void setTypedObject(TypedObject valueContainer) {
            this.valueContainer = valueContainer;
        }

        public TypedObject getTypedObject() {
            return this.valueContainer;
        }

        public String getType() {
            return this.valueContainer.getType();
        }
    }
}

