/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.metadata.MetadataTypeGraphicalChildrenProvider;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.types.utils.DataWeaveMetadataTypeWriter;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.mule.json.schemas.JsonSchemaUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.ModeElement;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;

public class JSONMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    private static final String INVALID_JSON_DEPENDENCY_MESSAGE = "''{0}'' already exists, it is being used in the current schema as dependency";
    private final FromSchemaElement fromSchemaElement = new FromSchemaElement();
    private final FromExampleElement fromExampleElement = new FromExampleElement();
    private final JSONModeElement[] modes = new JSONModeElement[]{this.fromSchemaElement, this.fromExampleElement};
    private Text filePath;
    private TreeViewer detailsTree;
    private ComboViewer modeComboViewer;
    private Optional<MetadataType> editedModel;
    private Label messageLabel;
    private List<Resource> resources = Collections.emptyList();

    public JSONMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.createControl(this);
    }

    @Override
    public MetadataResult calculateMetadata() {
        try {
            return MetadataResult.from(this.getSelectedMode().getMetadata());
        }
        catch (Exception e) {
            return MetadataResult.from("Error creating metadata... \n" + e.getLocalizedMessage());
        }
    }

    @Override
    public void onRefresh() {
        this.refresh();
    }

    @Override
    public void doValidate() {
        if (StringUtils.isNotBlank((String)this.getKey())) {
            boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
            if (!validKey) {
                this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
            } else {
                String schemaPath = this.getSchemaPath();
                if (StringUtils.isNotBlank((String)schemaPath) && this.isExistingFile(schemaPath)) {
                    MetadataResult result = this.getMetadata();
                    if (result.isValid()) {
                        this.getOnValidationMessage().clear();
                    } else {
                        this.getOnValidationMessage().setValidationMessage(result.getMessage());
                    }
                } else {
                    String errorMessage = this.validateDependencies();
                    if (StringUtils.isNotEmpty((String)errorMessage)) {
                        this.getOnValidationMessage().setValidationMessage(errorMessage);
                    } else if (this.editedModel.isPresent()) {
                        this.getOnValidationMessage().clear();
                    } else {
                        this.getOnValidationMessage().setValidationMessage(MessageFormat.format("The selected {0} file does not exist", this.getSelectedMode().getLabel().toLowerCase()));
                    }
                }
            }
        }
    }

    private String validateDependencies() {
        IFolder resourceFolder = this.getResourceFolder(this.getSelectedMode().getFolder());
        return Resource.getResourcesToCopyStream(this.resources).map(resource -> {
            if (StringUtils.isNotBlank((String)resource.getPath())) {
                File sourceFile = resource.getFile();
                Set<File> resourcesToCopy = this.getSelectedMode().getResourcesToCopy(sourceFile);
                Path rootPath = Paths.get(sourceFile.getParentFile().toURI());
                for (File currentResource : resourcesToCopy) {
                    Path currentPath = Paths.get(currentResource.getParentFile().toURI());
                    Path relativizePath = rootPath.relativize(currentPath);
                    try {
                        Throwable throwable = null;
                        Object var11_13 = null;
                        try (FileInputStream content = new FileInputStream(currentResource);){
                            IFile file;
                            IFolder currentFolder = resourceFolder.getFolder(relativizePath.toString());
                            String uniqueName = currentResource.getName();
                            if (sourceFile.equals(currentResource)) {
                                uniqueName = MuleResourceUtils.getUniqueFileName((File)currentFolder.getRawLocation().toFile(), (String)uniqueName);
                            }
                            if (!(file = currentFolder.getFile(uniqueName)).exists()) continue;
                            return MessageFormat.format(INVALID_JSON_DEPENDENCY_MESSAGE, uniqueName);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        MuleCorePlugin.logError((String)"Error validating xsd dependencies", (Throwable)e);
                    }
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    protected MetadataType filterMetadataType(MetadataType metadataType) {
        MetadataType temp = metadataType;
        if (temp instanceof ArrayType) {
            temp = ((ArrayType)metadataType).getType();
        }
        if (temp instanceof ObjectType && MetadataFormat.JSON.equals((Object)temp.getMetadataFormat())) {
            return metadataType;
        }
        return null;
    }

    @Override
    protected MetadataTypeGraphicalChildrenProvider createMetaDataModelGraphicalChildrenProvider() {
        return new MetadataTypeGraphicalChildrenProvider();
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        Button openSchemaButton = this.createResourceSelector(wrapper);
        this.messageLabel = this.createMessageLabel(wrapper);
        this.editedModel = Optional.ofNullable(this.getMetadataTypeFromCache(this.getPreviousKey()));
        this.detailsTree = this.createDetailsTree(parent, this.editedModel);
        this.loadMode(this.editedModel);
        this.createUIListeners(wrapper, openSchemaButton);
    }

    private Button createResourceSelector(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        this.createModeViewer(wrapper);
        this.filePath = new Text(wrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filePath);
        this.filePath.setMessage("Select your JSON schema file");
        Button openSchemaButton = new Button(wrapper, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)openSchemaButton);
        openSchemaButton.setText("...");
        return openSchemaButton;
    }

    private void loadMode(Optional<MetadataType> maybeMetadataType) {
        if (maybeMetadataType.isPresent()) {
            MetadataType metadataType = maybeMetadataType.get();
            Optional maybeOriginAnnotation = metadataType.getAnnotation(OriginAnnotation.class);
            Optional maybePathAnnotation = metadataType.getAnnotation(PathAnnotation.class);
            Optional maybeExamplePathAnnotation = metadataType.getAnnotation(ExamplePathAnnotation.class);
            OriginAnnotation originAnnotation = (OriginAnnotation)maybeOriginAnnotation.orElseThrow(() -> new RuntimeException("Invalid origin"));
            boolean isExample = originAnnotation.getOrigin().equals((Object)MetadataTypeOrigin.EXAMPLE) || originAnnotation.getOrigin().equals((Object)MetadataTypeOrigin.WEAVE);
            this.modeComboViewer.setSelection((ISelection)new StructuredSelection((Object)(isExample ? this.fromExampleElement : this.fromSchemaElement)));
            if (maybePathAnnotation.isPresent() || maybeExamplePathAnnotation.isPresent()) {
                String resourcePath = maybePathAnnotation.map(PathAnnotation::getPath).orElseGet(() -> ((ExamplePathAnnotation)maybeExamplePathAnnotation.get()).getPath());
                this.filePath.setText(resourcePath);
                this.resources = Resource.create(resourcePath, this.getMuleProject()).map(r -> Collections.singletonList(r)).orElse(Collections.emptyList());
            }
        }
    }

    private void createUIListeners(final Composite wrapper, Button openSchemaButton) {
        this.filePath.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String resourcePath = JSONMetadataDefinitionEditor.this.filePath.getText();
                JSONMetadataDefinitionEditor.this.resources = Resource.create(resourcePath, JSONMetadataDefinitionEditor.this.getMuleProject()).map(r -> Collections.singletonList(r)).orElse(Collections.emptyList());
                JSONMetadataDefinitionEditor.this.checkFilesToCopy(JSONMetadataDefinitionEditor.this.getSelectedMode());
                JSONMetadataDefinitionEditor.this.refresh();
            }
        }, (Control)wrapper));
        this.modeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSONModeElement mode = JSONMetadataDefinitionEditor.this.getSelectedMode();
                JSONMetadataDefinitionEditor.this.filePath.setText("");
                JSONMetadataDefinitionEditor.this.filePath.setMessage(mode.getMessage());
                JSONMetadataDefinitionEditor.this.messageLabel.setText("");
                JSONMetadataDefinitionEditor.this.resources = Collections.emptyList();
                JSONMetadataDefinitionEditor.this.refresh();
            }
        });
        openSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<String> result = JSONMetadataDefinitionEditor.this.filePickerButtonPressed(false, new String[]{"JSON " + JSONMetadataDefinitionEditor.this.getSelectedMode().getLabel(), "All Files (*.*)"}, new String[]{"*.json", "*.*"}, wrapper.getShell());
                if (!result.isEmpty()) {
                    JSONModeElement mode = JSONMetadataDefinitionEditor.this.getSelectedMode();
                    JSONMetadataDefinitionEditor.this.messageLabel.setText("");
                    JSONMetadataDefinitionEditor.this.resources = result.stream().map(f -> Resource.create(f, JSONMetadataDefinitionEditor.this.getMuleProject())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                    JSONMetadataDefinitionEditor.this.checkFilesToCopy(mode);
                    JSONMetadataDefinitionEditor.this.filePath.setText(JSONMetadataDefinitionEditor.this.getFileTextFromSelectedResources(JSONMetadataDefinitionEditor.this.resources, mode.getFolder()));
                }
            }
        });
    }

    private void refresh() {
        this.refreshDetailsTree();
        this.validate();
        this.recordChange();
    }

    private void refreshDetailsTree() {
        this.editedModel = Optional.ofNullable(this.calculateMetadata().getMetadataType());
        this.detailsTree.setInput(this.getRoot(this.editedModel));
        this.detailsTree.expandToLevel(4);
    }

    private void createModeViewer(Composite wrapper) {
        this.modeComboViewer = new ComboViewer(wrapper);
        GridDataFactory.swtDefaults().applyTo(this.modeComboViewer.getControl());
        this.modeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                JSONModeElement mode = (JSONModeElement)element;
                return mode.getLabel();
            }
        });
        this.fillModeCombo();
    }

    private JSONModeElement getSelectedMode() {
        StructuredSelection selection = (StructuredSelection)this.modeComboViewer.getSelection();
        return (JSONModeElement)selection.getFirstElement();
    }

    private void fillModeCombo() {
        this.modeComboViewer.setInput((Object)this.modes);
        this.modeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.modes[0]));
    }

    private boolean isExistingFile(String schemaPath) {
        File resolvedFile;
        File file = resolvedFile = !this.resources.isEmpty() ? JSONMetadataDefinitionEditor.resolvePath(this.getMuleProject(), this.resources.get(0)) : null;
        return resolvedFile != null && resolvedFile.exists() && !resolvedFile.isDirectory();
    }

    private String getSchemaPath() {
        return this.resources.isEmpty() ? "" : this.resources.get(0).getPath();
    }

    private void checkFilesToCopy(ModeElement mode) {
        Resource.getResourcesToCopyMessage(this.resources).ifPresent(message -> this.messageLabel.setText(message + " will be copied to src/main/resources/" + mode.getFolder()));
    }

    @Override
    public void applyChanges() {
        IFolder resourceFolder = this.getResourceFolder(this.getSelectedMode().getFolder());
        Resource.getResourcesToCopyStream(this.resources).forEach(resource -> {
            File sourceFile = resource.getFile();
            Set<File> resourcesToCopy = this.getSelectedMode().getResourcesToCopy(sourceFile);
            Path rootPath = Paths.get(sourceFile.getParentFile().toURI());
            for (File currentResource : resourcesToCopy) {
                Path currentPath = Paths.get(currentResource.getParentFile().toURI());
                Path relativizePath = rootPath.relativize(currentPath);
                try {
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (FileInputStream content = new FileInputStream(currentResource);){
                        IFolder currentFolder = resourceFolder.getFolder(relativizePath.toString());
                        MuleResourceUtils.create((IResource)currentFolder);
                        String uniqueName = MuleResourceUtils.getUniqueFileName((File)currentFolder.getRawLocation().toFile(), (String)currentResource.getName());
                        MuleResourceUtils.createFile((IFolder)currentFolder, (String)uniqueName, (InputStream)content);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException e) {
                    MuleCorePlugin.logError((String)"Error copying resources", (Throwable)e);
                }
            }
        });
    }

    private final class FromExampleElement
    implements JSONModeElement {
        private static final String FROM_EXAMPLE_LABEL = "Example";
        private static final String FROM_EXAMPLE_MESSAGE = "Select your JSON example file";

        private FromExampleElement() {
        }

        @Override
        public String getLabel() {
            return FROM_EXAMPLE_LABEL;
        }

        @Override
        public String getMessage() {
            return FROM_EXAMPLE_MESSAGE;
        }

        @Override
        public String getFolder() {
            return "examples";
        }

        @Override
        public MetadataType getMetadata() throws FileNotFoundException, IOException {
            HashMap<Class, Object> annotations = new HashMap<Class, Object>();
            String examplePath = JSONMetadataDefinitionEditor.this.getSchemaPath();
            Objects.requireNonNull(examplePath);
            Preconditions.checkArgument((!examplePath.isEmpty() ? 1 : 0) != 0, (Object)"A JSON example should be selected");
            String exampleAbsolutePath = JSONMetadataDefinitionEditor.resolvePath(JSONMetadataDefinitionEditor.this.getMuleProject(), JSONMetadataDefinitionEditor.this.resources.get(0)).getAbsolutePath();
            MetadataType metadataType = MetadataUtils.createMetadataFromJsonExample((String)exampleAbsolutePath);
            annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_JSON));
            annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.WEAVE));
            annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(JSONMetadataDefinitionEditor.this.getResourcePath(JSONMetadataDefinitionEditor.this.resources.get(0), this.getFolder())));
            DataWeaveMetadataTypeWriter typeWriter = new DataWeaveMetadataTypeWriter(JSONMetadataDefinitionEditor.this.getKey());
            annotations.put(ContentAnnotation.class, new ContentAnnotation(typeWriter.toString(metadataType)));
            return MetadataTypeProxy.proxying((MetadataType)metadataType, annotations);
        }

        @Override
        public Set<File> getResourcesToCopy(File file) {
            return Collections.singleton(file);
        }
    }

    private final class FromSchemaElement
    implements JSONModeElement {
        private static final String FROM_SCHEMA_LABEL = "Schema";
        private static final String FROM_SCHEMA_MESSAGE = "Select your JSON schema file";

        private FromSchemaElement() {
        }

        @Override
        public String getLabel() {
            return FROM_SCHEMA_LABEL;
        }

        @Override
        public String getMessage() {
            return FROM_SCHEMA_MESSAGE;
        }

        @Override
        public String getFolder() {
            return "schemas";
        }

        @Override
        public MetadataType getMetadata() throws FileNotFoundException, IOException {
            HashMap<Class<PathAnnotation>, Object> annotations = new HashMap<Class<PathAnnotation>, Object>();
            String schemaPath = JSONMetadataDefinitionEditor.this.getSchemaPath();
            Objects.requireNonNull(schemaPath);
            Preconditions.checkArgument((!schemaPath.isEmpty() ? 1 : 0) != 0, (Object)"A JSON schema should be selected");
            String schemaAbsolutePath = JSONMetadataDefinitionEditor.resolvePath(JSONMetadataDefinitionEditor.this.getMuleProject(), JSONMetadataDefinitionEditor.this.resources.get(0)).getAbsolutePath();
            String schemaContent = MetadataUtils.getSelectedFileContent((String)schemaAbsolutePath);
            Preconditions.checkArgument((!schemaContent.isEmpty() ? 1 : 0) != 0, (Object)"Schema should not be empty");
            JsonTypeLoader loader = new JsonTypeLoader(new File(schemaAbsolutePath));
            Optional maybeMetadataType = loader.load(null);
            MetadataType metadataType = (MetadataType)maybeMetadataType.orElseThrow(() -> new IllegalArgumentException("The provided JSON could not be parsed as JSON Schema"));
            if (metadataType instanceof AnyType) {
                throw new IllegalArgumentException("The provided JSON could not be parsed as JSON Schema");
            }
            annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_JSON));
            annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
            annotations.put(PathAnnotation.class, new PathAnnotation(JSONMetadataDefinitionEditor.this.getResourcePath(JSONMetadataDefinitionEditor.this.resources.get(0), this.getFolder())));
            return MetadataTypeProxy.proxying((MetadataType)metadataType, annotations);
        }

        @Override
        public Set<File> getResourcesToCopy(File file) {
            Set dependencies = JsonSchemaUtils.getDependencies((File)file);
            dependencies.add(file);
            return dependencies;
        }
    }

    private static interface JSONModeElement
    extends ModeElement {
        public Set<File> getResourcesToCopy(File var1);
    }
}

