/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.types.utils.DataWeaveMetadataTypeWriter;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.ExcelEditorPresenter;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.ExcelTypesManager;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditor;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditor;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ExcelMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    private Map<String, ExcelEditorPresenter> sheets = new LinkedHashMap<String, ExcelEditorPresenter>();

    public ExcelMetadataDefinitionEditor(Composite parent, IMuleProject muleProject, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, muleProject, editorValidator, changeManager, key, onValidationMessage);
        this.createControl(this);
    }

    @Override
    protected MetadataResult calculateMetadata() {
        HashMap<Class<ContentAnnotation>, Object> annotations = new HashMap<Class<ContentAnnotation>, Object>();
        ObjectTypeBuilder excelBuilder = MetadataFactory.newBuilder((MetadataFormat)MetadataFormats.EXCEL).objectType();
        for (Map.Entry<String, ExcelEditorPresenter> entry : this.sheets.entrySet()) {
            String sheetName = entry.getKey();
            ExcelEditorPresenter sheet = entry.getValue();
            ObjectFieldTypeBuilder sheetBuilder = excelBuilder.addField();
            sheetBuilder.key(sheetName);
            ObjectTypeBuilder columnsBuilder = sheetBuilder.value().arrayType().of().objectType();
            for (TreeTableElement treeTableElement : sheet.getElements()) {
                ObjectFieldTypeBuilder columnFieldBuilder = columnsBuilder.addField().required();
                TypedTableElement castedElem = (TypedTableElement)treeTableElement;
                String columnName = castedElem.getName();
                columnFieldBuilder.key(columnName);
                columnFieldBuilder.value((MetadataType)castedElem.getType().getModel());
            }
        }
        ObjectType metadataType = excelBuilder.build();
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_EXCEL));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.WEAVE));
        DataWeaveMetadataTypeWriter typeWriter = new DataWeaveMetadataTypeWriter(this.getKey());
        annotations.put(ContentAnnotation.class, new ContentAnnotation(typeWriter.toString((MetadataType)metadataType)));
        return MetadataResult.from(MetadataTypeProxy.proxying((MetadataType)metadataType, annotations));
    }

    @Override
    protected void doValidate() {
        boolean validKey;
        this.getOnValidationMessage().clear();
        if (StringUtils.isNotBlank((String)this.getKey()) && !(validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey()))) {
            this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
        }
    }

    private Map<String, ObjectType> getSheetNamesToMetadata(Optional<MetadataType> maybePreviousMetadata) {
        ObjectType previousObjectMetadata;
        MetadataType previousMetadata;
        LinkedHashMap<String, ObjectType> sheetsToMetadata = new LinkedHashMap<String, ObjectType>();
        if (maybePreviousMetadata.isPresent() && (previousMetadata = maybePreviousMetadata.get()) instanceof ObjectType && !(previousObjectMetadata = (ObjectType)previousMetadata).getFields().isEmpty()) {
            Collection sheetsMetadata = previousObjectMetadata.getFields();
            for (ObjectFieldType sheetMetaDataField : sheetsMetadata) {
                MetadataType sheetMetadata = sheetMetaDataField.getValue();
                if (!(sheetMetadata instanceof ArrayType)) continue;
                ArrayType sheetArrayMetadata = (ArrayType)sheetMetadata;
                sheetsToMetadata.put(sheetMetaDataField.getKey().getName().toString(), (ObjectType)sheetArrayMetadata.getType());
            }
        }
        return sheetsToMetadata;
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Optional<MetadataType> maybePreviousMetadata = Optional.ofNullable(this.getMetadataTypeFromCache(this.getPreviousKey()));
        final CTabFolder folder = new CTabFolder(parent, 1026);
        GridLayoutFactory.fillDefaults().applyTo((Composite)folder);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)folder);
        CTabItem tab = new CTabItem(folder, 2);
        tab.setText("+");
        Map<String, ObjectType> sheetsToMetadata = this.getSheetNamesToMetadata(maybePreviousMetadata);
        for (Map.Entry<String, ObjectType> entry : sheetsToMetadata.entrySet()) {
            String sheetName = entry.getKey();
            ObjectType sheetMetadata = entry.getValue();
            this.createSheet(sheetName, folder, sheetMetadata);
        }
        if (sheetsToMetadata.isEmpty()) {
            this.createSheet("Sheet1", folder, null);
        }
        folder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CTabItem[] items;
                CTabItem[] cTabItemArray = items = folder.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem item = cTabItemArray[n2];
                    if (item.getBounds().contains(e.x, e.y)) {
                        String oldSheetName = item.getText();
                        String newSheetName = ExcelMetadataDefinitionEditor.this.askForNewName(oldSheetName);
                        item.setText(newSheetName);
                        LinkedHashMap<String, ExcelEditorPresenter> tempSheets = new LinkedHashMap<String, ExcelEditorPresenter>(ExcelMetadataDefinitionEditor.this.sheets);
                        ExcelMetadataDefinitionEditor.this.sheets.clear();
                        for (Map.Entry entry : tempSheets.entrySet()) {
                            if (((String)entry.getKey()).equals(oldSheetName)) {
                                ExcelMetadataDefinitionEditor.this.sheets.put(newSheetName, (ExcelEditorPresenter)((Object)entry.getValue()));
                                continue;
                            }
                            ExcelMetadataDefinitionEditor.this.sheets.put((String)entry.getKey(), (ExcelEditorPresenter)((Object)entry.getValue()));
                        }
                        ExcelMetadataDefinitionEditor.this.recordChange();
                        break;
                    }
                    ++n2;
                }
            }
        });
        folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                CTabItem item = (CTabItem)event.item;
                ExcelMetadataDefinitionEditor.this.sheets.remove(item.getText());
                ExcelMetadataDefinitionEditor.this.recordChange();
            }
        });
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int lastIndex = folder.getItemCount() - 1;
                CTabItem lastItem = folder.getItem(lastIndex);
                if (e.item == lastItem) {
                    String sheetName = "Sheet" + (lastIndex + 1);
                    ExcelMetadataDefinitionEditor.this.createSheet(sheetName, folder, null);
                    folder.setSelection(lastIndex);
                }
            }
        });
        folder.setSelection(0);
    }

    private String askForNewName(String oldSheetName) {
        InputDialog inputDialog = new InputDialog(this.getShell(), "Rename sheet", "Enter the new name for the sheet:", oldSheetName, new IInputValidator(){

            public String isValid(String newText) {
                if (StringUtils.isBlank((String)newText)) {
                    return "Sheet name cannot be blank.";
                }
                return null;
            }
        });
        inputDialog.open();
        String newSheetName = inputDialog.getValue();
        if (StringUtils.isNotBlank((String)newSheetName)) {
            return newSheetName;
        }
        return oldSheetName;
    }

    private void createSheet(String sheetName, CTabFolder folder, ObjectType sheetMetadata) {
        CTabItem tab = new CTabItem(folder, 66, folder.getItemCount() - 1);
        tab.setText(sheetName);
        TypedTreeEditor treeTableEditor = new TypedTreeEditor((Composite)folder);
        treeTableEditor.setBackground(ThemeUtils.getCurrentTheme().getWidgetBackgroundColor());
        tab.setControl((Control)treeTableEditor);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeTableEditor);
        ExcelTypesManager typesManager = new ExcelTypesManager();
        ExcelEditorPresenter presenter = new ExcelEditorPresenter(typesManager);
        presenter.loadValues(sheetMetadata);
        this.sheets.put(sheetName, presenter);
        presenter.handle((TreeTableEditor)treeTableEditor);
        presenter.addListener(action -> this.recordChange());
    }

    @Override
    protected MetadataType filterMetadataType(MetadataType metadataType) {
        MetadataType temp = metadataType;
        if (temp instanceof ArrayType) {
            temp = ((ArrayType)metadataType).getType();
        }
        if (temp instanceof ObjectType && MetadataFormats.EXCEL.equals((Object)temp.getMetadataFormat())) {
            return metadataType;
        }
        return null;
    }
}

