/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.TreeViewer;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.ExcelElement;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.treetable.IActionHandler;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditor;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TypesManager;

public class ExcelEditorPresenter
extends TypedTreeEditorPresenter<TypedTreeEditor, MetadataType> {
    public ExcelEditorPresenter(TypesManager<MetadataType> manager) {
        super(manager);
    }

    public void loadValues(ObjectType sheetMetadata) {
        ArrayList elements = new ArrayList();
        List<ObjectFieldType> columnMetadataFields = this.getColumnMetadataFields(sheetMetadata);
        for (ObjectFieldType colMetaDataField : columnMetadataFields) {
            QName qname = colMetaDataField.getKey().getName();
            MetadataType colMetaDataModel = colMetaDataField.getValue();
            ContentType type = this.getManager().getTypeFromParameterType((Object)colMetaDataModel);
            ExcelElement element = new ExcelElement(qname, type);
            elements.add(element);
        }
        if (!elements.isEmpty()) {
            this.getElements().clear();
            this.getElements().addAll(elements);
        }
    }

    protected TreeTableElement createElementToAdd(String name) {
        ContentType contentType = (ContentType)this.getManager().getTypes().get(0);
        return new ExcelElement(new QName(name), contentType);
    }

    private List<ObjectFieldType> getColumnMetadataFields(ObjectType sheetMetadata) {
        ArrayList columnFields = Lists.newArrayList();
        if (sheetMetadata != null) {
            columnFields.addAll(sheetMetadata.getFields());
        }
        return columnFields;
    }

    protected IActionHandler createAddAction(TreeViewer treeViewer) {
        return this.doCreateAddAction(treeViewer, "column_");
    }
}

