/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.DynamicTableElement;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.DynamicTreeEditorPresenter;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.DynamicTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.ComplexDynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.DynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.ElementDynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.ElementListDynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.SimpleListDynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditor;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditor;

public class DynamicMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    public static final String ROOT_TYPE_LABEL = "Type";
    private TypedTreeEditor typedEditor;
    private DynamicTreeEditorPresenter typedEditorPresenter;
    private ComboViewer rootTypeViewer;

    public DynamicMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.createControl(this);
    }

    @Override
    public MetadataResult calculateMetadata() {
        if (StringUtils.isBlank((String)this.getKey())) {
            return MetadataResult.from("Root id is empty");
        }
        List elements = this.typedEditorPresenter.getElements();
        if (elements.isEmpty()) {
            return MetadataResult.from("Field list is empty");
        }
        try {
            BaseTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
            String name = this.getKey();
            ComplexDynamicObject selectedRootType = this.getSelectedRootType();
            if (selectedRootType.isList()) {
                ArrayTypeBuilder listBuilder = builder.arrayType();
                ObjectTypeBuilder ofDynamicObject = listBuilder.id(name).id("List").of().objectType().id(Map.class.getName());
                this.fillChildren(ofDynamicObject, (TreeTableElement[])elements.toArray(new DynamicTableElement[elements.size()]));
            } else {
                ObjectTypeBuilder createDynamicObject = builder.objectType().id(Map.class.getName());
                this.fillChildren(createDynamicObject, (TreeTableElement[])elements.toArray(new DynamicTableElement[elements.size()]));
            }
            return MetadataResult.from(builder.build());
        }
        catch (Exception e) {
            return MetadataResult.from("Error creating metadata... \n" + e.getLocalizedMessage());
        }
    }

    private void fillChildren(ObjectTypeBuilder createDynamicObject, TreeTableElement[] children) {
        TreeTableElement[] treeTableElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeTableElement treeTableElement = treeTableElementArray[n2];
            String eName = treeTableElement.getName();
            DynamicObject value = (DynamicObject)((DynamicTableElement)treeTableElement).getType().getModel();
            if (value instanceof ComplexDynamicObject) {
                TreeTableElement[] deeperChildren = treeTableElement.getChildren();
                if (deeperChildren != null && deeperChildren.length > 0) {
                    this.fillComplexChildren((ComplexDynamicObject)value, eName, createDynamicObject, deeperChildren);
                }
            } else if (value instanceof SimpleListDynamicObject) {
                fieldBuilder = createDynamicObject.addField();
                fieldBuilder.key(eName);
                ofType = fieldBuilder.value().arrayType().of();
                this.setBuilderTypeForField(value, ofType);
            } else {
                fieldBuilder = createDynamicObject.addField();
                fieldBuilder.key(eName);
                ofType = fieldBuilder.value();
                this.setBuilderTypeForField(value, ofType);
            }
            ++n2;
        }
    }

    private void setBuilderTypeForField(DynamicObject value, final BaseTypeBuilder ofType) {
        value.getType().accept(new MetadataTypeVisitor(){

            public void visitBinaryType(BinaryType binaryType) {
                this.defaultVisit((MetadataType)binaryType);
            }

            public void visitBoolean(BooleanType booleanType) {
                ofType.booleanType();
            }

            public void visitDateTime(DateTimeType dateTimeType) {
                ofType.dateTimeType();
            }

            public void visitDate(DateType dateType) {
                ofType.dateType();
            }

            public void visitNumber(NumberType numberType) {
                ofType.numberType().with((TypeAnnotation)numberType.getAnnotation(TypeAnnotation.class).get());
            }

            public void visitString(StringType stringType) {
                ofType.stringType();
            }
        });
    }

    private boolean isListOfElements(String key) {
        MetadataType customMetadata = this.getMetadataTypeFromCache(key);
        return customMetadata instanceof ArrayType;
    }

    private ObjectType getMetaDataModel(String key) {
        MetadataType customMetadata = this.getMetadataTypeFromCache(key);
        if (customMetadata instanceof ArrayType) {
            customMetadata = ((ArrayType)customMetadata).getType();
        }
        if (customMetadata instanceof ObjectType) {
            return (ObjectType)customMetadata;
        }
        return null;
    }

    private void fillComplexChildren(ComplexDynamicObject value, String valueName, ObjectTypeBuilder createDynamicObject, TreeTableElement[] deeperChildren) {
        if (value.isList()) {
            ObjectFieldTypeBuilder fieldBuilder = createDynamicObject.addField();
            fieldBuilder.key(valueName);
            ObjectTypeBuilder innerObject = fieldBuilder.value().arrayType().of().objectType().id(Map.class.getName());
            this.fillChildren(innerObject, deeperChildren);
        } else {
            ObjectFieldTypeBuilder fieldBuilder = createDynamicObject.addField();
            fieldBuilder.key(valueName);
            ObjectTypeBuilder innerObject = fieldBuilder.value().objectType().id(Map.class.getName());
            this.fillChildren(innerObject, deeperChildren);
        }
    }

    private ComplexDynamicObject getSelectedRootType() {
        StructuredSelection selection = (StructuredSelection)this.rootTypeViewer.getSelection();
        return (ComplexDynamicObject)selection.getFirstElement();
    }

    @Override
    protected void createKey(Composite parent) {
        Composite keyWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(keyWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)keyWrapper);
        Label typeLabel = new Label(keyWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)typeLabel);
        typeLabel.setText(ROOT_TYPE_LABEL);
        this.rootTypeViewer = new ComboViewer(keyWrapper, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.rootTypeViewer.getControl());
        this.rootTypeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.rootTypeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DynamicObject) {
                    return ((DynamicObject)element).getLabel();
                }
                return super.getText(element);
            }
        });
        ComplexDynamicObject[] input = new ComplexDynamicObject[]{new ElementDynamicObject(), new ElementListDynamicObject()};
        this.rootTypeViewer.setInput((Object)input);
        this.rootTypeViewer.setSelection((ISelection)new StructuredSelection((Object)input[this.isListOfElements(this.getPreviousKey()) ? 1 : 0]));
        this.rootTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DynamicMetadataDefinitionEditor.this.recordChange();
            }
        });
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        this.typedEditor = new TypedTreeEditor(parent);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.typedEditor);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.typedEditor);
        ObjectType previousMetadata = this.getPreviousKey() != null ? this.getMetaDataModel(this.getPreviousKey()) : null;
        this.typedEditorPresenter = new DynamicTreeEditorPresenter(DynamicTypesManager.newInstance(), previousMetadata);
        this.typedEditorPresenter.addListener(new TreeTableEditorPresenter.TreeTableEditorListener(){

            public void actionPerformed(TreeTableEditorPresenter.EditorActions action) {
                DynamicMetadataDefinitionEditor.this.validate();
                if (!TreeTableEditorPresenter.EditorActions.LOAD.equals((Object)action)) {
                    DynamicMetadataDefinitionEditor.this.recordChange();
                }
            }
        });
        this.typedEditorPresenter.handle((TreeTableEditor)this.typedEditor);
    }

    @Override
    public void doValidate() {
        if (StringUtils.isBlank((String)this.getKey())) {
            this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
        } else {
            boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
            if (!validKey) {
                this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
            } else {
                MetadataResult metadataResult = this.getMetadata();
                if (!metadataResult.isValid()) {
                    this.getOnValidationMessage().setValidationMessage(metadataResult.getMessage());
                } else {
                    this.getOnValidationMessage().clear();
                }
            }
        }
    }
}

