/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.treetable.TypesManager;

public class CSVTypesManager
implements TypesManager<MetadataType> {
    private static final List<ContentType<MetadataType>> metadataTypes = new ArrayList<ContentType<MetadataType>>();

    static {
        BaseTypeBuilder typeBuilder = MetadataFactory.newBuilder((MetadataFormat)MetadataFormats.CSV);
        metadataTypes.add((ContentType<MetadataType>)new ContentType("String", "string", (Object)typeBuilder.stringType().build()));
        metadataTypes.add((ContentType<MetadataType>)new ContentType("Number", "number", (Object)typeBuilder.numberType().build()));
        metadataTypes.add((ContentType<MetadataType>)new ContentType("Boolean", "boolean", (Object)typeBuilder.booleanType().build()));
        metadataTypes.add((ContentType<MetadataType>)new ContentType("Date", "date", (Object)typeBuilder.dateType().build()));
        metadataTypes.add((ContentType<MetadataType>)new ContentType("DateTime", "datetime", (Object)typeBuilder.dateTimeType().build()));
    }

    public List<ContentType<MetadataType>> getTypes() {
        return metadataTypes;
    }

    public ContentType<MetadataType> getType(String id) {
        if (StringUtils.isNotBlank((String)id)) {
            for (ContentType<MetadataType> type : metadataTypes) {
                if (!type.getId().equals(id)) continue;
                return type;
            }
        }
        throw new IllegalArgumentException("Id: " + id + " is not a valid id");
    }

    public ContentType<MetadataType> getTypeFromParameterType(MetadataType metadataType) {
        if (metadataType != null) {
            for (ContentType<MetadataType> currentMetadataType : metadataTypes) {
                if (!MetadataTypeHelper.isAssignable((MetadataType)((MetadataType)currentMetadataType.getModel()), (MetadataType)metadataType)) continue;
                return currentMetadataType;
            }
        }
        throw new IllegalArgumentException("ContentType: " + String.valueOf(metadataType) + " is not a valid dataType for an Excel cell.");
    }
}

