/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.alsp.SupportedContentTypes;
import org.mule.alsp.editor.EmbeddedApiEditor;
import org.mule.alsp.validation.RAMLValidationUtils;
import org.mule.alsp.validation.ValidationResult;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PropertiesAnnotation;
import org.mule.tooling.metadata.types.utils.CSVRamlTypeLoader;
import org.mule.tooling.metadata.types.utils.DataWeaveMetadataTypeWriter;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.CSVTreeEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.CSVTreeEditorPresenter;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.FlatFileAnalyzer;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.CSVTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditor;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTableElement;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class CSVMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    private static final String CSV_TEMPLATE = "/raml/new_csv_schema.template";
    private static final String ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.error";
    private static final String LABEL_CLASS = "Example Definition";
    private static final String LABEL_RAML_DEFINITION = "RAML Definition";
    private StyledText ramlStyledText;
    private Optional<MetadataType> editedModel;
    private IDocument document;
    private AnnotationModel annotationModel;
    private ComboViewer comboViewer;
    private Label messageLabel;
    private Text exampleFilePath;
    private Button btnHasHeaders;
    private CSVTreeEditor typedEditor;
    private CSVTreeEditorPresenter<CSVTreeEditor, MetadataType> typedEditorPresenter;
    private List<Resource> examples = Collections.emptyList();
    private EmbeddedApiEditor apiEditor;

    public CSVMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.createControl(this);
    }

    @Override
    public MetadataResult calculateMetadata() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
            String selected = (String)selection.getFirstElement();
            return LABEL_CLASS.equals(selected) ? this.calculateMetadataFromExample() : this.calculateMetadataFromScript();
        }
        catch (Exception e) {
            return MetadataResult.from("Error creating metadata... \n" + e.getLocalizedMessage());
        }
    }

    private MetadataResult calculateMetadataFromExample() {
        List elements = this.typedEditorPresenter.getElements();
        if (elements.isEmpty()) {
            return MetadataResult.from("Field list is empty");
        }
        try {
            HashMap<Class<ContentAnnotation>, Object> annotations = new HashMap<Class<ContentAnnotation>, Object>();
            BaseTypeBuilder metadataBuilder = MetadataFactory.newBuilder((MetadataFormat)MetadataFormats.CSV);
            ArrayTypeBuilder arrayBuilder = metadataBuilder.arrayType();
            ObjectTypeBuilder csvBuilder = metadataBuilder.objectType();
            for (TreeTableElement field : elements) {
                ObjectFieldTypeBuilder columnFieldBuilder = csvBuilder.addField().required();
                TypedTableElement csvField = (TypedTableElement)field;
                columnFieldBuilder.key(CharMatcher.is((char)'\"').trimFrom((CharSequence)csvField.getName()));
                columnFieldBuilder.value((MetadataType)csvField.getType().getModel());
            }
            String examplePath = this.exampleFilePath.getText();
            if (StringUtils.isNotBlank((String)examplePath)) {
                File file = CoreUtils.pathToFile((String)examplePath, (IMuleProject)this.getMuleProject(), (boolean)false);
                if (file != null) {
                    Optional classpathResource = CoreUtils.toClasspathResource((File)file, (IMuleProject)this.getMuleProject());
                    if (classpathResource.isPresent()) {
                        annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation((String)classpathResource.get()));
                    } else {
                        annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(this.getResourcePath(this.examples.get(0), "examples")));
                    }
                } else {
                    return MetadataResult.from("Selected example file doesnt exist.");
                }
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            String delimiter = this.typedEditorPresenter.getDelimiter();
            if (delimiter != null) {
                properties.put("separator", delimiter);
            }
            properties.put("headerLineNumber", Integer.toString(this.typedEditorPresenter.getRowsToIgnore()));
            properties.put("header", Boolean.toString(this.btnHasHeaders.getSelection()));
            boolean isQuotedString = this.typedEditorPresenter.isQuotedString();
            properties.put("isQuotedString", Boolean.toString(isQuotedString));
            if (isQuotedString) {
                properties.put("quote", this.typedEditorPresenter.getQuoteChar());
            }
            annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_CSV));
            annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.WEAVE));
            annotations.put(PropertiesAnnotation.class, new PropertiesAnnotation(properties));
            ArrayType metadataType = arrayBuilder.with((TypeAnnotation)new MetadataFormatPropertiesAnnotation(properties)).of((MetadataType)csvBuilder.build()).build();
            DataWeaveMetadataTypeWriter typeWriter = new DataWeaveMetadataTypeWriter(this.getKey());
            annotations.put(ContentAnnotation.class, new ContentAnnotation(typeWriter.toString((MetadataType)metadataType)));
            return MetadataResult.from(MetadataTypeProxy.proxying((MetadataType)metadataType, annotations));
        }
        catch (Exception e) {
            return MetadataResult.from("Error creating metadata... \n" + e.getLocalizedMessage());
        }
    }

    private MetadataResult calculateMetadataFromScript() {
        HashMap<Class<ContentAnnotation>, Object> annotations = new HashMap<Class<ContentAnnotation>, Object>();
        String ramlType = this.getRamlType();
        Objects.requireNonNull(ramlType);
        Preconditions.checkArgument((!ramlType.isEmpty() ? 1 : 0) != 0, (Object)"RAML type definition should not be empty");
        CSVRamlTypeLoader loader = new CSVRamlTypeLoader(ramlType);
        Optional maybeMetadataType = loader.load(null);
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_CSV));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.RAML));
        annotations.put(ContentAnnotation.class, new ContentAnnotation(ramlType));
        return MetadataResult.from(MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormat.CSV)), annotations));
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        this.comboViewer = new ComboViewer(parent, 8);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo(this.comboViewer.getControl());
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboViewer.setInput((Object)new String[]{LABEL_CLASS, LABEL_RAML_DEFINITION});
        Composite wrapper = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        StackLayout layout = new StackLayout();
        wrapper.setLayout((Layout)layout);
        this.editedModel = Optional.ofNullable(this.getMetadataTypeFromCache(this.getPreviousKey()));
        Composite fileComposite = this.buildCustomDefinitionTab(wrapper);
        Composite definitionComposite = this.buildDefinitionTab(wrapper);
        layout.topControl = fileComposite;
        wrapper.layout();
        Object selectedElement = this.comboViewer.getElementAt(this.isWeaveDefinition() || !this.editedModel.isPresent() ? 0 : 1);
        this.comboViewer.setSelection((ISelection)new StructuredSelection(selectedElement));
        layout.topControl = LABEL_CLASS.equals(selectedElement) ? fileComposite : definitionComposite;
        this.comboViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() > 0) {
                String selected = (String)selection.getFirstElement();
                stackLayout.topControl = LABEL_CLASS.equals(selected) ? fileComposite : definitionComposite;
                wrapper.layout();
                this.refresh();
            }
        });
    }

    private void updateExampleFileUrl() {
        String examplePath = this.typedEditorPresenter.getExampleFilePath();
        if (StringUtils.isNotBlank((String)examplePath)) {
            IMuleProject muleProject = this.getMuleProject();
            File file = CoreUtils.pathToFile((String)examplePath, (IMuleProject)muleProject, (boolean)false);
            this.examples = Collections.singletonList(Resource.create(examplePath, file, muleProject));
            this.checkExamplesToCopy();
            this.exampleFilePath.setText(this.examples.get(0).getPathInClasspath().orElse(examplePath));
            this.typedEditorPresenter.setExampleFilePath(null);
            this.exampleFilePath.redraw();
        }
    }

    private boolean isWeaveDefinition() {
        Optional maybeOriginAnnotation;
        Optional optional = maybeOriginAnnotation = this.editedModel.isPresent() ? this.editedModel.get().getAnnotation(OriginAnnotation.class) : Optional.empty();
        return maybeOriginAnnotation.isPresent() && ((OriginAnnotation)maybeOriginAnnotation.get()).getOrigin().equals((Object)MetadataTypeOrigin.WEAVE);
    }

    private boolean isWeaveDefinitionBasedOnSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
        String selectedElement = (String)selection.getFirstElement();
        return LABEL_CLASS.equals(selectedElement);
    }

    private Composite buildCustomDefinitionTab(Composite parent) {
        Composite fileComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(fileComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fileComposite);
        Composite definitionWrapper = new Composite(fileComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(definitionWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)definitionWrapper);
        this.btnHasHeaders = new Button(definitionWrapper, 32);
        this.btnHasHeaders.setToolTipText("Checked if csv first line includes headers");
        this.btnHasHeaders.setText("CSV includes header row");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.btnHasHeaders);
        this.createCSVTreeEditor(definitionWrapper);
        this.btnHasHeaders.setSelection(true);
        if (this.editedModel.isPresent()) {
            MetadataType metadataType = this.editedModel.get();
            this.btnHasHeaders.setSelection(this.hasHeaders(metadataType));
            this.fillTypedEditorPresenterConfig(metadataType);
        }
        this.btnHasHeaders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVMetadataDefinitionEditor.this.refresh();
                boolean hasHeaders = CSVMetadataDefinitionEditor.this.btnHasHeaders.getSelection();
                CSVMetadataDefinitionEditor.this.typedEditorPresenter.setCanEditElementName(hasHeaders);
                if (!hasHeaders) {
                    List elements = CSVMetadataDefinitionEditor.this.typedEditorPresenter.getElements();
                    boolean shouldResetNames = false;
                    int index = 0;
                    while (index < elements.size()) {
                        TreeTableElement element = (TreeTableElement)elements.get(index);
                        if (!("column_" + index).equals(element.getName())) {
                            shouldResetNames = true;
                            break;
                        }
                        ++index;
                    }
                    if (shouldResetNames) {
                        boolean confirmation;
                        MessageDialog messageDialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Reset column names", null, "Custom column names are not allowed without using header. Do you want to continue?", 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        boolean bl = confirmation = messageDialog.open() == 0;
                        if (confirmation) {
                            CSVMetadataDefinitionEditor.this.typedEditorPresenter.resetColumnNames(CSVMetadataDefinitionEditor.this.typedEditor.getTreeViewer());
                        }
                    }
                }
            }
        });
        this.createSampleFileControl(definitionWrapper);
        this.messageLabel = this.createMessageLabel(definitionWrapper);
        return fileComposite;
    }

    private void fillTypedEditorPresenterConfig(MetadataType metadataType) {
        Optional<String> maybeRowsToIgnore;
        Optional<String> maybeIsQuotedString;
        Optional<String> maybeQuotedChar;
        Optional<String> maybeDelimiterValue = this.getPropertyValue(metadataType, "separator");
        if (maybeDelimiterValue.isPresent()) {
            this.typedEditorPresenter.setDelimiter(maybeDelimiterValue.get());
        }
        if ((maybeQuotedChar = this.getPropertyValue(metadataType, "quote")).isPresent()) {
            this.typedEditorPresenter.setQuoteChar(maybeQuotedChar.get());
        }
        if ((maybeIsQuotedString = this.getPropertyValue(metadataType, "isQuotedString")).isPresent()) {
            this.typedEditorPresenter.setQuotedString(maybeIsQuotedString.get().equalsIgnoreCase(Boolean.TRUE.toString()));
        }
        if ((maybeRowsToIgnore = this.getPropertyValue(metadataType, "headerLineNumber")).isPresent()) {
            this.typedEditorPresenter.setRowsToIgnore(Integer.valueOf(maybeRowsToIgnore.get()));
        }
    }

    private void createCSVTreeEditor(Composite definitionWrapper) {
        this.typedEditor = new CSVTreeEditor(definitionWrapper);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.typedEditor);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.typedEditor);
        this.typedEditorPresenter = new CSVTreeEditorPresenter(new CSVTypesManager(), this.getMuleProject());
        if (this.editedModel.isPresent() && this.isWeaveDefinition()) {
            this.typedEditorPresenter.loadValues(this.editedModel.get());
        }
        TreeTableEditorPresenter.TreeTableEditorListener editorListener = action -> {
            this.validate();
            if (!TreeTableEditorPresenter.EditorActions.LOAD.equals((Object)action)) {
                this.recordChange();
            }
            this.updateExampleFileUrl();
        };
        this.typedEditorPresenter.handle((TreeTableEditor)this.typedEditor);
        this.typedEditorPresenter.addListener(editorListener);
    }

    private void createSampleFileControl(Composite parent) {
        Optional maybeExamplePathAnnotation;
        Composite fileWrapper = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fileWrapper);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(fileWrapper);
        Label sampleLabel = new Label(fileWrapper, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sampleLabel);
        sampleLabel.setText("Sample File");
        this.exampleFilePath = new Text(fileWrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.exampleFilePath);
        this.exampleFilePath.setMessage("Select your CSV sample file");
        Button openExampleButton = new Button(fileWrapper, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)openExampleButton);
        openExampleButton.setText("...");
        if (this.editedModel.isPresent() && (maybeExamplePathAnnotation = this.editedModel.get().getAnnotation(ExamplePathAnnotation.class)).isPresent()) {
            this.exampleFilePath.setText(((ExamplePathAnnotation)maybeExamplePathAnnotation.get()).getPath());
        }
        this.exampleFilePath.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IMuleProject muleProject;
                File file;
                String examplePath = CSVMetadataDefinitionEditor.this.exampleFilePath.getText();
                if (StringUtils.isNotBlank((String)examplePath)) {
                    this.updateTreeFromSample();
                }
                if ((file = CoreUtils.pathToFile((String)examplePath, (IMuleProject)(muleProject = CSVMetadataDefinitionEditor.this.getMuleProject()), (boolean)false)) != null) {
                    CSVMetadataDefinitionEditor.this.examples = Collections.singletonList(Resource.create(examplePath, file, muleProject));
                }
                CSVMetadataDefinitionEditor.this.checkExamplesToCopy();
                CSVMetadataDefinitionEditor.this.refresh();
            }

            private void updateTreeFromSample() {
                String path = CSVMetadataDefinitionEditor.this.examples.isEmpty() ? CSVMetadataDefinitionEditor.this.exampleFilePath.getText() : CSVMetadataDefinitionEditor.this.examples.get(0).getPath();
                FlatFileAnalyzer analyzer = new FlatFileAnalyzer(path, CSVMetadataDefinitionEditor.this.typedEditorPresenter.getRowsToIgnore(), CSVMetadataDefinitionEditor.this.typedEditorPresenter.isQuotedString(), CSVMetadataDefinitionEditor.this.typedEditorPresenter.getQuoteChar() != null ? (char)CSVMetadataDefinitionEditor.this.typedEditorPresenter.getQuoteChar().charAt(0) : (char)'\"', CSVMetadataDefinitionEditor.this.typedEditorPresenter.getDelimiter() != null ? CSVMetadataDefinitionEditor.this.typedEditorPresenter.getDelimiter() : ",", CSVMetadataDefinitionEditor.this.getMuleProject());
                CSVMetadataDefinitionEditor.this.updateTreeView(analyzer);
            }
        }, (Control)fileWrapper));
        openExampleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<String> result = CSVMetadataDefinitionEditor.this.filePickerButtonPressed(false, new String[]{"CSV file"}, new String[]{"*.*"}, CSVMetadataDefinitionEditor.this.getShell());
                if (!result.isEmpty()) {
                    CSVMetadataDefinitionEditor.this.messageLabel.setText("");
                    CSVMetadataDefinitionEditor.this.examples = result.stream().map(f -> Resource.create(f, CoreUtils.pathToFile((String)f, (IMuleProject)CSVMetadataDefinitionEditor.this.getMuleProject()), CSVMetadataDefinitionEditor.this.getMuleProject())).collect(Collectors.toList());
                    CSVMetadataDefinitionEditor.this.checkExamplesToCopy();
                    CSVMetadataDefinitionEditor.this.exampleFilePath.setText(CSVMetadataDefinitionEditor.this.getFileTextFromSelectedResources(CSVMetadataDefinitionEditor.this.examples, "examples"));
                    CSVMetadataDefinitionEditor.this.recordChange();
                }
            }
        });
    }

    private boolean hasHeaders(MetadataType metadataType) {
        Optional<String> maybeHeader = this.getPropertyValue(metadataType, "header");
        return maybeHeader.isPresent() && maybeHeader.get().equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public Optional<String> getPropertyValue(MetadataType metadataType, String propertyName) {
        Optional maybePropertiesAnnotation = metadataType.getAnnotation(PropertiesAnnotation.class);
        return maybePropertiesAnnotation.isPresent() ? ((PropertiesAnnotation)maybePropertiesAnnotation.get()).getValue(propertyName) : Optional.empty();
    }

    private Composite buildDefinitionTab(Composite parent) {
        Composite wrapper = parent;
        try {
            this.apiEditor = new EmbeddedApiEditor(SupportedContentTypes.RAML, ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme);
            wrapper = this.apiEditor.createApiEditor(parent);
            this.document = this.apiEditor.getDocument();
            this.annotationModel = (AnnotationModel)this.apiEditor.getAnnotationModel();
            this.ramlStyledText = this.apiEditor.getStyledText();
            this.buildDocument(this.editedModel, this.document);
            this.createUIListeners(wrapper);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error creating API Editor", (Throwable)e);
        }
        return wrapper;
    }

    public void dispose() {
        if (this.apiEditor != null) {
            this.apiEditor.dispose();
            this.apiEditor = null;
        }
        super.dispose();
    }

    private IDocument buildDocument(Optional<MetadataType> maybeMetadataType, IDocument document) {
        if (maybeMetadataType.isPresent() && !this.isWeaveDefinition()) {
            MetadataType metadataType = maybeMetadataType.get();
            Optional maybeContentAnnotation = metadataType.getAnnotation(ContentAnnotation.class);
            ContentAnnotation contentAnnotation = (ContentAnnotation)maybeContentAnnotation.orElseThrow(() -> new RuntimeException("Invalid content"));
            document.set(contentAnnotation.getContent());
        } else {
            document.set(this.getDefaultScript());
        }
        return document;
    }

    private String getDefaultScript() {
        String result = null;
        InputStream template = CSVMetadataDefinitionEditor.class.getResourceAsStream(CSV_TEMPLATE);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Scanner scanner = new Scanner(template);){
            result = scanner.useDelimiter("\\A").next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private void createUIListeners(Composite wrapper) {
        this.ramlStyledText.addModifyListener((ModifyListener)new IdleModifyEventListener(400L, e -> this.refresh(), (Control)wrapper));
    }

    private void refresh() {
        this.validate();
        this.recordChange();
    }

    @Override
    protected void doValidate() {
        if (StringUtils.isNotBlank((String)this.getKey())) {
            boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
            if (!validKey) {
                this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
            } else if (!this.isWeaveDefinitionBasedOnSelection()) {
                String ramlType = this.getRamlType();
                if (StringUtils.isBlank((String)ramlType)) {
                    this.getOnValidationMessage().setValidationMessage("The type cannot be blank");
                } else if (this.validateRAMLScript(ramlType)) {
                    MetadataResult result = this.getMetadata();
                    if (result.isValid()) {
                        this.getOnValidationMessage().clear();
                    } else {
                        this.getOnValidationMessage().setValidationMessage(result.getMessage());
                    }
                } else {
                    this.getOnValidationMessage().setValidationMessage("There are errors in the script");
                }
            }
        }
    }

    private boolean validateRAMLScript(String ramlType) {
        this.annotationModel.removeAllAnnotations();
        List validationResults = RAMLValidationUtils.validateRAML10DataType((String)ramlType);
        for (ValidationResult errorInfo : validationResults) {
            Annotation annotation = new Annotation(ANNOTATION_TYPE, false, errorInfo.getMessage());
            try {
                int initialOffset = this.document.getLineOffset(errorInfo.getStartLine()) + errorInfo.getStartColumn();
                int finalOffset = this.document.getLineOffset(errorInfo.getEndLine()) + errorInfo.getEndColumn();
                this.annotationModel.addAnnotation(annotation, new Position(initialOffset, finalOffset - initialOffset));
            }
            catch (BadLocationException e) {
                MuleCorePlugin.logError((String)"Error parsing RAML script", (Throwable)e);
                this.annotationModel.addAnnotation(annotation, new Position(0));
            }
        }
        return validationResults.isEmpty();
    }

    private String getRamlType() {
        return this.ramlStyledText.getText();
    }

    private void updateTreeView(FlatFileAnalyzer analyzer) {
        try {
            List<String> fields = analyzer.analyze();
            TreeViewer treeViewer = this.typedEditor.getTreeViewer();
            this.typedEditorPresenter.loadFieldsInTreeTable(fields, treeViewer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected MetadataType filterMetadataType(MetadataType metadataType) {
        MetadataType temp = metadataType;
        if (temp instanceof ArrayType) {
            temp = ((ArrayType)metadataType).getType();
        }
        if (temp instanceof ObjectType && MetadataFormat.CSV.equals((Object)temp.getMetadataFormat())) {
            return metadataType;
        }
        return null;
    }

    @Override
    public void applyChanges() {
        IFolder examplesFolder = this.getExamplesFolder();
        Resource.getResourcesToCopyStream(this.examples).forEach(example -> {
            File sourceFile = example.getFile();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream is = new FileInputStream(sourceFile);){
                    String uniqueName = MuleResourceUtils.getUniqueFileName((File)examplesFolder.getRawLocation().toFile(), (String)sourceFile.getName());
                    MuleResourceUtils.createFile((IFolder)examplesFolder, (String)uniqueName, (InputStream)is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                MuleCorePlugin.logError((String)"Error copying examples", (Throwable)e);
            }
        });
    }

    private void checkExamplesToCopy() {
        Resource.getResourcesToCopyMessage(this.examples).ifPresent(message -> this.messageLabel.setText(message + " will be copied to src/main/resources/examples"));
    }
}

