/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.types;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.metadata.MetadataTypeGraphicalChildrenProvider;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.ICustomMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public abstract class BaseMetadataDefinitionEditor
extends Composite
implements ICustomMetadataDefinitionEditor {
    public static final String FILE_SEPARATOR_TOKEN = ",";
    public static final String TYPE_ID_LABEL = "Type Id";
    public static final String SCHEMAS_FOLDER = "schemas";
    public static final String EXAMPLES_FOLDER = "examples";
    public static final String WEAVE_FOLDER = "weave";
    private IMuleProject muleProject;
    private String metadataKey;
    private final IMetadataDefinitionValidator editorValidator;
    private final OnValidationMessage onValidationMessage;
    private final ChangeManager changeManager;

    public BaseMetadataDefinitionEditor(Composite parent, IMuleProject muleProject, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, 0);
        this.muleProject = muleProject;
        this.editorValidator = editorValidator;
        this.changeManager = changeManager;
        this.metadataKey = key;
        this.onValidationMessage = onValidationMessage;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public String getPreviousKey() {
        return this.metadataKey;
    }

    public IMetadataDefinitionValidator getEditorValidator() {
        return this.editorValidator;
    }

    @Override
    public MetadataResult getMetadata() {
        if (this.changeManager.areChanges()) {
            return this.calculateMetadata();
        }
        MetadataType customMetadata = this.getTypesManager().getCustomMetadataType(ToolingMetadataKeyBuilder.newKey((String)this.getPreviousKey()).build());
        return MetadataResult.from(customMetadata);
    }

    protected abstract MetadataResult calculateMetadata();

    protected void createKey(Composite parent) {
    }

    @Override
    public String getType() {
        return "#Custom Type#";
    }

    @Override
    public String getKey() {
        return this.metadataKey;
    }

    @Override
    public void validate() {
        if (this.getParent().isDisposed()) {
            return;
        }
        this.doValidate();
    }

    protected abstract void doValidate();

    protected String getFileTextFromSelectedResources(List<Resource> selectedResources, String target) {
        StringJoiner joiner = new StringJoiner(FILE_SEPARATOR_TOKEN);
        if (selectedResources != null && !selectedResources.isEmpty()) {
            for (Resource resource : selectedResources) {
                Optional<String> classpathResource = resource.getPathInClasspath();
                if (classpathResource.isPresent()) {
                    joiner.add(classpathResource.get());
                    continue;
                }
                joiner.add(resource.getPath());
            }
        }
        return joiner.toString();
    }

    protected List<String> filePickerButtonPressed(boolean allowsMulti, String[] filterNames, String[] extensions, Shell shell) {
        FileDialog dialog = allowsMulti ? new FileDialog(shell, 4098) : new FileDialog(shell, 4096);
        String projectRootPath = this.getProjectRootPath();
        dialog.setText("Open");
        dialog.setFilterPath(projectRootPath);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(extensions);
        if (dialog.open() != null) {
            String[] fileNames = dialog.getFileNames();
            ArrayList<String> selectedPaths = new ArrayList<String>();
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (StringUtils.isNotBlank((String)fileName)) {
                    String filePath = dialog.getFilterPath() + File.separator + fileName;
                    selectedPaths.add(filePath);
                }
                ++n2;
            }
            return selectedPaths;
        }
        return Collections.emptyList();
    }

    protected String getProjectRootPath() {
        return this.getMuleProject().getLocation().toFile().getAbsolutePath();
    }

    public ChangeManager getChangeManager() {
        return this.changeManager;
    }

    protected void recordChange() {
        if (this.getChangeManager() != null) {
            this.getChangeManager().change();
        }
    }

    protected TreeViewer createDetailsTree(Composite parent, Optional<MetadataType> model) {
        TreeViewer metadataStructureTree = new TreeViewer(parent, 68352);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)metadataStructureTree.getTree());
        metadataStructureTree.setLabelProvider((IBaseLabelProvider)new GraphicalTreeLabelProvider());
        metadataStructureTree.setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
        metadataStructureTree.setInput(this.getRoot(model));
        metadataStructureTree.expandToLevel(4);
        return metadataStructureTree;
    }

    protected GraphicalTreeNode<MetadataType> getRoot(Optional<MetadataType> maybeMetadataType) {
        if (maybeMetadataType.isPresent()) {
            return new GraphicalTreeNode(null, null, (Object)maybeMetadataType.get(), (IGraphicalChildrenProvider)this.createMetaDataModelGraphicalChildrenProvider());
        }
        return new GraphicalTreeNode(null, null, null, (Object)MetadataFactory.undefined(), (IGraphicalChildrenProvider)this.createMetaDataModelGraphicalChildrenProvider());
    }

    protected MetadataTypeGraphicalChildrenProvider createMetaDataModelGraphicalChildrenProvider() {
        return new MetadataTypeGraphicalChildrenProvider();
    }

    protected MetadataType getMetadataTypeFromCache(String key) {
        if (StringUtils.isNotBlank((String)key)) {
            ITypesManager typesManager = this.getTypesManager();
            MetadataType customMetadataType = typesManager.getCustomMetadataType(ToolingMetadataKeyBuilder.newKey((String)key).build());
            return this.filterMetadataType(customMetadataType);
        }
        return null;
    }

    protected Label createMessageLabel(Composite parent) {
        Composite messageLabelComposite = new Composite(parent, 0);
        Label messageLabel = WidgetUtils.createLabel((Composite)messageLabelComposite, (int)0, (int)10);
        Point hintForLabel = WidgetUtils.getHintForLabel((Label)messageLabel);
        GridLayoutFactory.fillDefaults().spacing(0, 0).extendedMargins(0, 0, 0, 0).applyTo(messageLabelComposite);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, hintForLabel.y + 2).applyTo((Control)messageLabelComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageLabel);
        return messageLabel;
    }

    protected MetadataType filterMetadataType(MetadataType metadataType) {
        return metadataType;
    }

    protected ITypesManager getTypesManager() {
        return ((MetadataTypesManager)this.getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }

    @Override
    public void onRefresh() {
    }

    @Override
    public void applyChanges() {
    }

    public IFolder getResourceFolder() {
        IMuleProject project = this.getMuleProject();
        return project.getFolder("src/main/resources");
    }

    public IFolder getExamplesFolder() {
        return this.getResourceFolder(EXAMPLES_FOLDER);
    }

    public IFolder getSchemasFolder() {
        return this.getResourceFolder(SCHEMAS_FOLDER);
    }

    public IFolder getResourceFolder(String folder) {
        IFolder resourcesFolder = this.getResourceFolder();
        IFolder currentFolder = resourcesFolder.getFolder(folder);
        if (!currentFolder.exists()) {
            try {
                currentFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("Error creating " + folder + " folder"), (Throwable)e);
            }
        }
        return currentFolder;
    }

    public String getResourcePath(Resource resource, String defaultFolder) {
        return resource.getPathInClasspath().flatMap(pathInClasspath -> {
            if (resource.isInValidResourcesFolder()) {
                return Optional.of(pathInClasspath);
            }
            return Optional.empty();
        }).orElseGet(() -> defaultFolder + "/" + MuleResourceUtils.getUniqueFileName((File)this.getResourceFolder(defaultFolder).getRawLocation().toFile(), (String)resource.getFileName()));
    }

    public static File resolvePath(IMuleProject muleProject, Resource resource) {
        return resource.getPathInClasspath().flatMap(classpathResource -> {
            Optional fullPath = CoreUtils.getFileFullPathFromSelectedResource((String)classpathResource, (IMuleProject)muleProject);
            return fullPath.map(s -> new File((String)s));
        }).orElse(resource.getFile());
    }

    public OnValidationMessage getOnValidationMessage() {
        return this.onValidationMessage;
    }
}

