/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.DynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.ElementDynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.ElementListDynamicObject;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.treetable.TypesManager;

public class DynamicTypesManager
implements TypesManager<DynamicObject> {
    private final List<ContentType<DynamicObject>> types = new ArrayList<ContentType<DynamicObject>>();

    public static DynamicTypesManager newInstance() {
        return new DynamicTypesManager();
    }

    private DynamicTypesManager() {
        this.init(new BaseTypeBuilder(MetadataFormat.JAVA));
    }

    private void init(BaseTypeBuilder typeBuilder) {
        this.types.add((ContentType<DynamicObject>)new ContentType("String", "string", (Object)new DynamicObject((MetadataType)typeBuilder.stringType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("Integer", "integer", (Object)new DynamicObject((MetadataType)typeBuilder.numberType().integer().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("Boolean", "boolean", (Object)new DynamicObject((MetadataType)typeBuilder.booleanType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("Element", "element", (Object)new ElementDynamicObject()));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<Element>", "lostofelement", (Object)new ElementListDynamicObject()));
        this.types.add((ContentType<DynamicObject>)new ContentType("Byte", "byte", (Object)new DynamicObject((MetadataType)typeBuilder.binaryType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("Date", "date", (Object)new DynamicObject((MetadataType)typeBuilder.dateType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("DateTime", "datetime", (Object)new DynamicObject((MetadataType)typeBuilder.dateTimeType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("Double", "double", (Object)new DynamicObject((MetadataType)typeBuilder.numberType().id("double").build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("Float", "float", (Object)new DynamicObject((MetadataType)typeBuilder.numberType().id("float").build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("Long", "long", (Object)new DynamicObject((MetadataType)typeBuilder.numberType().id("long").build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<String>", "listofstring", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().stringType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<Integer>", "listofinteger", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().numberType().integer().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<Boolean>", "listofboolean", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().booleanType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<Byte>", "listofbyte", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().binaryType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<Date>", "listofdate", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().dateType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<DateTime>", "listofdatetime", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().dateTimeType().build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<Double>", "listofdouble", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().numberType().id("double").build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<Float>", "listoffloat", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().numberType().id("float").build())));
        this.types.add((ContentType<DynamicObject>)new ContentType("List<Long>", "listoflong", (Object)new DynamicObject((MetadataType)typeBuilder.arrayType().of().numberType().id("long").build())));
    }

    public List<ContentType<DynamicObject>> getTypes() {
        return this.types;
    }

    public ContentType<DynamicObject> getType(String id) {
        if (StringUtils.isNotBlank((String)id)) {
            for (ContentType<DynamicObject> type : this.types) {
                if (!type.getId().equals(id)) continue;
                return type;
            }
        }
        throw new IllegalArgumentException("Id: " + id + " is not a valid id");
    }

    public ContentType<DynamicObject> getTypeFromParameterType(DynamicObject dataType) {
        if (dataType != null) {
            for (ContentType<DynamicObject> type : this.types) {
                if (!((DynamicObject)type.getModel()).equals(dataType)) continue;
                return type;
            }
        }
        throw new IllegalArgumentException("ContentType: " + String.valueOf(dataType) + " is not a valid dataType for CSV.");
    }
}

