/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.TreeViewer;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.DynamicTableElement;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.DynamicTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.DynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.ElementDynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.ElementListDynamicObject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.dynamic.model.SimpleListDynamicObject;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.treetable.IActionHandler;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditor;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditor;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TypesManager;
import org.mule.tooling.utils.ObjectHolder;

public class DynamicTreeEditorPresenter
extends TypedTreeEditorPresenter<TypedTreeEditor, DynamicObject> {
    public DynamicTreeEditorPresenter(TypesManager<DynamicObject> manager, ObjectType loadedMetadata) {
        super(manager);
        if (loadedMetadata != null) {
            this.loadPreviousValues(loadedMetadata);
        }
    }

    private void loadPreviousValues(ObjectType loadedMetadata) {
        this.getElements().clear();
        this.getElements().addAll(this.fillFields(loadedMetadata.getFields()));
    }

    private List<TypedTableElement<?>> fillFields(Collection<ObjectFieldType> collection) {
        ArrayList newElements = new ArrayList(collection.size());
        for (ObjectFieldType field : collection) {
            ContentType<DynamicObject> contentType = this.getContentType(field);
            DynamicTableElement element = new DynamicTableElement(field.getKey().getName(), contentType);
            if (((DynamicObject)contentType.getModel()).allowChildren()) {
                this.fillChildren(element, field.getValue());
            }
            newElements.add(element);
        }
        return newElements;
    }

    private void fillChildren(final TypedTableElement<DynamicObject> element, MetadataType metaDataModel) {
        metaDataModel.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                List<TypedTableElement<?>> newElements = DynamicTreeEditorPresenter.this.fillFields(objectType.getFields());
                element.addChildren(newElements);
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }
        });
    }

    private ContentType<DynamicObject> getContentType(ObjectFieldType field) {
        MetadataType fieldModel = field.getValue();
        final ObjectHolder holder = new ObjectHolder();
        fieldModel.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                holder.set((Object)new ElementDynamicObject());
            }

            public void visitArrayType(ArrayType arrayType) {
                if (arrayType.getType() instanceof ObjectType) {
                    holder.set((Object)new ElementListDynamicObject());
                } else {
                    new SimpleListDynamicObject((MetadataType)arrayType);
                }
            }

            protected void defaultVisit(MetadataType metadataType) {
                holder.set((Object)new DynamicObject(metadataType));
            }
        });
        return ((DynamicTypesManager)this.getManager()).getTypeFromParameterType((DynamicObject)holder.get());
    }

    protected void setActions(TypedTreeEditor editor, TreeViewer treeViewer) {
        super.setActions((TreeTableEditor)editor, treeViewer);
    }

    protected TreeTableElement createElementToAdd(String name) {
        return new DynamicTableElement(new QName(name), (ContentType<DynamicObject>)((ContentType)this.getManager().getTypes().get(0)));
    }

    protected IActionHandler createAddAction(TreeViewer treeViewer) {
        return super.doCreateAddAction(treeViewer, "column_");
    }
}

