/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.csv;

import org.apache.commons.lang.StringUtils;

public class QuotingDecoder {
    public static final String AUTO_MODE_STRING = "both";
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private boolean autoMode = true;
    private char quoteChar;
    private char startQuote;

    public CharSequence decode(CharSequence quoted) {
        int len = quoted.length();
        if (len < 2) {
            return quoted;
        }
        char first = quoted.charAt(0);
        char last = quoted.charAt(len - 1);
        if (this.autoMode ? first != '\'' && first != '\"' : first != this.quoteChar) {
            return quoted;
        }
        if (first != last) {
            return quoted;
        }
        char quoteChar = first;
        StringBuilder decoded = new StringBuilder(quoted.length() - 2);
        int i = 1;
        while (i < quoted.length() - 1) {
            decoded.append(quoted.charAt(i));
            if (quoted.charAt(i) == quoteChar && quoted.charAt(i + 1) == quoteChar) {
                ++i;
            }
            ++i;
        }
        return decoded;
    }

    public CharSequence encode(CharSequence unquoted) {
        char quoteChar = this.autoMode ? (char)'\"' : (char)this.quoteChar;
        int unquotedLen = unquoted.length();
        StringBuilder result = new StringBuilder(unquotedLen + 2);
        result.append(quoteChar);
        int i = 0;
        while (i < unquotedLen) {
            char ch = unquoted.charAt(i);
            if (ch == quoteChar) {
                result.append(quoteChar);
                result.append(quoteChar);
            } else {
                result.append(ch);
            }
            ++i;
        }
        result.append(quoteChar);
        return result;
    }

    public boolean isStartQuote(char c) {
        boolean isQuote;
        boolean bl = this.autoMode ? c == '\"' || c == '\'' : (isQuote = c == this.quoteChar);
        if (isQuote) {
            this.startQuote = c;
        }
        return isQuote;
    }

    public boolean isEndQuote(char c) {
        return c == this.startQuote;
    }

    public void setQuoteChar(Character quoteChar) {
        if (quoteChar == null) {
            this.autoMode = true;
        } else {
            this.quoteChar = quoteChar.charValue();
            this.autoMode = false;
        }
    }

    public static Character quoteCharFromString(String str) {
        if (StringUtils.isEmpty((String)str) || str.equals(AUTO_MODE_STRING)) {
            return null;
        }
        if (str.length() > 1) {
            throw new IllegalArgumentException("String has more than 1 character");
        }
        return Character.valueOf(str.charAt(0));
    }
}

