/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.csv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.DelimiterHeuristic;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.FlatFileAnalyzer;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.utils.OsDetect;

public class LoadFromExampleDialog
extends TitleAreaDialog {
    private static final String DIALOG_TITLE = "Load CSV fields from file";
    private static final String DEFAULT_MESSAGE = "Select your CSV file and complete your configuration";
    private List<String> fields;
    private String selectedFilePath;
    private int rowsToIgnoreQty = 0;
    private char quoteCharacter = (char)34;
    private String delimiterChar = ",";
    private boolean quotedStr = false;
    private Text filePath;
    private Text delimiterText;
    private Text ignoredRowsText;
    private Text quotedCharText;
    private Button quoted;
    private ScrolledComposite display;
    private Composite displayWrapper;
    private final IMuleProject muleProject;
    private Map<String, List<String>> sampleData;

    public LoadFromExampleDialog(Shell parent, IMuleProject muleProject) {
        super(parent);
        this.muleProject = muleProject;
        this.setShellStyle(0x10000000);
        this.fields = new ArrayList<String>();
        this.sampleData = new HashMap<String, List<String>>();
    }

    public void create() {
        super.create();
        this.setTitle(DIALOG_TITLE);
        this.setMessage(DEFAULT_MESSAGE);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        Composite wrapper = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        Label fileLabel = new Label(wrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)fileLabel);
        fileLabel.setText("Example");
        Composite filePathWrapper = new Composite(wrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filePathWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filePathWrapper);
        this.filePath = new Text(filePathWrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filePath);
        this.filePath.setMessage("Select your CSV example file");
        this.filePath.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoadFromExampleDialog.this.setSelectedFilePath(LoadFromExampleDialog.this.getFilePath());
                LoadFromExampleDialog.this.updateDelimiter();
            }
        }, (Control)container));
        Button openSchemaButton = new Button(filePathWrapper, 8);
        GridDataFactory.fillDefaults().applyTo((Control)openSchemaButton);
        openSchemaButton.setText("...");
        openSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(LoadFromExampleDialog.this.getShell(), 4096);
                fd.setFilterPath(LoadFromExampleDialog.this.muleProject.getLocation().toFile().getAbsolutePath());
                fd.setText("Select CSV example");
                fd.setFilterExtensions(new String[]{"*.*"});
                String selectedPath = fd.open();
                if (StringUtils.isNotBlank((String)selectedPath)) {
                    LoadFromExampleDialog.this.filePath.setText(selectedPath);
                }
            }
        });
        Label ignoredRowsLabel = new Label(wrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)ignoredRowsLabel);
        ignoredRowsLabel.setText("Ignored Rows");
        this.ignoredRowsText = new Text(wrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.ignoredRowsText);
        this.ignoredRowsText.setMessage("Set number of rows to be ignored. Default is 0.");
        this.ignoredRowsText.setText("0");
        this.ignoredRowsText.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoadFromExampleDialog.this.updateDelimiter();
            }
        }, (Control)container));
        Label delimiterLabel = new Label(wrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)delimiterLabel);
        delimiterLabel.setText("Delimiter");
        this.delimiterText = new Text(wrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.delimiterText);
        this.delimiterText.setMessage("Set the csv delimiter. Default is ','");
        this.delimiterText.setText(",");
        IdleModifyEventListener fieldsUpdateListener = new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoadFromExampleDialog.this.updateFields();
            }
        }, (Control)container);
        this.delimiterText.addModifyListener((ModifyListener)fieldsUpdateListener);
        Label quotedLabel = new Label(wrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)quotedLabel);
        quotedLabel.setText("Quoted Fields");
        this.quoted = new Button(wrapper, 32);
        this.quoted.setToolTipText("Check if data is quoted");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.quoted);
        this.quoted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadFromExampleDialog.this.quotedCharText.setEnabled(LoadFromExampleDialog.this.quoted.getSelection());
                LoadFromExampleDialog.this.updateFields();
            }
        });
        Label quotedCharLabel = new Label(wrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)quotedCharLabel);
        quotedCharLabel.setText("Quote char");
        this.quotedCharText = new Text(wrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.quotedCharText);
        this.quotedCharText.setMessage("Set quote char. Default is \".");
        this.quotedCharText.setText("\"");
        this.quotedCharText.setEnabled(false);
        this.quotedCharText.addModifyListener((ModifyListener)fieldsUpdateListener);
        Label separator = new Label(wrapper, 258);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)separator);
        Label displayLabel = new Label(wrapper, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)displayLabel);
        displayLabel.setText("Configuration preview");
        this.displayWrapper = new Composite(wrapper, 2048);
        GridLayoutFactory.fillDefaults().applyTo(this.displayWrapper);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.displayWrapper);
        return container;
    }

    protected void okPressed() {
        if (!this.fields.isEmpty()) {
            this.setRowsToIgnoreQty(this.getRowsToIgnore());
            this.setQuoteCharacter(this.getQuotedChar());
            this.setDelimiterChar(this.getDelimiter());
            this.setQuotedStr(this.isQuotedStrings());
            super.okPressed();
        }
    }

    private void updateDelimiter() {
        if (StringUtils.isNotBlank((String)this.getFilePath())) {
            try {
                DelimiterHeuristic finder = new DelimiterHeuristic(this.getFilePath(), this.getRowsToIgnore(), this.muleProject);
                String delimiter = finder.analyze();
                this.delimiterText.setText(StringEscapeUtils.escapeJava((String)delimiter));
                this.setMessage(DEFAULT_MESSAGE);
            }
            catch (Exception e) {
                this.setMessage("Error: " + e.getMessage(), 3);
            }
        } else {
            this.setMessage(DEFAULT_MESSAGE);
        }
    }

    private void updateFields() {
        if (StringUtils.isNotBlank((String)this.getFilePath())) {
            try {
                FlatFileAnalyzer analyzer = new FlatFileAnalyzer(this.getFilePath(), this.getRowsToIgnore(), this.isQuotedStrings(), this.getQuotedChar(), this.getDelimiter(), this.muleProject);
                this.fields = analyzer.analyze();
                this.sampleData = this.loadSampleData(this.fields);
                this.updateDisplay();
                this.setMessage(DEFAULT_MESSAGE);
            }
            catch (Exception e) {
                this.setMessage("Error: " + e.getMessage(), 3);
            }
        } else {
            this.setMessage(DEFAULT_MESSAGE);
        }
    }

    private Map<String, List<String>> loadSampleData(List<String> fields) {
        HashMap<String, List<String>> response = new HashMap<String, List<String>>(fields.size());
        for (String field : fields) {
            response.put(field, new ArrayList(5));
        }
        int i = 1;
        while (i < 6) {
            FlatFileAnalyzer analyzer = new FlatFileAnalyzer(this.getFilePath(), this.getRowsToIgnore() + i, this.isQuotedStrings(), this.getQuotedChar(), this.getDelimiter(), this.muleProject);
            try {
                List<String> analyze = analyzer.analyze();
                if (!analyze.isEmpty() && analyze.size() == fields.size()) {
                    int j = 0;
                    while (j < analyze.size()) {
                        ((List)response.get(fields.get(j))).add(analyze.get(j));
                        ++j;
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return response;
    }

    private void updateDisplay() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.dispose();
        }
        this.display = new ScrolledComposite(this.displayWrapper, 768);
        this.display.setExpandHorizontal(true);
        this.display.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.display);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.display);
        Composite wrapper = new Composite((Composite)this.display, 0);
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)wrapper);
        this.createTableViewer(wrapper);
        this.display.setContent((Control)wrapper);
        this.displayWrapper.layout(true, true);
    }

    private void createTableViewer(Composite parent) {
        TableViewer sampleTableViewer = new TableViewer(parent, 2050);
        this.createColumns(parent, sampleTableViewer);
        Table table = sampleTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        sampleTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        sampleTableViewer.setInput((Object)new Integer[]{0, 1, 2, 3, 4, 5});
        GridLayoutFactory.fillDefaults().applyTo((Composite)table);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)table);
    }

    private void createColumns(Composite parent, TableViewer sampleTableViewer) {
        for (final String field : this.fields) {
            TableViewerColumn col = this.createTableViewerColumn(sampleTableViewer, field, 100);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    List<String> list;
                    if (!LoadFromExampleDialog.this.sampleData.isEmpty() && (list = LoadFromExampleDialog.this.sampleData.get(field)) != null && !list.isEmpty()) {
                        Integer index = (Integer)element;
                        return index < list.size() ? list.get(index) : "";
                    }
                    return field + "_" + String.valueOf(element);
                }
            });
        }
    }

    private TableViewerColumn createTableViewerColumn(TableViewer sampleTableViewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(sampleTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private String getDelimiter() {
        String delimiter = StringEscapeUtils.unescapeJava((String)this.delimiterText.getText());
        return StringUtils.isNotEmpty((String)delimiter) ? delimiter : ",";
    }

    private char getQuotedChar() {
        String quotedChar = this.quotedCharText.getText();
        return StringUtils.isNotEmpty((String)quotedChar) ? quotedChar.toCharArray()[0] : (char)'\"';
    }

    private boolean isQuotedStrings() {
        return this.quoted.getSelection();
    }

    private int getRowsToIgnore() {
        try {
            String ignoredRows = this.ignoredRowsText.getText();
            return StringUtils.isNotBlank((String)ignoredRows) ? Integer.valueOf(ignoredRows) : 0;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Ignored Rows is invalid", e);
        }
    }

    private String getFilePath() {
        return this.filePath.getText();
    }

    public List<String> getFields() {
        return this.fields;
    }

    protected Point getInitialSize() {
        if (OsDetect.getOperatingSystemType() == OsDetect.OsType.Windows) {
            return new Point(550, 600);
        }
        return new Point(520, 480);
    }

    public boolean isHelpAvailable() {
        return false;
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public void setSelectedFilePath(String selectedFilePath) {
        this.selectedFilePath = selectedFilePath;
    }

    public int getRowsToIgnoreQty() {
        return this.rowsToIgnoreQty;
    }

    public void setRowsToIgnoreQty(int rowsToIgnoreQty) {
        this.rowsToIgnoreQty = rowsToIgnoreQty;
    }

    public char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public String getDelimiterChar() {
        return this.delimiterChar;
    }

    public void setDelimiterChar(String delimiterChar) {
        this.delimiterChar = delimiterChar;
    }

    public boolean isQuotedStr() {
        return this.quotedStr;
    }

    public void setQuotedStr(boolean quotedStr) {
        this.quotedStr = quotedStr;
    }
}

