/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.QuotingDecoder;

public class FlatFileAnalyzer {
    private static final int INTERNAL_BUFFER_LENGTH = 8192;
    private final File file;
    private final String delimiter;
    private final int rowsToIgnore;
    private final boolean quotedStrings;
    private final char quoteChar;

    public FlatFileAnalyzer(String filePath, int rowsToIgnore, boolean quotedStrings, char quoteChar, String delimiter, IMuleProject project) {
        this.file = CoreUtils.pathToFile((String)filePath, (IMuleProject)project);
        this.rowsToIgnore = rowsToIgnore;
        this.quotedStrings = quotedStrings;
        this.quoteChar = quoteChar;
        this.delimiter = delimiter;
    }

    public List<String> analyze() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            int i = 0;
            while (i < this.rowsToIgnore) {
                String ignoredLine = reader.readLine();
                if (ignoredLine == null) {
                    throw new IllegalArgumentException("Ignored rows exceed file length");
                }
                ++i;
            }
            StringBuffer header = this.retrieveHeaderRow(reader);
            return this.analyzeDelimited(header);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private StringBuffer retrieveHeaderRow(BufferedReader reader) throws IOException {
        QuotingDecoder quoteDecoder = null;
        if (this.quotedStrings) {
            quoteDecoder = new QuotingDecoder();
            quoteDecoder.setQuoteChar(Character.valueOf(this.quoteChar));
        }
        char[] buf = new char[8192];
        StringBuffer header = new StringBuffer();
        boolean inQuote = false;
        boolean headerEnded = false;
        while (!headerEnded && reader.read(buf) != -1) {
            int recordDelimPosition = 0;
            while (recordDelimPosition < buf.length && !headerEnded) {
                char character = buf[recordDelimPosition];
                if (quoteDecoder != null) {
                    if (inQuote) {
                        header.append(character);
                        if (quoteDecoder.isEndQuote(character)) {
                            if (recordDelimPosition + 1 < buf.length && quoteDecoder.isEndQuote(buf[recordDelimPosition + 1])) {
                                header.append(buf[recordDelimPosition + 1]);
                                ++recordDelimPosition;
                            } else {
                                inQuote = false;
                            }
                        }
                        ++recordDelimPosition;
                        continue;
                    }
                    if (quoteDecoder.isStartQuote(character)) {
                        header.append(character);
                        inQuote = true;
                        ++recordDelimPosition;
                        continue;
                    }
                }
                switch (character) {
                    case '\n': 
                    case '\r': {
                        headerEnded = true;
                        break;
                    }
                    default: {
                        header.append(character);
                        ++recordDelimPosition;
                    }
                }
            }
        }
        return header;
    }

    private List<String> analyzeDelimited(StringBuffer inputLine) {
        QuotingDecoder quoteDecoder = null;
        if (this.quotedStrings) {
            quoteDecoder = new QuotingDecoder();
            quoteDecoder.setQuoteChar(Character.valueOf(this.quoteChar));
        }
        CharSequence[] parsedLine = this.parseDelimited(inputLine.toString(), quoteDecoder);
        ArrayList<String> fields = new ArrayList<String>();
        int i = 0;
        while (i < parsedLine.length) {
            fields.add(parsedLine[i].toString());
            ++i;
        }
        return fields;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private CharSequence[] parseDelimited(String lineToParse, QuotingDecoder quoteDecoder) {
        output = new ArrayList<String>();
        if (StringUtils.isEmpty((String)this.delimiter)) {
            return new String[]{lineToParse};
        }
        indexAfterLastDelimiter = 0;
        inQuote = false;
        i = 0;
        while (i <= lineToParse.length() - this.delimiter.length()) {
            if (quoteDecoder == null) ** GOTO lbl-1000
            if (inQuote) {
                if (quoteDecoder.isEndQuote(lineToParse.charAt(i))) {
                    if (i + 1 < lineToParse.length() && quoteDecoder.isEndQuote(lineToParse.charAt(i + 1))) {
                        ++i;
                    } else {
                        inQuote = false;
                    }
                }
            } else if (quoteDecoder.isStartQuote(lineToParse.charAt(i))) {
                inQuote = true;
            } else if (this.delimiter.equals(lineToParse.substring(i, i + this.delimiter.length()))) {
                s /* !! */  = lineToParse.substring(indexAfterLastDelimiter, i);
                if (quoteDecoder != null) {
                    s /* !! */  = quoteDecoder.decode(s /* !! */ );
                }
                output.add(s /* !! */ );
                indexAfterLastDelimiter = (i += this.delimiter.length() - 1) + 1;
            }
            ++i;
        }
        if (indexAfterLastDelimiter < lineToParse.length() + 1) {
            s /* !! */  = lineToParse.substring(indexAfterLastDelimiter, lineToParse.length());
            if (quoteDecoder != null) {
                s /* !! */  = quoteDecoder.decode(s /* !! */ );
            }
            output.add(s /* !! */ );
        }
        return output.toArray(new CharSequence[0]);
    }
}

