/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;

public class DelimiterHeuristic {
    private static final String[] COMMON_DELIMITERS = new String[]{",", ";", ":", "|", "#", "\t", ".", "^"};
    private final int rowsToIgnore;
    private final File file;

    public DelimiterHeuristic(String filePath, int rowsToIgnore, IMuleProject project) {
        this.rowsToIgnore = rowsToIgnore;
        this.file = CoreUtils.pathToFile((String)filePath, (IMuleProject)project);
    }

    public String analyze() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
            String additionalLine;
            int i = 0;
            while (i < this.rowsToIgnore) {
                String ignoredLine = bufferedReader.readLine();
                if (ignoredLine == null) {
                    throw new IllegalArgumentException("Ignored rows exceed file lenght");
                }
                ++i;
            }
            String header = bufferedReader.readLine();
            if (header == null) {
                throw new IllegalArgumentException("Ignored rows exceed file lenght");
            }
            ArrayList<String> linesToValidate = new ArrayList<String>();
            int lineNumber = 0;
            while (lineNumber < 5 && (additionalLine = bufferedReader.readLine()) != null) {
                if (!StringUtils.isNotEmpty((String)additionalLine)) continue;
                linesToValidate.add(additionalLine);
                ++lineNumber;
            }
            return this.analyze(header, linesToValidate);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String analyze(String header, List<String> linesToValidate) {
        String result = COMMON_DELIMITERS[0];
        String[] stringArray = COMMON_DELIMITERS;
        int n = COMMON_DELIMITERS.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            int occurence = 0;
            if (header.contains(delimiter)) {
                boolean found = true;
                occurence = header.split(Pattern.quote(delimiter)).length;
                for (String line : linesToValidate) {
                    if (line.split(Pattern.quote(delimiter)).length - 1 == occurence) continue;
                    found = false;
                    break;
                }
                if (found) {
                    result = delimiter;
                    break;
                }
            }
            ++n2;
        }
        return result;
    }
}

