/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom.csv;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.TreeViewer;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.CSVElement;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.CSVTreeEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.csv.LoadFromExampleDialog;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.CSVTypesManager;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.treetable.IActionHandler;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TypesManager;

public class CSVTreeEditorPresenter<T extends CSVTreeEditor, Y>
extends TypedTreeEditorPresenter<T, Y> {
    public static final String DEFAULT_COLUMN_PREFIX = "column_";
    private IMuleProject project;
    private String exampleFilePath;
    private int rowsToIgnore = 0;
    private boolean quotedString;
    private String delimiter;
    private String quoteChar;
    private boolean canEditElementName = true;

    public CSVTreeEditorPresenter(TypesManager<Y> manager, IMuleProject project) {
        super(manager);
        this.project = project;
    }

    protected boolean canEditElementName() {
        return this.canEditElementName;
    }

    public void loadValues(MetadataType metadataType) {
        if (metadataType instanceof ArrayType) {
            metadataType = ((ArrayType)metadataType).getType();
        }
        if (metadataType instanceof ObjectType) {
            Collection fields = ((ObjectType)metadataType).getFields();
            ArrayList<CSVElement<MetadataType>> newElements = new ArrayList<CSVElement<MetadataType>>();
            for (ObjectFieldType field : fields) {
                QName fieldName = field.getKey().getName();
                MetadataType fieldMetadataType = field.getValue();
                ContentType<MetadataType> contentType = ((CSVTypesManager)this.getManager()).getTypeFromParameterType(fieldMetadataType);
                newElements.add(new CSVElement<MetadataType>(fieldName, contentType));
            }
            this.getElements().clear();
            this.getElements().addAll(newElements);
        }
    }

    protected void setActions(T editor, TreeViewer treeViewer) {
        super.setActions(editor, treeViewer);
        ((CSVTreeEditor)((Object)editor)).setLoadFromFile(this.createLoadFromFile(treeViewer));
    }

    protected TreeTableElement createElementToAdd(String name) {
        return new CSVElement(new QName(name), (ContentType)this.getManager().getTypes().get(0));
    }

    protected IActionHandler createAddAction(TreeViewer treeViewer) {
        return super.doCreateAddAction(treeViewer, DEFAULT_COLUMN_PREFIX);
    }

    private IActionHandler createLoadFromFile(final TreeViewer treeViewer) {
        return new IActionHandler(){

            public void onActionPerform() {
                LoadFromExampleDialog dialog = new LoadFromExampleDialog(treeViewer.getControl().getShell(), CSVTreeEditorPresenter.this.project);
                if (dialog.open() == 0) {
                    List<String> fields = dialog.getFields();
                    CSVTreeEditorPresenter.this.setExampleFilePath(dialog.getSelectedFilePath());
                    CSVTreeEditorPresenter.this.setRowsToIgnore(dialog.getRowsToIgnoreQty());
                    CSVTreeEditorPresenter.this.setQuotedString(dialog.isQuotedStr());
                    CSVTreeEditorPresenter.this.setDelimiter(dialog.getDelimiterChar());
                    CSVTreeEditorPresenter.this.setQuoteChar(Character.toString(dialog.getQuoteCharacter()));
                    CSVTreeEditorPresenter.this.loadFieldsInTreeTable(fields, treeViewer);
                }
            }
        };
    }

    public void loadFieldsInTreeTable(List<String> fields, TreeViewer treeViewer) {
        if (!fields.isEmpty()) {
            ArrayList newElements = new ArrayList(fields.size());
            for (String fieldName : fields) {
                newElements.add(new CSVElement(new QName(CharMatcher.is((char)'\"').trimFrom((CharSequence)fieldName)), this.getManager().getType("string")));
            }
            this.getElements().clear();
            this.getElements().addAll(newElements);
            this.reload(treeViewer);
            treeViewer.expandToLevel(2);
            this.notify(TreeTableEditorPresenter.EditorActions.ADD);
        }
    }

    public void resetColumnNames(TreeViewer treeViewer) {
        List elements = this.getElements();
        int index = 0;
        for (TreeTableElement treeTableElement : elements) {
            TypedTableElement field = (TypedTableElement)treeTableElement;
            field.setName(DEFAULT_COLUMN_PREFIX + index);
            ++index;
        }
        this.reload(treeViewer);
        treeViewer.expandToLevel(2);
        this.notify(TreeTableEditorPresenter.EditorActions.ADD);
    }

    public boolean isCanEditElementName() {
        return this.canEditElementName;
    }

    public void setCanEditElementName(boolean canEditElementName) {
        this.canEditElementName = canEditElementName;
    }

    public String getExampleFilePath() {
        return this.exampleFilePath;
    }

    public void setExampleFilePath(String exampleFilePath) {
        this.exampleFilePath = exampleFilePath;
    }

    public int getRowsToIgnore() {
        return this.rowsToIgnore;
    }

    public void setRowsToIgnore(int rowsToIgnore) {
        this.rowsToIgnore = rowsToIgnore;
    }

    public boolean isQuotedString() {
        return this.quotedString;
    }

    public void setQuotedString(boolean quotedString) {
        this.quotedString = quotedString;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(String quotedChar) {
        this.quoteChar = quotedChar;
    }
}

