/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom;

import java.text.MessageFormat;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;

public class CustomMetadataValidator
implements IMetadataDefinitionValidator {
    private static final String MESSAGE_DUPLICATE_KEY = "The key {0} already exists in the project";
    private static final String MESSAGE_INVALID_CHARS = "Metadata key can only start with alpha characters and contain alphanumeric characters, underscores and hyphens.";
    private static final String MESSAGE_EMPTY_KEY = "Metadata key cannot be empty";
    private static final String MESSAGE_EMPTY_NAMED_KEY = "{0} cannot be empty";
    private static final String NUMBERS = "0-9";
    private static final String HYPHEN_UNDERSCORE = "-_";
    private static final String LOWERCASE_LETTERS = "a-z";
    private static final String UPPERCASE_LETTERS = "A-Z";
    private static final String CUSTOM_METADATA_KEY_REGEX = "^[a-zA-Z][a-zA-Z0-9-_]*$";
    private IMuleProject muleProject;
    private Optional<String> editedKey;

    public CustomMetadataValidator(IMuleProject muleProject) {
        this(muleProject, null);
    }

    public CustomMetadataValidator(IMuleProject muleProject, String editedKey) {
        this.muleProject = muleProject;
        this.editedKey = Optional.ofNullable(editedKey);
    }

    @Override
    public String getValidationMessage(String component, String key, String keyName) {
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)component)) {
            return StringUtils.isNotEmpty((String)keyName) ? MessageFormat.format(MESSAGE_EMPTY_NAMED_KEY, keyName) : MESSAGE_EMPTY_KEY;
        }
        if (!Pattern.matches(CUSTOM_METADATA_KEY_REGEX, key)) {
            return MESSAGE_INVALID_CHARS;
        }
        if (this.isKeyInCache(component, key)) {
            return MessageFormat.format(MESSAGE_DUPLICATE_KEY, key);
        }
        return null;
    }

    @Override
    public boolean isValidKey(String type, String key) {
        return this.getValidationMessage(type, key, null) == null;
    }

    @Override
    public boolean isValidMetadata(MetadataResult metadata) {
        return metadata.isValid() && !MetadataFactory.isUndefined((MetadataType)metadata.getMetadataType());
    }

    @Override
    public boolean requiredSave() {
        return true;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    @Override
    public void setEditedKey(String editedKey) {
        this.editedKey = Optional.ofNullable(editedKey);
    }

    private ITypesManager getTypesManager() {
        return ((MetadataTypesManager)this.getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }

    private boolean isKeyInCache(String component, String key) {
        if (this.editedKey.isPresent() && this.editedKey.get().equals(key)) {
            return false;
        }
        return this.getTypesManager().hasMetadataKey(component, "#Default Category#", ToolingMetadataKeyBuilder.newKey((String)key).build());
    }
}

