/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition.custom;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.ICustomMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.MetadataDefinitionManager;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.extensions.MetadataDefinitionType;

public class CustomMetadataEditor
extends Composite
implements IMetadataDefinitionEditor {
    private IMuleProject muleProject;
    private Group customEditorWrapper;
    private ICustomMetadataDefinitionEditor contentEditor;
    private IMetadataDefinitionValidator editorValidator;
    private final OnValidationMessage onValidationMessage;
    private final ChangeManager changeManager;
    private String editedKey;
    private Combo typeCombo;

    public CustomMetadataEditor(Composite parent, IMuleProject muleProject, OnValidationMessage onValidationMessage, ChangeManager changeManager, IMetadataDefinitionValidator editorValidator, String key) {
        super(parent, 0);
        this.muleProject = muleProject;
        this.changeManager = changeManager;
        this.editedKey = key;
        this.editorValidator = editorValidator;
        this.onValidationMessage = onValidationMessage;
        this.createControls(this);
    }

    private Composite createControls(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        Label rootLabel = new Label(wrapper, 0);
        GridDataFactory.swtDefaults().applyTo((Control)rootLabel);
        rootLabel.setText("Type");
        this.typeCombo = new Combo(wrapper, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.typeCombo);
        this.fillTypes(this.typeCombo);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomMetadataEditor.this.cleanEditorWrapper();
                String selectedType = CustomMetadataEditor.this.typeCombo.getText();
                MetadataDefinitionType type = MetadataDefinitionManager.fromLabel(selectedType);
                CustomMetadataEditor.this.contentEditor = type.getEditorFactory().create((Composite)CustomMetadataEditor.this.customEditorWrapper, CustomMetadataEditor.this.getMuleProject(), CustomMetadataEditor.this.editorValidator, CustomMetadataEditor.this.changeManager, CustomMetadataEditor.this.editedKey, CustomMetadataEditor.this.onValidationMessage);
                CustomMetadataEditor.this.customEditorWrapper.layout(true);
                CustomMetadataEditor.this.validate();
                if (CustomMetadataEditor.this.changeManager != null) {
                    CustomMetadataEditor.this.changeManager.change();
                }
            }
        });
        this.customEditorWrapper = new Group(wrapper, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.customEditorWrapper);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.customEditorWrapper);
        if (StringUtils.isEmpty((String)this.editedKey)) {
            MetadataDefinitionType type = MetadataDefinitionManager.fromLabel("Simple type");
            this.selectCorrectComboOption(this.typeCombo, type);
            this.contentEditor = type.getEditorFactory().create((Composite)this.customEditorWrapper, this.getMuleProject(), this.editorValidator, this.changeManager, this.editedKey, this.onValidationMessage);
        } else {
            this.loadEditingConfiguration();
        }
        this.customEditorWrapper.layout(true);
        return wrapper;
    }

    private void loadEditingConfiguration() {
        ITypesManager typesManager = ((MetadataTypesManager)this.getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
        MetadataType customMetadataModel = typesManager.getCustomMetadataType(ToolingMetadataKeyBuilder.newKey((String)this.editedKey).build());
        MetadataDefinitionType correctType = MetadataDefinitionManager.fromMetadata(customMetadataModel);
        this.cleanEditorWrapper();
        this.selectCorrectComboOption(this.typeCombo, correctType);
        this.contentEditor = correctType.getEditorFactory().create((Composite)this.customEditorWrapper, this.getMuleProject(), this.editorValidator, this.changeManager, this.editedKey, this.onValidationMessage);
        this.customEditorWrapper.layout(true);
        this.validate();
    }

    private void selectCorrectComboOption(Combo typesCombo, MetadataDefinitionType type) {
        int i = 0;
        while (i < typesCombo.getItems().length) {
            String item = typesCombo.getItem(i);
            if (StringUtils.equals((String)item, (String)type.getLabel())) {
                typesCombo.select(i);
                break;
            }
            ++i;
        }
    }

    private void fillTypes(Combo rootElement) {
        for (MetadataDefinitionType type : MetadataDefinitionManager.values()) {
            rootElement.add(type.getLabel());
        }
    }

    private void cleanEditorWrapper() {
        Control[] children;
        if (this.customEditorWrapper.isDisposed()) {
            return;
        }
        Control[] controlArray = children = this.customEditorWrapper.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.dispose();
            }
            ++n2;
        }
        this.customEditorWrapper.layout(true);
    }

    private IMuleProject getMuleProject() {
        return this.muleProject;
    }

    @Override
    public MetadataResult getResult() {
        MetadataResult result = this.contentEditor.getMetadata();
        result.setModule("#Custom Type#");
        result.setKey(this.contentEditor.getKey());
        return result;
    }

    @Override
    public IMetadataDefinitionValidator getValidator() {
        return this.editorValidator;
    }

    @Override
    public void validate() {
        this.contentEditor.validate();
    }

    public void setEditingKey(String editedKey) {
        this.editedKey = editedKey;
        this.editorValidator.setEditedKey(editedKey);
        this.loadEditingConfiguration();
    }

    public boolean setFocus() {
        return this.typeCombo.setFocus();
    }

    @Override
    public void applyChanges() {
        if (this.contentEditor != null) {
            this.contentEditor.applyChanges();
        }
    }

    @Override
    public void onRefresh() {
        if (this.contentEditor != null) {
            this.contentEditor.onRefresh();
        }
    }
}

