/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition;

import com.google.common.base.Strings;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IDataSenseTypeChangedListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.metadata.definition.AbstractDynamicContent;
import org.mule.tooling.ui.modules.core.metadata.definition.IDefinitionChangedListener;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardDialog;
import org.mule.tooling.ui.widgets.dynamic.table.TablePersistenceStrategy;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class VariablesMetadataEditor
extends AbstractDynamicContent {
    private String variableName = "";
    private Composite editorWrapper;
    private Text nameText;
    protected boolean loading;
    private EventBusHelper eventBusHelper;

    public VariablesMetadataEditor(IMuleProject muleProject, EventBus eventBus) {
        super(muleProject, eventBus);
    }

    public void createControls(Composite parent) {
        this.container = parent;
        this.editorWrapper = new Composite(this.container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(this.editorWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.editorWrapper);
        Composite nameWrapper = new Composite(this.editorWrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(nameWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameWrapper);
        Label nameLabel = new Label(nameWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)nameLabel);
        nameLabel.setText("name:");
        this.nameText = new Text(nameWrapper, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.setMessage("set property name");
        this.nameText.addModifyListener((ModifyListener)new IdleModifyEventListener((ModifyListener)new NameChangeListener(), (Control)this.container));
        Composite metadataWrapper = new Composite(this.editorWrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(metadataWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)metadataWrapper);
        this.selectedStructureLabel = new CLabel(metadataWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.selectedStructureLabel);
        this.selectedStructureLabel.setText("Unknown");
        ToolBar fieldToolBar = new ToolBar(metadataWrapper, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(1, 0x1000000).applyTo((Control)fieldToolBar);
        ToolBarManager fieldTBManager = new ToolBarManager(fieldToolBar);
        SelectMetadataAction add = new SelectMetadataAction();
        fieldTBManager.add((IAction)add);
        fieldTBManager.update(true);
        this.eventBusHelper = new EventBusHelper();
        this.eventBusHelper.registerUIListener(this.eventBus, CoreEventTypes.ON_DATASENSE_TYPE_CHANGE_EVENT, (IEventHandler)new IDataSenseTypeChangedListener(){

            public void onDataSenseTypesChanged(IMuleProject project) {
                VariablesMetadataEditor.this.updateLabel();
            }
        });
        this.editorWrapper.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VariablesMetadataEditor.this.eventBusHelper.unregister();
            }
        });
    }

    public TablePersistenceStrategy<MetadataDefinitionConfiguration> getPersistenceStrategy() {
        return new VariablesPersistenceStrategy();
    }

    private void notifyDefinitionChange() {
        this.eventBus.fireEvent((IEvent)new IEvent<IDefinitionChangedListener>(){

            public EventType<IDefinitionChangedListener> getAssociatedType() {
                return IDefinitionChangedListener.ON_DEFINITION_CHANGE;
            }

            public void dispatch(IDefinitionChangedListener handler) {
                handler.contentChange();
            }
        });
    }

    private final class NameChangeListener
    implements ModifyListener {
        private NameChangeListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!VariablesMetadataEditor.this.nameText.isDisposed() && !StringUtils.equals((String)VariablesMetadataEditor.this.variableName, (String)VariablesMetadataEditor.this.nameText.getText())) {
                VariablesMetadataEditor.this.variableName = VariablesMetadataEditor.this.nameText.getText();
                if (!VariablesMetadataEditor.this.loading) {
                    VariablesMetadataEditor.this.notifyDefinitionChange();
                }
            }
        }
    }

    private class SelectMetadataAction
    extends Action {
        public SelectMetadataAction() {
            this.setImageDescriptor(MuleImages.DESC_EDIT);
            this.setText("edit");
        }

        public void run() {
            MetadataDefinitionWizard wizard = new MetadataDefinitionWizard(VariablesMetadataEditor.this.getMuleProject());
            Shell activeShell = Display.getCurrent().getActiveShell();
            MetadataDefinitionWizardDialog dialog = new MetadataDefinitionWizardDialog(activeShell, wizard);
            if (dialog.open() == 0) {
                VariablesMetadataEditor.this.metadataResult = wizard.getResult();
                VariablesMetadataEditor.this.updateLabel();
                VariablesMetadataEditor.this.notifyDefinitionChange();
            }
        }
    }

    private class VariablesPersistenceStrategy
    implements TablePersistenceStrategy<MetadataDefinitionConfiguration> {
        private VariablesPersistenceStrategy() {
        }

        public MetadataDefinitionConfiguration save() {
            MetadataDefinitionConfiguration configuration = new MetadataDefinitionConfiguration();
            configuration.setKey(VariablesMetadataEditor.this.metadataResult.getKey());
            configuration.setModule(VariablesMetadataEditor.this.metadataResult.getModule());
            configuration.setVariableName(Strings.nullToEmpty((String)VariablesMetadataEditor.this.variableName));
            configuration.setCollection(VariablesMetadataEditor.this.metadataResult.isCollection());
            return configuration;
        }

        public void load(MetadataDefinitionConfiguration parameters) {
            VariablesMetadataEditor.this.loading = true;
            VariablesMetadataEditor.this.metadataResult.setKey(parameters.getKey());
            VariablesMetadataEditor.this.metadataResult.setModule(parameters.getModule());
            VariablesMetadataEditor.this.metadataResult.setIsCollection(parameters.isCollection());
            VariablesMetadataEditor.this.variableName = parameters.getVariableName();
            VariablesMetadataEditor.this.nameText.setText(VariablesMetadataEditor.this.variableName);
            VariablesMetadataEditor.this.updateLabel();
            VariablesMetadataEditor.this.loading = false;
        }
    }
}

