/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.modules.core.metadata.definition.BaseMetadataDefinitionWizardPage;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionWizardCallback;
import org.mule.tooling.ui.modules.core.metadata.definition.selection.SelectMetadataEditor;
import org.mule.tooling.ui.modules.core.metadata.management.MetadataTypeTreeNodeModel;
import org.mule.tooling.ui.modules.core.metadata.typeSelection.TypeSelectionAdapter;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class MetadataDefinitionWizardPage
extends BaseMetadataDefinitionWizardPage {
    private static final String METADATA_DEFINITION_WIZARD_SHELL_CSS_ID = "org-mule-tooling-ui-modules-core-MetadataDefinitionWizardPage";
    private static final String METADATA_DEFINITION_WIZARD_COMPOSITE_CSS_ID = "metadataDefinitionWizard";

    public MetadataDefinitionWizardPage(IMuleProject muleProject, IMetadataDefinitionWizardCallback metadataDefinitionWizardCallback) {
        super(muleProject, metadataDefinitionWizardCallback);
    }

    public void createControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        Composite editorWrapper = new Composite(wrapper, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editorWrapper);
        GridLayoutFactory.fillDefaults().margins(10, 5).applyTo(editorWrapper);
        SelectMetadataEditor selectMetadataEditor = this.createSelectMetadataEditor(editorWrapper);
        this.setContentEditor(selectMetadataEditor);
        this.setControl((Control)wrapper);
        this.setPageComplete(false);
        ThemeUtils.setCssId((Object)wrapper, (String)METADATA_DEFINITION_WIZARD_COMPOSITE_CSS_ID);
        ThemeUtils.setCssId((Object)this.getShell(), (String)METADATA_DEFINITION_WIZARD_SHELL_CSS_ID);
    }

    private SelectMetadataEditor createSelectMetadataEditor(Composite parent) {
        final SelectMetadataEditor editor = new SelectMetadataEditor(parent, this.getMuleProject(), new BaseMetadataDefinitionWizardPage.WizardValidationMessage(this), this.getChangeManager());
        editor.addTypeSelectionListener(new TypeSelectionAdapter(){

            @Override
            public void typeSelected(ISelection iSelection) {
                boolean selected;
                boolean bl = selected = !iSelection.isEmpty();
                if (selected) {
                    TreeSelection selectedNode = (TreeSelection)iSelection;
                    GraphicalTreeNode element = (GraphicalTreeNode)selectedNode.getFirstElement();
                    MetadataTypeTreeNodeModel model = (MetadataTypeTreeNodeModel)element.getModel();
                    MetadataDefinitionWizardPage.this.setPageComplete(model.getMetadataType() != null);
                } else {
                    MetadataDefinitionWizardPage.this.setPageComplete(selected);
                }
            }

            @Override
            public void typeDoubleClicked(ISelection iSelection) {
                if (MetadataDefinitionWizardPage.this.validateCompletion(editor)) {
                    MetadataDefinitionWizardPage.this.setPageComplete(true);
                    if (MetadataDefinitionWizardPage.this.getMetadataDefinitionWizardCallback() != null) {
                        MetadataDefinitionWizardPage.this.getMetadataDefinitionWizardCallback().callback();
                    }
                }
            }
        });
        GridLayoutFactory.fillDefaults().applyTo((Composite)editor);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editor);
        return editor;
    }

    protected boolean validateCompletion(IMetadataDefinitionEditor editor) {
        return editor.getResult().getMetadataType() != null;
    }
}

