/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.CustomMetadataWizardPage;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionWizardCallback;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardPage;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;

public class MetadataDefinitionWizard
extends Wizard {
    protected IMuleProject muleProject;
    protected IMetadataDefinitionWizardCallback callback;
    private MetadataResult result;
    private MetadataKey metadaKey;

    public MetadataDefinitionWizard(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public void setCallback(IMetadataDefinitionWizardCallback callback) {
        this.callback = callback;
    }

    public void addPages() {
        this.addPage((IWizardPage)new MetadataDefinitionWizardPage(this.muleProject, this.callback));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        CustomMetadataWizardPage definitionPage = (CustomMetadataWizardPage)this.getPage("METADATA_DEFINITION_PAGE");
        try {
            MetadataResult metadata = definitionPage.getResult();
            IMetadataDefinitionValidator validator = definitionPage.getValidator();
            if (!validator.isValidKey(metadata.getModule(), metadata.getKey())) {
                this.setMessage(definitionPage, "Metadata key is not valid or is already used", 3);
                return false;
            }
            if (validator.isValidMetadata(metadata)) {
                this.result = metadata;
                this.metadaKey = ToolingMetadataKeyBuilder.newKey((String)metadata.getKey()).build();
                if (!validator.requiredSave()) return true;
                this.saveNewMetadataType(metadata, this.metadaKey);
                return true;
            }
            this.setMessage(definitionPage, metadata.getMessage(), 3);
            return false;
        }
        catch (Exception e) {
            this.setMessage(definitionPage, "Error generating metadata", 3);
            MuleCorePlugin.logError((String)"Error generating metadata", (Throwable)e);
        }
        return false;
    }

    protected void saveNewMetadataType(MetadataResult metadata, MetadataKey key) {
        this.getTypesManager().addCustomMetadata(key, metadata.getMetadataType());
    }

    private void setMessage(CustomMetadataWizardPage definitionPage, String string, int error) {
        definitionPage.setMessage(string, error);
    }

    public MetadataKey getMetadaKey() {
        return this.metadaKey;
    }

    protected ITypesManager getTypesManager() {
        return ((MetadataTypesManager)this.getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }

    public MetadataResult getResult() {
        return this.result;
    }

    private IMuleProject getMuleProject() {
        return this.muleProject;
    }
}

