/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEventEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataOperationEnricher;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMetadataDefinitionChangedListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectAware;
import org.mule.tooling.messageflow.dialog.ExportMetadataConfirmationDialog;
import org.mule.tooling.messageflow.dialog.ExportMetadataToFlowRefDialog;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.ICustomPageChangedListener;
import org.mule.tooling.messageflow.module.CustomPageComposite;
import org.mule.tooling.messageflow.module.ICustomPage;
import org.mule.tooling.messageflow.module.IMessageFlowNodeAware;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.definition.IDefinitionChangedListener;
import org.mule.tooling.ui.modules.core.metadata.definition.InboundEndpointFilter;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowTypesManager;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;
import org.mule.tooling.ui.modules.core.widgets.IErrorMappingChangedListener;
import org.mule.tooling.ui.widgets.IMessageLogger;
import org.mule.tooling.ui.widgets.dynamic.table.DefaultDynamicTable;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentType;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicRow;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManager;
import org.mule.tooling.ui.widgets.dynamic.table.events.ITableRowDeletedListener;
import org.mule.tooling.ui.widgets.errors.ErrorActionDialog;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MetadataDefinitionCustomPage
implements ICustomPage,
IMuleProjectAware,
IMessageFlowNodeAware {
    private static final String TITLE_LABEL = "Message Definitions";
    private static final String ADD_BUTTON_LABEL = "Add metadata";
    private static final String EMPTY_MESSAGE = "Define the types for your payload, variables and attributes.";
    private static final String DELETE_ALL_QUESTION = "Are you sure you want to delete all definitions?";
    private static final String DELETE_ALL_TITLE = "Delete all definitions";
    private IMuleProject muleProject;
    private EventBus eventBus = MuleCorePlugin.getEventBus();
    private EventBusHelper eventHelper = new EventBusHelper();
    private CustomPageComposite container;
    private DefaultDynamicTable table;
    private MessageRowTypesManager typesManager;
    private boolean loading;
    private ScrolledComposite scrolledComposite;
    private boolean loaded;
    private IMessageFlowNode node;
    private ExportMetadataToFlowRefDialog exportMetadataToFlowRefDialog = null;
    private ExportMetadataConfirmationDialog exportMetadataConfirmationDialog = null;
    private static final String TITLE = "Custom metadata";
    private static final String CONTENT = "We are setting up referenced flow's metadata with the metadata from the Flow Ref operation.";
    private static final String MORE_THAN_ONE_TITLE = "Error when propagating metadata";
    private static final String MORE_THAN_ONE_BODY = "There is more than one flow with the name %s, fix that in order to propagate.";
    private static final String SET_METADATA_LABEL = "Propagate this Flow Reference metadata to the referenced flow.";
    private static final String PROPAGATE_BUTTON_TEXT = "Set Metadata";
    private CustomMetadataAssistantService customMetadataAssistantService;
    private static final String MISSING_DOC_ID_WARNING = "doc:id required for propagation";
    private static final String NO_FLOW_DIALOG_TITLE = "Referenced flow error";
    private static final String NO_FLOW_DIALOG_BODY = "To set metadata to a flow reference, the flow reference cannot be empty and must exist";

    public CustomPageComposite createControl(Composite parent) {
        this.container = new CustomPageComposite(parent, 0);
        this.container.setData("ID", (Object)"MetadataTab");
        CTabFolder tabs = new CTabFolder((Composite)this.container, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tabs);
        CTabItem addMetadataItem = new CTabItem(tabs, 0);
        tabs.setSelection(addMetadataItem);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.container);
        Group containerGroupMetadata = new Group((Composite)tabs, 64);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)containerGroupMetadata);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)containerGroupMetadata);
        if (this.node.getType().equals("http://www.mulesoft.org/schema/mule/core/flow-ref")) {
            Group containerGroupPropagation = new Group((Composite)containerGroupMetadata, 64);
            GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)containerGroupPropagation);
            GridData groupData = GridDataFactory.fillDefaults().span(new Point(4, 1)).grab(true, false).create();
            containerGroupPropagation.setLayoutData((Object)groupData);
            Label explainationLabel = new Label((Composite)containerGroupPropagation, 64);
            GridData labelGridData = GridDataFactory.fillDefaults().grab(true, false).create();
            labelGridData.horizontalIndent = 7;
            explainationLabel.setLayoutData((Object)labelGridData);
            explainationLabel.setText(SET_METADATA_LABEL);
            this.customMetadataAssistantService = (CustomMetadataAssistantService)this.muleProject.getProjectComponent(CustomMetadataAssistantService.class);
            Composite propagationComposite = new Composite((Composite)containerGroupPropagation, 0);
            propagationComposite.setLayout((Layout)new RowLayout(256));
            Button setMetadataButton = new Button(propagationComposite, 0);
            setMetadataButton.setText(PROPAGATE_BUTTON_TEXT);
            if (!this.shouldPropagateMetadata()) {
                CLabel label = new CLabel(propagationComposite, 131072);
                label.setImage(ThemeUtils.getCurrentTheme().getInfoImageIcon());
                label.setText(MISSING_DOC_ID_WARNING);
                label.setToolTipText(MISSING_DOC_ID_WARNING);
                GridLayoutFactory.fillDefaults().margins(5, 0).applyTo((Composite)label);
            }
            setMetadataButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MetadataDefinitionCustomPage.this.handleClick(event);
                }
            });
        }
        Group containerGroupAddMetadata = new Group((Composite)containerGroupMetadata, 0);
        GridLayoutFactory.fillDefaults().margins(5, 0).applyTo((Composite)containerGroupAddMetadata);
        GridData addMetadataGroupData = GridDataFactory.fillDefaults().span(new Point(2, 1)).grab(true, true).create();
        containerGroupAddMetadata.setLayoutData((Object)addMetadataGroupData);
        this.scrolledComposite = new ScrolledComposite((Composite)containerGroupAddMetadata, 768);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.scrolledComposite);
        Composite wrapper = new Composite((Composite)this.scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)wrapper);
        this.createTable(wrapper);
        this.addListeners(wrapper);
        addMetadataItem.setText(ADD_BUTTON_LABEL);
        addMetadataItem.setControl((Control)containerGroupMetadata);
        Point panelSize = wrapper.computeSize(-1, -1);
        this.scrolledComposite.setContent((Control)wrapper);
        this.scrolledComposite.setMinSize(-1, panelSize.y);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        return this.container;
    }

    private void createTable(Composite parent) {
        this.table = new DefaultDynamicTable(parent, this.eventBus);
        this.table.setEditorTitle(TITLE_LABEL);
        this.table.setAddButtonLabel(ADD_BUTTON_LABEL);
        this.table.setEmptyMessage(EMPTY_MESSAGE);
        this.table.setDeleteAllQuestion(DELETE_ALL_QUESTION);
        this.table.setDeleteAllTitle(DELETE_ALL_TITLE);
        this.table.setUseLeftAlignmentInText(Boolean.TRUE);
        this.typesManager = new MessageRowTypesManager(this.muleProject, this.eventBus);
        if (MessageFlowUtils.isInboundEndpoint((IMessageFlowNode)this.getNode())) {
            this.typesManager.addFilter(new InboundEndpointFilter());
        }
        this.table.setTypesManager((TypesManager)this.typesManager);
        this.table.setCreateTitle(false);
        this.table.createControls();
        GridLayoutFactory.fillDefaults().extendedMargins(0, 10, 0, 0).applyTo((Composite)this.table);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
    }

    private void addListeners(final Composite containerGroup) {
        this.eventHelper.registerListener(this.eventBus, IErrorMappingChangedListener.ON_ERROR_MAPPING_CHANGE, (IEventHandler)new IErrorMappingChangedListener(){

            @Override
            public void contentChange() {
                MetadataDefinitionCustomPage.this.validate();
                MetadataDefinitionCustomPage.this.relayout(MetadataDefinitionCustomPage.this.scrolledComposite, containerGroup);
                MetadataDefinitionCustomPage.this.dirty();
                MetadataDefinitionCustomPage.this.fireMetadataChanged();
            }
        });
        this.eventHelper.registerListener(this.eventBus, IDefinitionChangedListener.ON_DEFINITION_CHANGE, (IEventHandler)new IDefinitionChangedListener(){

            @Override
            public void contentChange() {
                MetadataDefinitionCustomPage.this.validate();
                MetadataDefinitionCustomPage.this.relayout(MetadataDefinitionCustomPage.this.scrolledComposite, containerGroup);
                MetadataDefinitionCustomPage.this.dirty();
                MetadataDefinitionCustomPage.this.fireMetadataChanged();
            }
        });
        this.eventHelper.registerUIListener(this.eventBus, ITableRowDeletedListener.ON_TABLE_ROW_DELETED, (IEventHandler)new ITableRowDeletedListener(){

            public void removed(DynamicRow row) {
                MetadataDefinitionCustomPage.this.validate();
                MetadataDefinitionCustomPage.this.relayout(MetadataDefinitionCustomPage.this.scrolledComposite, containerGroup);
                MetadataDefinitionCustomPage.this.dirty();
                MetadataDefinitionCustomPage.this.fireMetadataChanged();
            }
        });
        this.table.addTableContentChangedListener(() -> this.relayout(this.scrolledComposite, containerGroup));
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MetadataDefinitionCustomPage.this.eventHelper.unregister();
            }
        });
    }

    private void fireMetadataChanged() {
        List rows = this.table.getRows();
        ComponentId componentId = ComponentId.from((IMessageFlowEntity)this.node);
        if (!rows.isEmpty()) {
            this.saveMetadataDefinition(rows, new PropertyCollectionMap(), this.node, componentId);
        } else {
            this.removeMetadataDefinitionInformation(componentId);
        }
        this.getTypesManager().persistCustomTypes();
        this.eventBus.fireEvent((IEvent)new IEvent<IMetadataDefinitionChangedListener>(){

            public EventType<IMetadataDefinitionChangedListener> getAssociatedType() {
                return CoreEventTypes.ON_METADATA_DEFINITION_CHANGED;
            }

            public void dispatch(IMetadataDefinitionChangedListener handler) {
                handler.onMetadataDefinitionChanged(MetadataDefinitionCustomPage.this.getMuleProject());
            }
        });
    }

    protected void dirty() {
        if (!this.container.isDisposed() && !this.loading) {
            this.eventBus.fireEvent((IEvent)new IEvent<ICustomPageChangedListener>(){

                public EventType<ICustomPageChangedListener> getAssociatedType() {
                    return EditPartEventTypes.CUSTOM_PAGE_CONFIG_CHANGED;
                }

                public void dispatch(ICustomPageChangedListener handler) {
                    handler.configurationChanged();
                }
            });
        }
    }

    public void validate() {
        HashMap<DynamicContentType, DynamicRow> messageCacheMap = new HashMap<DynamicContentType, DynamicRow>();
        HashMap<DynamicContentType, List<String>> variablesCacheMap = new HashMap<DynamicContentType, List<String>>();
        for (DynamicRow row : this.table.getRows()) {
            row.clearError();
            DynamicContentType rowType = row.getContentType();
            if (this.typesManager.isMessageType(rowType)) {
                this.validateMessageRow(messageCacheMap, row, rowType);
                continue;
            }
            this.validateVariableRow(variablesCacheMap, row, rowType);
        }
    }

    private void validateVariableRow(Map<DynamicContentType, List<String>> variablesCache, DynamicRow row, DynamicContentType rowType) {
        MetadataDefinitionConfiguration contentConfiguration = (MetadataDefinitionConfiguration)row.save();
        if (StringUtils.isNotBlank((String)contentConfiguration.getVariableName())) {
            if (variablesCache.containsKey(rowType)) {
                List<String> variablesNames = variablesCache.get(rowType);
                if (variablesNames.contains(contentConfiguration.getVariableName())) {
                    String message = rowType.getLabel() + " name definition cannot be duplicated";
                    row.showError(message);
                } else {
                    variablesNames.add(contentConfiguration.getVariableName());
                }
            } else {
                ArrayList<String> variablesNames = new ArrayList<String>();
                variablesNames.add(contentConfiguration.getVariableName());
                variablesCache.put(rowType, variablesNames);
            }
        }
    }

    private void validateMessageRow(Map<DynamicContentType, DynamicRow> messageCache, DynamicRow row, DynamicContentType rowType) {
        if (messageCache.containsKey(rowType)) {
            String errorMessage = rowType.getLabel() + " definition cannot be duplicated";
            row.showError(errorMessage);
        } else {
            messageCache.put(rowType, row);
        }
    }

    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        ITypesManager typesManager;
        if (this.table.isDisposed() || this.loaded) {
            return;
        }
        this.loading = true;
        ComponentId componentId = ComponentId.from((IMessageFlowEntity)node);
        if (componentId.isDefined() && (typesManager = this.getTypesManager()) != null) {
            Optional maybeEnricher = typesManager.getEnricher(componentId);
            MessageRowType[] messageRowTypeArray = MessageRowType.values();
            int n = messageRowTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageRowType rowType = messageRowTypeArray[n2];
                List<MetadataDefinitionConfiguration> configurations = rowType.loadConfigFrom(maybeEnricher);
                if (configurations != null && !configurations.isEmpty()) {
                    this.table.addRows(configurations, false);
                }
                ++n2;
            }
        }
        this.loading = false;
        this.loaded = true;
        this.relayout(this.scrolledComposite, (Composite)this.container);
    }

    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        List rows = this.table.getRows();
        if (!rows.isEmpty()) {
            ComponentId componentId = ComponentId.from((IMessageFlowEntity)node);
            MetadataHelpers.defineComponentIdProperty(node, props, componentId);
        }
    }

    private void saveMetadataDefinition(List<DynamicRow> rows, PropertyCollectionMap properties, IMessageFlowNode node, ComponentId componentId) {
        componentId = MetadataHelpers.defineComponentIdProperty(node, properties, componentId);
        MetadataEventEnricher inputEnricher = new MetadataEventEnricher();
        MetadataEventEnricher outputEnricher = new MetadataEventEnricher();
        MessageRowType[] messageRowTypeArray = MessageRowType.values();
        int n = messageRowTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageRowType rowType = messageRowTypeArray[n2];
            List<MetadataDefinitionConfiguration> configsForType = this.getConfigsFrom(rows, rowType);
            if (!configsForType.isEmpty()) {
                rowType.processMetadataDefinitionConfig(configsForType, inputEnricher, outputEnricher);
            }
            ++n2;
        }
        ITypesManager typesManager = this.getTypesManager();
        if (typesManager != null) {
            typesManager.enrich(new MetadataEnricher(componentId, inputEnricher, outputEnricher, new MetadataOperationEnricher()));
        }
    }

    private void removeMetadataDefinitionInformation(ComponentId componentId) {
        ITypesManager typesManager;
        if (componentId.isDefined() && (typesManager = this.getTypesManager()) != null) {
            typesManager.removeEnricher(componentId);
        }
    }

    private ITypesManager getTypesManager() {
        return ((MetadataTypesManager)this.muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }

    private List<MetadataDefinitionConfiguration> getConfigsFrom(List<DynamicRow> rows, MessageRowType rowType) {
        ArrayList<MetadataDefinitionConfiguration> configs = new ArrayList<MetadataDefinitionConfiguration>();
        for (DynamicRow row : rows) {
            MetadataDefinitionConfiguration config = (MetadataDefinitionConfiguration)row.save();
            if (!config.getId().equals(rowType.getId())) continue;
            configs.add(config);
        }
        return configs;
    }

    public String getTitle() {
        return "Metadata";
    }

    public String getDescription() {
        return "Custom Metadata";
    }

    public boolean accepts(IMessageFlowNode node) {
        boolean isGlobal = node instanceof GlobalElement;
        boolean isSAP = "http://www.mulesoft.org/schema/mule/sap/endpoint".equals(node.getType());
        boolean isRoute = node instanceof Route;
        if (isGlobal || isSAP || isRoute) {
            return false;
        }
        boolean isConnector = MetadataHelpers.isCloudConnector(node);
        if (isConnector) {
            return MetadataHelpers.isNodeAllowCustomMetadataDefinition(node);
        }
        return true;
    }

    public void setMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    private void relayout(ScrolledComposite scrolledComposite, Composite contributed) {
        Point panelSize = contributed.computeSize(-1, -1);
        scrolledComposite.setMinSize(-1, panelSize.y);
        scrolledComposite.layout(true, true);
    }

    public IMessageFlowNode getNode() {
        return this.node;
    }

    public void setNode(IMessageFlowNode node) {
        this.node = node;
    }

    public void setMessageLogger(IMessageLogger messageLogger) {
    }

    private boolean shouldPropagateMetadata() {
        boolean targeHasDocId;
        String targeFlowName = this.node.getProperties().getProperty("name") != null ? ((IReadOnlyProperty)this.node.getProperties().getProperty("name")).getValue() : "";
        Container targetFlowContainer = null;
        for (MuleConfiguration config : this.getMuleProject().getConfigurationsCache().getConfigurations()) {
            if (!config.getFlow(targeFlowName).isPresent()) continue;
            targetFlowContainer = (Container)config.getFlow(targeFlowName).get();
            break;
        }
        boolean bl = targeHasDocId = targetFlowContainer != null && !StringUtils.isEmpty((String)ComponentId.from(targetFlowContainer).getId());
        return targeHasDocId && !StringUtils.isEmpty((String)this.node.getElement().getAttributeValue("doc:id"));
    }

    private void handleClick(Event event) {
        List configs = this.getMuleProject().getConfigurationsCache().getConfigurations();
        if (this.node.getProperties().getProperty("name") != null) {
            String flowRefName = ((IReadOnlyProperty)this.node.getProperties().getProperty("name")).getValue();
            ArrayList flows = new ArrayList();
            configs.forEach(config -> {
                boolean bl = flows.addAll(config.getFlows());
            });
            long flowReferencesCount = flows.stream().filter(flow -> flow.getName().equals(flowRefName)).count();
            if (flowReferencesCount == 1L) {
                for (MuleConfiguration muleConfig : configs) {
                    if (!muleConfig.getFlow(flowRefName).isPresent()) continue;
                    MulePath originPath = MessageFlowUtils.getMuleConfigFromActivePage().getPathFor((IMessageFlowEntity)this.node);
                    Container referencedFlow = (Container)muleConfig.getFlow(flowRefName).get();
                    String mainText = "This will overwrite the " + flowRefName + " flow metadata. Do you want to continue?";
                    if (this.exportMetadataConfirmationDialog == null) {
                        this.exportMetadataToFlowRefDialog = new ExportMetadataToFlowRefDialog(this.container.getShell(), this.customMetadataAssistantService, referencedFlow, originPath, CONTENT, Events.PROPAGATE_METADATA_FLOW_REF_SET_METADATA_ADVANCED);
                        this.exportMetadataConfirmationDialog = new ExportMetadataConfirmationDialog(this.container.getShell(), (Dialog)this.exportMetadataToFlowRefDialog, mainText, TITLE, this.customMetadataAssistantService, referencedFlow, originPath, Events.PROPAGATE_METADATA_FLOW_REF_SET_METADATA_BASIC);
                        this.exportMetadataToFlowRefDialog.setParentDialog(this.exportMetadataConfirmationDialog);
                    }
                    if (!this.exportMetadataConfirmationDialog.getChildOpen().booleanValue()) {
                        this.exportMetadataConfirmationDialog.open();
                        continue;
                    }
                    this.exportMetadataConfirmationDialog = null;
                }
            } else if (flowReferencesCount > 1L) {
                new ErrorActionDialog(this.container.getShell(), MORE_THAN_ONE_TITLE, String.format(MORE_THAN_ONE_BODY, flowRefName)).open();
            } else {
                new ErrorActionDialog(this.container.getShell(), NO_FLOW_DIALOG_TITLE, NO_FLOW_DIALOG_BODY).open();
            }
        }
    }
}

