/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageMetadataEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.VariablesMetadataEditor;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentType;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManager;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManagerFilter;
import org.mule.tooling.utils.eventbus.EventBus;

public class MessageRowTypesManager
implements TypesManager {
    List<DynamicContentType> rowTypes;
    private IMuleProject muleProject;
    private EventBus eventBus;
    private List<DynamicContentType> selectedTypes;
    private List<TypesManagerFilter> filters;

    public MessageRowTypesManager(IMuleProject muleProject, EventBus eventBus) {
        this.muleProject = muleProject;
        this.eventBus = eventBus;
        this.rowTypes = new ArrayList<DynamicContentType>();
        this.filters = new ArrayList<TypesManagerFilter>();
        this.selectedTypes = new ArrayList<DynamicContentType>();
    }

    public List<DynamicContentType> getTypes() {
        if (this.rowTypes.isEmpty()) {
            this.fillTypes();
        }
        ArrayList<DynamicContentType> response = new ArrayList<DynamicContentType>();
        for (DynamicContentType type : this.rowTypes) {
            if (!this.isNotFiltered(type)) continue;
            if (this.isMessageType(type)) {
                if (this.selectedTypes.contains(type)) continue;
                response.add(type);
                continue;
            }
            response.add(type);
        }
        return response;
    }

    private boolean isNotFiltered(DynamicContentType type) {
        for (TypesManagerFilter filter : this.filters) {
            if (filter.isValid(type.getId())) continue;
            return false;
        }
        return true;
    }

    public boolean isMessageType(DynamicContentType type) {
        boolean isOutputMessage;
        boolean isInputMessage = MessageRowType.INPUT_PAYLOAD.getId().equals(type.getId()) || MessageRowType.INPUT_ATTRIBUTES.getId().equals(type.getId());
        boolean bl = isOutputMessage = MessageRowType.OUTPUT_PAYLOAD.getId().equals(type.getId()) || MessageRowType.OUTPUT_ATTRIBUTES.getId().equals(type.getId());
        return isInputMessage || isOutputMessage;
    }

    private void fillTypes() {
        this.rowTypes.add(new DynamicContentType(MessageRowType.INPUT_PAYLOAD.getDisplayName(), MessageRowType.INPUT_PAYLOAD.getId(), (DynamicContentType.ParameterBuilder)new MessageContentBuilder(this.muleProject, this.eventBus)));
        this.rowTypes.add(new DynamicContentType(MessageRowType.INPUT_ATTRIBUTES.getDisplayName(), MessageRowType.INPUT_ATTRIBUTES.getId(), (DynamicContentType.ParameterBuilder)new MessageContentBuilder(this.muleProject, this.eventBus)));
        this.rowTypes.add(new DynamicContentType(MessageRowType.INPUT_VARIABLES.getDisplayName(), MessageRowType.INPUT_VARIABLES.getId(), (DynamicContentType.ParameterBuilder)new VariablesContentBuilder(this.muleProject, this.eventBus)));
        this.rowTypes.add(new DynamicContentType(MessageRowType.OUTPUT_PAYLOAD.getDisplayName(), MessageRowType.OUTPUT_PAYLOAD.getId(), (DynamicContentType.ParameterBuilder)new MessageContentBuilder(this.muleProject, this.eventBus)));
        this.rowTypes.add(new DynamicContentType(MessageRowType.OUTPUT_ATTRIBUTES.getDisplayName(), MessageRowType.OUTPUT_ATTRIBUTES.getId(), (DynamicContentType.ParameterBuilder)new MessageContentBuilder(this.muleProject, this.eventBus)));
        this.rowTypes.add(new DynamicContentType(MessageRowType.OUTPUT_VARIABLES.getDisplayName(), MessageRowType.OUTPUT_VARIABLES.getId(), (DynamicContentType.ParameterBuilder)new VariablesContentBuilder(this.muleProject, this.eventBus)));
    }

    public Optional<DynamicContentType> getType(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Type Id cannot be null");
        }
        if (this.rowTypes.isEmpty()) {
            this.fillTypes();
        }
        for (DynamicContentType type : this.rowTypes) {
            if (!type.getId().equals(id)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public void setSelectedTypes(List<DynamicContentType> types) {
        if (types == null) {
            throw new IllegalArgumentException("Selected Types List Cannot Be Null");
        }
        this.selectedTypes = types;
    }

    public void addFilter(TypesManagerFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(TypesManagerFilter filter) {
        if (this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    private static class MessageContentBuilder
    implements DynamicContentType.ParameterBuilder {
        private IMuleProject muleProject;
        private EventBus eventBus;

        public MessageContentBuilder(IMuleProject muleProject, EventBus eventBus) {
            this.muleProject = muleProject;
            this.eventBus = eventBus;
        }

        public DynamicContent create() {
            return new MessageMetadataEditor(this.muleProject, this.eventBus);
        }
    }

    private static class VariablesContentBuilder
    implements DynamicContentType.ParameterBuilder {
        private IMuleProject muleProject;
        private EventBus eventBus;

        public VariablesContentBuilder(IMuleProject muleProject, EventBus eventBus) {
            this.muleProject = muleProject;
            this.eventBus = eventBus;
        }

        public DynamicContent create() {
            return new VariablesMetadataEditor(this.muleProject, this.eventBus);
        }
    }
}

